/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hc.client5.http.cache.Resource;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;

@Contract(threading=ThreadingBehavior.SAFE)
public class FileResource
implements Resource {
    private static final long serialVersionUID = 4132244415919043397L;
    private final File file;
    private volatile boolean disposed;

    public FileResource(File file) {
        this.file = file;
        this.disposed = false;
    }

    synchronized File getFile() {
        return this.file;
    }

    @Override
    public synchronized InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    @Override
    public synchronized long length() {
        return this.file.length();
    }

    @Override
    public synchronized void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        this.file.delete();
    }
}

