/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.cache.CacheResponseStatus;
import org.apache.hc.client5.http.cache.HttpCacheEntry;
import org.apache.hc.client5.http.cache.HttpCacheStorage;
import org.apache.hc.client5.http.cache.ResourceFactory;
import org.apache.hc.client5.http.impl.cache.AsynchronousValidator;
import org.apache.hc.client5.http.impl.cache.BasicHttpCache;
import org.apache.hc.client5.http.impl.cache.CacheConfig;
import org.apache.hc.client5.http.impl.cache.CacheValidityPolicy;
import org.apache.hc.client5.http.impl.cache.CacheableRequestPolicy;
import org.apache.hc.client5.http.impl.cache.CachedHttpResponseGenerator;
import org.apache.hc.client5.http.impl.cache.CachedResponseSuitabilityChecker;
import org.apache.hc.client5.http.impl.cache.ConditionalRequestBuilder;
import org.apache.hc.client5.http.impl.cache.HttpCache;
import org.apache.hc.client5.http.impl.cache.IOUtils;
import org.apache.hc.client5.http.impl.cache.OptionsHttp11Response;
import org.apache.hc.client5.http.impl.cache.RequestProtocolCompliance;
import org.apache.hc.client5.http.impl.cache.RequestProtocolError;
import org.apache.hc.client5.http.impl.cache.ResponseCachingPolicy;
import org.apache.hc.client5.http.impl.cache.ResponseProtocolCompliance;
import org.apache.hc.client5.http.impl.cache.Variant;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.sync.ExecChain;
import org.apache.hc.client5.http.sync.ExecChainHandler;
import org.apache.hc.client5.http.utils.DateUtils;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HeaderElement;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpMessage;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.MessageHeaders;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.message.BasicClassicHttpResponse;
import org.apache.hc.core5.http.message.MessageSupport;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.VersionInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Contract(threading=ThreadingBehavior.SAFE)
public class CachingExec
implements ExecChainHandler {
    private static final boolean SUPPORTS_RANGE_AND_CONTENT_RANGE_HEADERS = false;
    private final AtomicLong cacheHits = new AtomicLong();
    private final AtomicLong cacheMisses = new AtomicLong();
    private final AtomicLong cacheUpdates = new AtomicLong();
    private final Map<ProtocolVersion, String> viaHeaders = new HashMap<ProtocolVersion, String>(4);
    private final CacheConfig cacheConfig;
    private final HttpCache responseCache;
    private final CacheValidityPolicy validityPolicy;
    private final CachedHttpResponseGenerator responseGenerator;
    private final CacheableRequestPolicy cacheableRequestPolicy;
    private final CachedResponseSuitabilityChecker suitabilityChecker;
    private final ConditionalRequestBuilder conditionalRequestBuilder;
    private final ResponseProtocolCompliance responseCompliance;
    private final RequestProtocolCompliance requestCompliance;
    private final ResponseCachingPolicy responseCachingPolicy;
    private final AsynchronousValidator asynchRevalidator;
    private final Logger log = LogManager.getLogger(this.getClass());

    public CachingExec(HttpCache cache, CacheConfig config) {
        this(cache, config, null);
    }

    public CachingExec(HttpCache cache, CacheConfig config, AsynchronousValidator asynchRevalidator) {
        Args.notNull((Object)cache, (String)"HttpCache");
        this.cacheConfig = config != null ? config : CacheConfig.DEFAULT;
        this.responseCache = cache;
        this.validityPolicy = new CacheValidityPolicy();
        this.responseGenerator = new CachedHttpResponseGenerator(this.validityPolicy);
        this.cacheableRequestPolicy = new CacheableRequestPolicy();
        this.suitabilityChecker = new CachedResponseSuitabilityChecker(this.validityPolicy, this.cacheConfig);
        this.conditionalRequestBuilder = new ConditionalRequestBuilder();
        this.responseCompliance = new ResponseProtocolCompliance();
        this.requestCompliance = new RequestProtocolCompliance(this.cacheConfig.isWeakETagOnPutDeleteAllowed());
        this.responseCachingPolicy = new ResponseCachingPolicy(this.cacheConfig.getMaxObjectSize(), this.cacheConfig.isSharedCache(), this.cacheConfig.isNeverCacheHTTP10ResponsesWithQuery(), this.cacheConfig.is303CachingEnabled());
        this.asynchRevalidator = asynchRevalidator;
    }

    public CachingExec(ResourceFactory resourceFactory, HttpCacheStorage storage, CacheConfig config) {
        this(new BasicHttpCache(resourceFactory, storage, config), config);
    }

    public CachingExec() {
        this(new BasicHttpCache(), CacheConfig.DEFAULT);
    }

    CachingExec(HttpCache responseCache, CacheValidityPolicy validityPolicy, ResponseCachingPolicy responseCachingPolicy, CachedHttpResponseGenerator responseGenerator, CacheableRequestPolicy cacheableRequestPolicy, CachedResponseSuitabilityChecker suitabilityChecker, ConditionalRequestBuilder conditionalRequestBuilder, ResponseProtocolCompliance responseCompliance, RequestProtocolCompliance requestCompliance, CacheConfig config, AsynchronousValidator asynchRevalidator) {
        this.cacheConfig = config != null ? config : CacheConfig.DEFAULT;
        this.responseCache = responseCache;
        this.validityPolicy = validityPolicy;
        this.responseCachingPolicy = responseCachingPolicy;
        this.responseGenerator = responseGenerator;
        this.cacheableRequestPolicy = cacheableRequestPolicy;
        this.suitabilityChecker = suitabilityChecker;
        this.conditionalRequestBuilder = conditionalRequestBuilder;
        this.responseCompliance = responseCompliance;
        this.requestCompliance = requestCompliance;
        this.asynchRevalidator = asynchRevalidator;
    }

    public long getCacheHits() {
        return this.cacheHits.get();
    }

    public long getCacheMisses() {
        return this.cacheMisses.get();
    }

    public long getCacheUpdates() {
        return this.cacheUpdates.get();
    }

    @Override
    public ClassicHttpResponse execute(ClassicHttpRequest request, ExecChain.Scope scope, ExecChain chain) throws IOException, HttpException {
        Args.notNull((Object)request, (String)"HTTP request");
        Args.notNull((Object)scope, (String)"Scope");
        HttpRoute route = scope.route;
        HttpClientContext context = scope.clientContext;
        URIAuthority authority = request.getAuthority();
        String scheme = request.getScheme();
        HttpHost target = authority != null ? new HttpHost((NamedEndpoint)authority, scheme) : route.getTargetHost();
        String via = this.generateViaHeader((HttpMessage)request);
        this.setResponseStatus((HttpContext)context, CacheResponseStatus.CACHE_MISS);
        if (this.clientRequestsOurOptions((HttpRequest)request)) {
            this.setResponseStatus((HttpContext)context, CacheResponseStatus.CACHE_MODULE_RESPONSE);
            return new OptionsHttp11Response();
        }
        ClassicHttpResponse fatalErrorResponse = this.getFatallyNoncompliantResponse(request, (HttpContext)context);
        if (fatalErrorResponse != null) {
            return fatalErrorResponse;
        }
        this.requestCompliance.makeRequestCompliant(request);
        request.addHeader("Via", (Object)via);
        this.flushEntriesInvalidatedByRequest(target, request);
        if (!this.cacheableRequestPolicy.isServableFromCache((HttpRequest)request)) {
            this.log.debug("Request is not servable from cache");
            return this.callBackend(target, request, scope, chain);
        }
        HttpCacheEntry entry = this.satisfyFromCache(target, request);
        if (entry == null) {
            this.log.debug("Cache miss");
            return this.handleCacheMiss(target, request, scope, chain);
        }
        return this.handleCacheHit(target, request, scope, chain, entry);
    }

    private ClassicHttpResponse handleCacheHit(HttpHost target, ClassicHttpRequest request, ExecChain.Scope scope, ExecChain chain, HttpCacheEntry entry) throws IOException, HttpException {
        ClassicHttpResponse out;
        HttpRoute route = scope.route;
        HttpClientContext context = scope.clientContext;
        this.recordCacheHit(target, request);
        Date now = this.getCurrentDate();
        if (this.suitabilityChecker.canCachedResponseBeUsed(target, (HttpRequest)request, entry, now)) {
            this.log.debug("Cache hit");
            out = this.generateCachedResponse(request, (HttpContext)context, entry, now);
        } else if (!this.mayCallBackend(request)) {
            this.log.debug("Cache entry not suitable but only-if-cached requested");
            out = this.generateGatewayTimeout((HttpContext)context);
        } else {
            if (entry.getStatus() != 304 || this.suitabilityChecker.isConditional((HttpRequest)request)) {
                this.log.debug("Revalidating cache entry");
                return this.revalidateCacheEntry(target, request, scope, chain, entry, now);
            }
            this.log.debug("Cache entry not usable; calling backend");
            return this.callBackend(target, request, scope, chain);
        }
        context.setAttribute("http.route", route);
        context.setAttribute("http.request", request);
        context.setAttribute("http.response", out);
        return out;
    }

    private ClassicHttpResponse revalidateCacheEntry(HttpHost target, ClassicHttpRequest request, ExecChain.Scope scope, ExecChain chain, HttpCacheEntry entry, Date now) throws HttpException {
        HttpClientContext context = scope.clientContext;
        try {
            if (this.asynchRevalidator != null && !this.staleResponseNotAllowed(request, entry, now) && this.validityPolicy.mayReturnStaleWhileRevalidating(entry, now)) {
                this.log.trace("Serving stale with asynchronous revalidation");
                ClassicHttpResponse resp = this.generateCachedResponse(request, (HttpContext)context, entry, now);
                this.asynchRevalidator.revalidateCacheEntry(this, target, request, scope, chain, entry);
                return resp;
            }
            return this.revalidateCacheEntry(target, request, scope, chain, entry);
        }
        catch (IOException ioex) {
            return this.handleRevalidationFailure(request, (HttpContext)context, entry, now);
        }
    }

    private ClassicHttpResponse handleCacheMiss(HttpHost target, ClassicHttpRequest request, ExecChain.Scope scope, ExecChain chain) throws IOException, HttpException {
        this.recordCacheMiss(target, request);
        if (!this.mayCallBackend(request)) {
            return new BasicClassicHttpResponse(504, "Gateway Timeout");
        }
        Map<String, Variant> variants = this.getExistingCacheVariants(target, request);
        if (variants != null && !variants.isEmpty()) {
            return this.negotiateResponseFromVariants(target, request, scope, chain, variants);
        }
        return this.callBackend(target, request, scope, chain);
    }

    private HttpCacheEntry satisfyFromCache(HttpHost target, ClassicHttpRequest request) {
        HttpCacheEntry entry = null;
        try {
            entry = this.responseCache.getCacheEntry(target, (HttpRequest)request);
        }
        catch (IOException ioe) {
            this.log.warn("Unable to retrieve entries from cache", (Throwable)ioe);
        }
        return entry;
    }

    private ClassicHttpResponse getFatallyNoncompliantResponse(ClassicHttpRequest request, HttpContext context) {
        ClassicHttpResponse fatalErrorResponse = null;
        List<RequestProtocolError> fatalError = this.requestCompliance.requestIsFatallyNonCompliant((HttpRequest)request);
        for (RequestProtocolError error : fatalError) {
            this.setResponseStatus(context, CacheResponseStatus.CACHE_MODULE_RESPONSE);
            fatalErrorResponse = this.requestCompliance.getErrorForRequest(error);
        }
        return fatalErrorResponse;
    }

    private Map<String, Variant> getExistingCacheVariants(HttpHost target, ClassicHttpRequest request) {
        Map<String, Variant> variants = null;
        try {
            variants = this.responseCache.getVariantCacheEntriesWithEtags(target, (HttpRequest)request);
        }
        catch (IOException ioe) {
            this.log.warn("Unable to retrieve variant entries from cache", (Throwable)ioe);
        }
        return variants;
    }

    private void recordCacheMiss(HttpHost target, ClassicHttpRequest request) {
        this.cacheMisses.getAndIncrement();
        if (this.log.isTraceEnabled()) {
            this.log.trace("Cache miss [host: " + target + "; uri: " + request.getRequestUri() + "]");
        }
    }

    private void recordCacheHit(HttpHost target, ClassicHttpRequest request) {
        this.cacheHits.getAndIncrement();
        if (this.log.isTraceEnabled()) {
            this.log.trace("Cache hit [host: " + target + "; uri: " + request.getRequestUri() + "]");
        }
    }

    private void recordCacheUpdate(HttpContext context) {
        this.cacheUpdates.getAndIncrement();
        this.setResponseStatus(context, CacheResponseStatus.VALIDATED);
    }

    private void flushEntriesInvalidatedByRequest(HttpHost target, ClassicHttpRequest request) {
        try {
            this.responseCache.flushInvalidatedCacheEntriesFor(target, (HttpRequest)request);
        }
        catch (IOException ioe) {
            this.log.warn("Unable to flush invalidated entries from cache", (Throwable)ioe);
        }
    }

    private ClassicHttpResponse generateCachedResponse(ClassicHttpRequest request, HttpContext context, HttpCacheEntry entry, Date now) {
        ClassicHttpResponse cachedResponse = request.containsHeader("If-None-Match") || request.containsHeader("If-Modified-Since") ? this.responseGenerator.generateNotModifiedResponse(entry) : this.responseGenerator.generateResponse((HttpRequest)request, entry);
        this.setResponseStatus(context, CacheResponseStatus.CACHE_HIT);
        if (this.validityPolicy.getStalenessSecs(entry, now) > 0L) {
            cachedResponse.addHeader("Warning", (Object)"110 localhost \"Response is stale\"");
        }
        return cachedResponse;
    }

    private ClassicHttpResponse handleRevalidationFailure(ClassicHttpRequest request, HttpContext context, HttpCacheEntry entry, Date now) {
        if (this.staleResponseNotAllowed(request, entry, now)) {
            return this.generateGatewayTimeout(context);
        }
        return this.unvalidatedCacheHit(request, context, entry);
    }

    private ClassicHttpResponse generateGatewayTimeout(HttpContext context) {
        this.setResponseStatus(context, CacheResponseStatus.CACHE_MODULE_RESPONSE);
        return new BasicClassicHttpResponse(504, "Gateway Timeout");
    }

    private ClassicHttpResponse unvalidatedCacheHit(ClassicHttpRequest request, HttpContext context, HttpCacheEntry entry) {
        ClassicHttpResponse cachedResponse = this.responseGenerator.generateResponse((HttpRequest)request, entry);
        this.setResponseStatus(context, CacheResponseStatus.CACHE_HIT);
        cachedResponse.addHeader("Warning", (Object)"111 localhost \"Revalidation failed\"");
        return cachedResponse;
    }

    private boolean staleResponseNotAllowed(ClassicHttpRequest request, HttpCacheEntry entry, Date now) {
        return this.validityPolicy.mustRevalidate(entry) || this.cacheConfig.isSharedCache() && this.validityPolicy.proxyRevalidate(entry) || this.explicitFreshnessRequest(request, entry, now);
    }

    private boolean mayCallBackend(ClassicHttpRequest request) {
        Iterator it = MessageSupport.iterate((MessageHeaders)request, (String)"Cache-Control");
        while (it.hasNext()) {
            HeaderElement elt = (HeaderElement)it.next();
            if (!"only-if-cached".equals(elt.getName())) continue;
            this.log.trace("Request marked only-if-cached");
            return false;
        }
        return true;
    }

    private boolean explicitFreshnessRequest(ClassicHttpRequest request, HttpCacheEntry entry, Date now) {
        Iterator it = MessageSupport.iterate((MessageHeaders)request, (String)"Cache-Control");
        while (it.hasNext()) {
            HeaderElement elt = (HeaderElement)it.next();
            if ("max-stale".equals(elt.getName())) {
                try {
                    long lifetime;
                    int maxstale = Integer.parseInt(elt.getValue());
                    long age = this.validityPolicy.getCurrentAgeSecs(entry, now);
                    if (age - (lifetime = this.validityPolicy.getFreshnessLifetimeSecs(entry)) <= (long)maxstale) continue;
                    return true;
                }
                catch (NumberFormatException nfe) {
                    return true;
                }
            }
            if (!"min-fresh".equals(elt.getName()) && !"max-age".equals(elt.getName())) continue;
            return true;
        }
        return false;
    }

    private String generateViaHeader(HttpMessage msg) {
        if (msg.getVersion() == null) {
            msg.setVersion((ProtocolVersion)HttpVersion.DEFAULT);
        }
        ProtocolVersion pv = msg.getVersion();
        String existingEntry = this.viaHeaders.get(msg.getVersion());
        if (existingEntry != null) {
            return existingEntry;
        }
        VersionInfo vi = VersionInfo.loadVersionInfo((String)"org.apache.hc.client5", (ClassLoader)this.getClass().getClassLoader());
        String release = vi != null ? vi.getRelease() : "UNAVAILABLE";
        int major = pv.getMajor();
        int minor = pv.getMinor();
        String value = "http".equalsIgnoreCase(pv.getProtocol()) ? String.format("%d.%d localhost (Apache-HttpClient/%s (cache))", major, minor, release) : String.format("%s/%d.%d localhost (Apache-HttpClient/%s (cache))", pv.getProtocol(), major, minor, release);
        this.viaHeaders.put(pv, value);
        return value;
    }

    private void setResponseStatus(HttpContext context, CacheResponseStatus value) {
        if (context != null) {
            context.setAttribute("http.cache.response.status", (Object)value);
        }
    }

    public boolean supportsRangeAndContentRangeHeaders() {
        return false;
    }

    Date getCurrentDate() {
        return new Date();
    }

    boolean clientRequestsOurOptions(HttpRequest request) {
        if (!"OPTIONS".equals(request.getMethod())) {
            return false;
        }
        if (!"*".equals(request.getRequestUri())) {
            return false;
        }
        return "0".equals(request.getFirstHeader("Max-Forwards").getValue());
    }

    ClassicHttpResponse callBackend(HttpHost target, ClassicHttpRequest request, ExecChain.Scope scope, ExecChain chain) throws IOException, HttpException {
        Date requestDate = this.getCurrentDate();
        this.log.trace("Calling the backend");
        ClassicHttpResponse backendResponse = chain.proceed(request, scope);
        try {
            backendResponse.addHeader("Via", (Object)this.generateViaHeader((HttpMessage)backendResponse));
            return this.handleBackendResponse(target, request, scope, requestDate, this.getCurrentDate(), backendResponse);
        }
        catch (IOException | RuntimeException ex) {
            backendResponse.close();
            throw ex;
        }
    }

    private boolean revalidationResponseIsTooOld(HttpResponse backendResponse, HttpCacheEntry cacheEntry) {
        Header entryDateHeader = cacheEntry.getFirstHeader("Date");
        Header responseDateHeader = backendResponse.getFirstHeader("Date");
        if (entryDateHeader != null && responseDateHeader != null) {
            Date entryDate = DateUtils.parseDate(entryDateHeader.getValue());
            Date respDate = DateUtils.parseDate(responseDateHeader.getValue());
            if (entryDate == null || respDate == null) {
                return false;
            }
            if (respDate.before(entryDate)) {
                return true;
            }
        }
        return false;
    }

    ClassicHttpResponse negotiateResponseFromVariants(HttpHost target, ClassicHttpRequest request, ExecChain.Scope scope, ExecChain chain, Map<String, Variant> variants) throws IOException, HttpException {
        ClassicHttpRequest conditionalRequest = this.conditionalRequestBuilder.buildConditionalRequestFromVariants(request, variants);
        Date requestDate = this.getCurrentDate();
        ClassicHttpResponse backendResponse = chain.proceed(conditionalRequest, scope);
        try {
            Date responseDate = this.getCurrentDate();
            backendResponse.addHeader("Via", (Object)this.generateViaHeader((HttpMessage)backendResponse));
            if (backendResponse.getCode() != 304) {
                return this.handleBackendResponse(target, request, scope, requestDate, responseDate, backendResponse);
            }
            Header resultEtagHeader = backendResponse.getFirstHeader("ETag");
            if (resultEtagHeader == null) {
                this.log.warn("304 response did not contain ETag");
                IOUtils.consume(backendResponse.getEntity());
                backendResponse.close();
                return this.callBackend(target, request, scope, chain);
            }
            String resultEtag = resultEtagHeader.getValue();
            Variant matchingVariant = variants.get(resultEtag);
            if (matchingVariant == null) {
                this.log.debug("304 response did not contain ETag matching one sent in If-None-Match");
                IOUtils.consume(backendResponse.getEntity());
                backendResponse.close();
                return this.callBackend(target, request, scope, chain);
            }
            HttpCacheEntry matchedEntry = matchingVariant.getEntry();
            if (this.revalidationResponseIsTooOld((HttpResponse)backendResponse, matchedEntry)) {
                IOUtils.consume(backendResponse.getEntity());
                backendResponse.close();
                return this.retryRequestUnconditionally(target, request, scope, chain);
            }
            this.recordCacheUpdate((HttpContext)scope.clientContext);
            HttpCacheEntry responseEntry = this.getUpdatedVariantEntry(target, conditionalRequest, requestDate, responseDate, backendResponse, matchingVariant, matchedEntry);
            backendResponse.close();
            ClassicHttpResponse resp = this.responseGenerator.generateResponse((HttpRequest)request, responseEntry);
            this.tryToUpdateVariantMap(target, request, matchingVariant);
            if (this.shouldSendNotModifiedResponse(request, responseEntry)) {
                return this.responseGenerator.generateNotModifiedResponse(responseEntry);
            }
            return resp;
        }
        catch (IOException | RuntimeException ex) {
            backendResponse.close();
            throw ex;
        }
    }

    private ClassicHttpResponse retryRequestUnconditionally(HttpHost target, ClassicHttpRequest request, ExecChain.Scope scope, ExecChain chain) throws IOException, HttpException {
        ClassicHttpRequest unconditional = this.conditionalRequestBuilder.buildUnconditionalRequest(request);
        return this.callBackend(target, unconditional, scope, chain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpCacheEntry getUpdatedVariantEntry(HttpHost target, ClassicHttpRequest conditionalRequest, Date requestDate, Date responseDate, ClassicHttpResponse backendResponse, Variant matchingVariant, HttpCacheEntry matchedEntry) throws IOException {
        HttpCacheEntry responseEntry = matchedEntry;
        try {
            responseEntry = this.responseCache.updateVariantCacheEntry(target, (HttpRequest)conditionalRequest, matchedEntry, (HttpResponse)backendResponse, requestDate, responseDate, matchingVariant.getCacheKey());
        }
        catch (IOException ioe) {
            this.log.warn("Could not processChallenge cache entry", (Throwable)ioe);
        }
        finally {
            backendResponse.close();
        }
        return responseEntry;
    }

    private void tryToUpdateVariantMap(HttpHost target, ClassicHttpRequest request, Variant matchingVariant) {
        try {
            this.responseCache.reuseVariantEntryFor(target, (HttpRequest)request, matchingVariant);
        }
        catch (IOException ioe) {
            this.log.warn("Could not processChallenge cache entry to reuse variant", (Throwable)ioe);
        }
    }

    private boolean shouldSendNotModifiedResponse(ClassicHttpRequest request, HttpCacheEntry responseEntry) {
        return this.suitabilityChecker.isConditional((HttpRequest)request) && this.suitabilityChecker.allConditionalsMatch((HttpRequest)request, responseEntry, new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClassicHttpResponse revalidateCacheEntry(HttpHost target, ClassicHttpRequest request, ExecChain.Scope scope, ExecChain chain, HttpCacheEntry cacheEntry) throws IOException, HttpException {
        ClassicHttpRequest conditionalRequest = this.conditionalRequestBuilder.buildConditionalRequest(scope.originalRequest, cacheEntry);
        Date requestDate = this.getCurrentDate();
        ClassicHttpResponse backendResponse = chain.proceed(conditionalRequest, scope);
        Date responseDate = this.getCurrentDate();
        if (this.revalidationResponseIsTooOld((HttpResponse)backendResponse, cacheEntry)) {
            backendResponse.close();
            ClassicHttpRequest unconditional = this.conditionalRequestBuilder.buildUnconditionalRequest(scope.originalRequest);
            requestDate = this.getCurrentDate();
            backendResponse = chain.proceed(unconditional, scope);
            responseDate = this.getCurrentDate();
        }
        backendResponse.addHeader("Via", (Object)this.generateViaHeader((HttpMessage)backendResponse));
        int statusCode = backendResponse.getCode();
        if (statusCode == 304 || statusCode == 200) {
            this.recordCacheUpdate((HttpContext)scope.clientContext);
        }
        if (statusCode == 304) {
            HttpCacheEntry updatedEntry = this.responseCache.updateCacheEntry(target, (HttpRequest)request, cacheEntry, (HttpResponse)backendResponse, requestDate, responseDate);
            if (this.suitabilityChecker.isConditional((HttpRequest)request) && this.suitabilityChecker.allConditionalsMatch((HttpRequest)request, updatedEntry, new Date())) {
                return this.responseGenerator.generateNotModifiedResponse(updatedEntry);
            }
            return this.responseGenerator.generateResponse((HttpRequest)request, updatedEntry);
        }
        if (this.staleIfErrorAppliesTo(statusCode) && !this.staleResponseNotAllowed(request, cacheEntry, this.getCurrentDate()) && this.validityPolicy.mayReturnStaleIfError((HttpRequest)request, cacheEntry, responseDate)) {
            try {
                ClassicHttpResponse cachedResponse = this.responseGenerator.generateResponse((HttpRequest)request, cacheEntry);
                cachedResponse.addHeader("Warning", (Object)"110 localhost \"Response is stale\"");
                ClassicHttpResponse classicHttpResponse = cachedResponse;
                return classicHttpResponse;
            }
            finally {
                backendResponse.close();
            }
        }
        return this.handleBackendResponse(target, conditionalRequest, scope, requestDate, responseDate, backendResponse);
    }

    private boolean staleIfErrorAppliesTo(int statusCode) {
        return statusCode == 500 || statusCode == 502 || statusCode == 503 || statusCode == 504;
    }

    ClassicHttpResponse handleBackendResponse(HttpHost target, ClassicHttpRequest request, ExecChain.Scope scope, Date requestDate, Date responseDate, ClassicHttpResponse backendResponse) throws IOException {
        this.log.trace("Handling Backend response");
        this.responseCompliance.ensureProtocolCompliance(scope.originalRequest, request, backendResponse);
        boolean cacheable = this.responseCachingPolicy.isResponseCacheable((HttpRequest)request, (HttpResponse)backendResponse);
        this.responseCache.flushInvalidatedCacheEntriesFor(target, (HttpRequest)request, (HttpResponse)backendResponse);
        if (cacheable && !this.alreadyHaveNewerCacheEntry(target, request, (HttpResponse)backendResponse)) {
            this.storeRequestIfModifiedSinceFor304Response((HttpRequest)request, (HttpResponse)backendResponse);
            return this.responseCache.cacheAndReturnResponse(target, (HttpRequest)request, backendResponse, requestDate, responseDate);
        }
        if (!cacheable) {
            try {
                this.responseCache.flushCacheEntriesFor(target, (HttpRequest)request);
            }
            catch (IOException ioe) {
                this.log.warn("Unable to flush invalid cache entries", (Throwable)ioe);
            }
        }
        return backendResponse;
    }

    private void storeRequestIfModifiedSinceFor304Response(HttpRequest request, HttpResponse backendResponse) {
        Header h;
        if (backendResponse.getCode() == 304 && (h = request.getFirstHeader("If-Modified-Since")) != null) {
            backendResponse.addHeader("Last-Modified", (Object)h.getValue());
        }
    }

    private boolean alreadyHaveNewerCacheEntry(HttpHost target, ClassicHttpRequest request, HttpResponse backendResponse) {
        HttpCacheEntry existing = null;
        try {
            existing = this.responseCache.getCacheEntry(target, (HttpRequest)request);
        }
        catch (IOException ioe) {
            // empty catch block
        }
        if (existing == null) {
            return false;
        }
        Header entryDateHeader = existing.getFirstHeader("Date");
        if (entryDateHeader == null) {
            return false;
        }
        Header responseDateHeader = backendResponse.getFirstHeader("Date");
        if (responseDateHeader == null) {
            return false;
        }
        Date entryDate = DateUtils.parseDate(entryDateHeader.getValue());
        Date responseDate = DateUtils.parseDate(responseDateHeader.getValue());
        if (entryDate == null || responseDate == null) {
            return false;
        }
        return responseDate.before(entryDate);
    }
}

