/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.apache.hc.client5.http.cache.HttpCacheEntry;
import org.apache.hc.client5.http.impl.cache.IOUtils;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.function.Supplier;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
class CacheEntity
implements HttpEntity,
Serializable {
    private static final long serialVersionUID = -3467082284120936233L;
    private final HttpCacheEntry cacheEntry;

    public CacheEntity(HttpCacheEntry cacheEntry) {
        this.cacheEntry = cacheEntry;
    }

    public String getContentType() {
        Header header = this.cacheEntry.getFirstHeader("Content-Type");
        return header != null ? header.getValue() : null;
    }

    public String getContentEncoding() {
        Header header = this.cacheEntry.getFirstHeader("Content-Encoding");
        return header != null ? header.getValue() : null;
    }

    public boolean isChunked() {
        return false;
    }

    public boolean isRepeatable() {
        return true;
    }

    public long getContentLength() {
        return this.cacheEntry.getResource().length();
    }

    public InputStream getContent() throws IOException {
        return this.cacheEntry.getResource().getInputStream();
    }

    public void writeTo(OutputStream outstream) throws IOException {
        Args.notNull((Object)outstream, (String)"Output stream");
        try (InputStream instream = this.cacheEntry.getResource().getInputStream();){
            IOUtils.copy(instream, outstream);
        }
    }

    public boolean isStreaming() {
        return false;
    }

    public Supplier<List<? extends Header>> getTrailers() {
        return null;
    }

    public Set<String> getTrailerNames() {
        return null;
    }

    public void close() throws IOException {
    }
}

