/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.async;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.async.AsyncExecRuntime;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.ConnPoolSupport;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.client5.http.nio.AsyncConnectionEndpoint;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.nio.AsyncClientExchangeHandler;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http2.HttpVersionPolicy;
import org.apache.hc.core5.reactor.ConnectionInitiator;
import org.apache.hc.core5.util.TimeValue;
import org.apache.logging.log4j.Logger;

class AsyncExecRuntimeImpl
implements AsyncExecRuntime {
    private final Logger log;
    private final AsyncClientConnectionManager manager;
    private final ConnectionInitiator connectionInitiator;
    private final HttpVersionPolicy versionPolicy;
    private final AtomicReference<AsyncConnectionEndpoint> endpointRef;
    private volatile boolean reusable;
    private volatile Object state;
    private volatile TimeValue validDuration;

    AsyncExecRuntimeImpl(Logger log, AsyncClientConnectionManager manager, ConnectionInitiator connectionInitiator, HttpVersionPolicy versionPolicy) {
        this.log = log;
        this.manager = manager;
        this.connectionInitiator = connectionInitiator;
        this.versionPolicy = versionPolicy;
        this.endpointRef = new AtomicReference<Object>(null);
        this.validDuration = TimeValue.NEG_ONE_MILLISECONDS;
    }

    @Override
    public boolean isConnectionAcquired() {
        return this.endpointRef.get() != null;
    }

    @Override
    public void acquireConnection(HttpRoute route, Object object, HttpClientContext context, final FutureCallback<AsyncExecRuntime> callback) {
        if (this.endpointRef.get() == null) {
            this.state = object;
            RequestConfig requestConfig = context.getRequestConfig();
            this.manager.lease(route, object, requestConfig.getConnectionRequestTimeout(), new FutureCallback<AsyncConnectionEndpoint>(){

                public void completed(AsyncConnectionEndpoint connectionEndpoint) {
                    AsyncExecRuntimeImpl.this.endpointRef.set(connectionEndpoint);
                    AsyncExecRuntimeImpl.this.reusable = connectionEndpoint.isConnected();
                    callback.completed((Object)AsyncExecRuntimeImpl.this);
                }

                public void failed(Exception ex) {
                    callback.failed(ex);
                }

                public void cancelled() {
                    callback.cancelled();
                }
            });
        } else {
            callback.completed((Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseConnection() {
        AsyncConnectionEndpoint endpoint = this.endpointRef.getAndSet(null);
        if (endpoint != null) {
            if (this.reusable) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug(ConnPoolSupport.getId(endpoint) + ": releasing valid endpoint");
                }
                this.manager.release(endpoint, this.state, this.validDuration);
            } else {
                try {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug(ConnPoolSupport.getId(endpoint) + ": releasing invalid endpoint");
                    }
                    endpoint.close();
                }
                catch (IOException ex) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug(ConnPoolSupport.getId(endpoint) + ": " + ex.getMessage(), (Throwable)ex);
                    }
                }
                finally {
                    this.manager.release(endpoint, null, TimeValue.ZERO_MILLISECONDS);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void discardConnection() {
        AsyncConnectionEndpoint endpoint = this.endpointRef.getAndSet(null);
        if (endpoint != null) {
            try {
                endpoint.shutdown();
                if (this.log.isDebugEnabled()) {
                    this.log.debug(ConnPoolSupport.getId(endpoint) + ": discarding endpoint");
                }
            }
            catch (IOException ex) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug(ConnPoolSupport.getId(endpoint) + ": " + ex.getMessage(), (Throwable)ex);
                }
            }
            finally {
                this.manager.release(endpoint, null, TimeValue.ZERO_MILLISECONDS);
            }
        }
    }

    AsyncConnectionEndpoint ensureValid() {
        AsyncConnectionEndpoint endpoint = this.endpointRef.get();
        if (endpoint == null) {
            throw new IllegalStateException("Endpoint not acquired / already released");
        }
        return endpoint;
    }

    @Override
    public boolean isConnected() {
        AsyncConnectionEndpoint endpoint = this.endpointRef.get();
        return endpoint != null && endpoint.isConnected();
    }

    @Override
    public void disconnect() {
        AsyncConnectionEndpoint endpoint = this.endpointRef.get();
        if (endpoint != null) {
            try {
                endpoint.close();
            }
            catch (IOException ex) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug(ConnPoolSupport.getId(endpoint) + ": " + ex.getMessage(), (Throwable)ex);
                }
                this.discardConnection();
            }
        }
    }

    @Override
    public void connect(HttpClientContext context, final FutureCallback<AsyncExecRuntime> callback) {
        AsyncConnectionEndpoint endpoint = this.ensureValid();
        if (endpoint.isConnected()) {
            callback.completed((Object)this);
        } else {
            final RequestConfig requestConfig = context.getRequestConfig();
            this.manager.connect(endpoint, this.connectionInitiator, requestConfig.getConnectTimeout(), this.versionPolicy, (HttpContext)context, new FutureCallback<AsyncConnectionEndpoint>(){

                public void completed(AsyncConnectionEndpoint endpoint) {
                    TimeValue socketTimeout = requestConfig.getSocketTimeout();
                    if (TimeValue.isPositive((TimeValue)socketTimeout)) {
                        endpoint.setSocketTimeout(socketTimeout.toMillisIntBound());
                    }
                    callback.completed((Object)AsyncExecRuntimeImpl.this);
                }

                public void failed(Exception ex) {
                    callback.failed(ex);
                }

                public void cancelled() {
                    callback.cancelled();
                }
            });
        }
    }

    @Override
    public void upgradeTls(HttpClientContext context) {
        AsyncConnectionEndpoint endpoint = this.ensureValid();
        this.manager.upgrade(endpoint, this.versionPolicy, (HttpContext)context);
    }

    @Override
    public void execute(final AsyncClientExchangeHandler exchangeHandler, final HttpClientContext context) {
        final AsyncConnectionEndpoint endpoint = this.ensureValid();
        if (endpoint.isConnected()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug(ConnPoolSupport.getId(endpoint) + ": executing " + ConnPoolSupport.getId(exchangeHandler));
            }
            endpoint.execute(exchangeHandler, (HttpContext)context);
        } else {
            this.connect(context, new FutureCallback<AsyncExecRuntime>(){

                public void completed(AsyncExecRuntime runtime) {
                    if (AsyncExecRuntimeImpl.this.log.isDebugEnabled()) {
                        AsyncExecRuntimeImpl.this.log.debug(ConnPoolSupport.getId(endpoint) + ": executing " + ConnPoolSupport.getId(exchangeHandler));
                    }
                    try {
                        endpoint.execute(exchangeHandler, (HttpContext)context);
                    }
                    catch (RuntimeException ex) {
                        this.failed(ex);
                    }
                }

                public void failed(Exception ex) {
                    exchangeHandler.failed(ex);
                }

                public void cancelled() {
                    exchangeHandler.failed((Exception)new InterruptedIOException());
                }
            });
        }
    }

    @Override
    public boolean validateConnection() {
        AsyncConnectionEndpoint endpoint = this.endpointRef.get();
        return endpoint != null && endpoint.isConnected();
    }

    @Override
    public boolean isConnectionReusable() {
        return this.reusable;
    }

    @Override
    public void markConnectionReusable() {
        this.reusable = true;
    }

    @Override
    public void markConnectionNonReusable() {
        this.reusable = false;
    }

    @Override
    public void setConnectionState(Object state) {
        this.state = state;
    }

    @Override
    public void setConnectionValidFor(TimeValue duration) {
        this.validDuration = duration;
    }
}

