/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpMessage;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.message.BasicClassicHttpRequest;
import org.apache.hc.core5.http.message.BasicClassicHttpResponse;
import org.apache.hc.core5.http.message.BasicHttpRequest;
import org.apache.hc.core5.http.message.BasicHttpResponse;

public final class ExecSupport {
    private static final AtomicLong COUNT = new AtomicLong(0L);

    public static long getNextExecNumber() {
        return COUNT.incrementAndGet();
    }

    private static void copyMessageProperties(HttpMessage original, HttpMessage copy) {
        copy.setVersion(original.getVersion());
        Iterator it = original.headerIterator();
        while (it.hasNext()) {
            copy.addHeader((Header)it.next());
        }
    }

    private static void copyRequestProperties(HttpRequest original, HttpRequest copy) {
        ExecSupport.copyMessageProperties((HttpMessage)original, (HttpMessage)copy);
        if (copy.getVersion() == null) {
            copy.setVersion((ProtocolVersion)HttpVersion.DEFAULT);
        }
        copy.setScheme(original.getScheme());
        copy.setAuthority(original.getAuthority());
    }

    private static void copyResponseProperties(HttpResponse original, HttpResponse copy) {
        ExecSupport.copyMessageProperties((HttpMessage)original, (HttpMessage)copy);
        copy.setLocale(copy.getLocale());
        copy.setReasonPhrase(copy.getReasonPhrase());
    }

    public static HttpRequest copy(HttpRequest original) {
        if (original == null) {
            return null;
        }
        BasicHttpRequest copy = new BasicHttpRequest(original.getMethod(), original.getPath());
        ExecSupport.copyRequestProperties(original, (HttpRequest)copy);
        return copy;
    }

    public static HttpResponse copy(HttpResponse original) {
        if (original == null) {
            return null;
        }
        BasicHttpResponse copy = new BasicHttpResponse(original.getCode());
        ExecSupport.copyResponseProperties(original, (HttpResponse)copy);
        return copy;
    }

    public static ClassicHttpRequest copy(ClassicHttpRequest original) {
        if (original == null) {
            return null;
        }
        BasicClassicHttpRequest copy = new BasicClassicHttpRequest(original.getMethod(), original.getPath());
        ExecSupport.copyRequestProperties((HttpRequest)original, (HttpRequest)copy);
        copy.setEntity(original.getEntity());
        return copy;
    }

    public static ClassicHttpResponse copy(ClassicHttpResponse original) {
        if (original == null) {
            return null;
        }
        BasicClassicHttpResponse copy = new BasicClassicHttpResponse(original.getCode());
        ExecSupport.copyResponseProperties((HttpResponse)original, (HttpResponse)copy);
        copy.setEntity(original.getEntity());
        return copy;
    }
}

