/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.async.methods;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.hc.client5.http.StandardMethods;
import org.apache.hc.client5.http.async.methods.DefaultAsyncRequestProducer;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.BasicHttpRequest;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.http.message.HeaderGroup;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.AsyncRequestProducer;
import org.apache.hc.core5.http.nio.entity.BasicAsyncEntityProducer;
import org.apache.hc.core5.http.nio.entity.StringAsyncEntityProducer;
import org.apache.hc.core5.net.URIBuilder;
import org.apache.hc.core5.net.URLEncodedUtils;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TextUtils;

public class AsyncRequestBuilder {
    private HttpHost host;
    private String path;
    private URI uri;
    private String method;
    private Charset charset;
    private ProtocolVersion version;
    private HeaderGroup headergroup;
    private AsyncEntityProducer entityProducer;
    private List<NameValuePair> parameters;
    private RequestConfig config;

    AsyncRequestBuilder() {
    }

    AsyncRequestBuilder(String method) {
        this.method = method;
    }

    AsyncRequestBuilder(StandardMethods method) {
        this(method.name());
    }

    AsyncRequestBuilder(String method, URI uri) {
        this.method = method;
        this.uri = uri;
    }

    AsyncRequestBuilder(StandardMethods method, HttpHost host, String path) {
        this.method = method.name();
        this.host = host;
        this.path = path;
    }

    AsyncRequestBuilder(StandardMethods method, URI uri) {
        this(method.name(), uri);
    }

    AsyncRequestBuilder(StandardMethods method, String uri) {
        this(method.name(), uri != null ? URI.create(uri) : null);
    }

    AsyncRequestBuilder(String method, String uri) {
        this(method, uri != null ? URI.create(uri) : null);
    }

    public static AsyncRequestBuilder create(String method) {
        Args.notBlank((CharSequence)method, (String)"HTTP method");
        return new AsyncRequestBuilder(method);
    }

    public static AsyncRequestBuilder get() {
        return new AsyncRequestBuilder(StandardMethods.GET);
    }

    public static AsyncRequestBuilder get(URI uri) {
        return new AsyncRequestBuilder(StandardMethods.GET, uri);
    }

    public static AsyncRequestBuilder get(String uri) {
        return new AsyncRequestBuilder(StandardMethods.GET, uri);
    }

    public static AsyncRequestBuilder get(HttpHost host, String path) {
        return new AsyncRequestBuilder(StandardMethods.GET, host, path);
    }

    public static AsyncRequestBuilder head() {
        return new AsyncRequestBuilder(StandardMethods.HEAD);
    }

    public static AsyncRequestBuilder head(URI uri) {
        return new AsyncRequestBuilder(StandardMethods.HEAD, uri);
    }

    public static AsyncRequestBuilder head(String uri) {
        return new AsyncRequestBuilder(StandardMethods.HEAD, uri);
    }

    public static AsyncRequestBuilder head(HttpHost host, String path) {
        return new AsyncRequestBuilder(StandardMethods.HEAD, host, path);
    }

    public static AsyncRequestBuilder patch() {
        return new AsyncRequestBuilder(StandardMethods.PATCH);
    }

    public static AsyncRequestBuilder patch(URI uri) {
        return new AsyncRequestBuilder(StandardMethods.PATCH, uri);
    }

    public static AsyncRequestBuilder patch(String uri) {
        return new AsyncRequestBuilder(StandardMethods.PATCH, uri);
    }

    public static AsyncRequestBuilder patch(HttpHost host, String path) {
        return new AsyncRequestBuilder(StandardMethods.PATCH, host, path);
    }

    public static AsyncRequestBuilder post() {
        return new AsyncRequestBuilder(StandardMethods.POST);
    }

    public static AsyncRequestBuilder post(URI uri) {
        return new AsyncRequestBuilder(StandardMethods.POST, uri);
    }

    public static AsyncRequestBuilder post(String uri) {
        return new AsyncRequestBuilder(StandardMethods.POST, uri);
    }

    public static AsyncRequestBuilder post(HttpHost host, String path) {
        return new AsyncRequestBuilder(StandardMethods.POST, host, path);
    }

    public static AsyncRequestBuilder put() {
        return new AsyncRequestBuilder(StandardMethods.PUT);
    }

    public static AsyncRequestBuilder put(URI uri) {
        return new AsyncRequestBuilder(StandardMethods.PUT, uri);
    }

    public static AsyncRequestBuilder put(String uri) {
        return new AsyncRequestBuilder(StandardMethods.PUT, uri);
    }

    public static AsyncRequestBuilder put(HttpHost host, String path) {
        return new AsyncRequestBuilder(StandardMethods.PUT, host, path);
    }

    public static AsyncRequestBuilder delete() {
        return new AsyncRequestBuilder(StandardMethods.DELETE);
    }

    public static AsyncRequestBuilder delete(URI uri) {
        return new AsyncRequestBuilder(StandardMethods.DELETE, uri);
    }

    public static AsyncRequestBuilder delete(String uri) {
        return new AsyncRequestBuilder(StandardMethods.DELETE, uri);
    }

    public static AsyncRequestBuilder delete(HttpHost host, String path) {
        return new AsyncRequestBuilder(StandardMethods.DELETE, host, path);
    }

    public static AsyncRequestBuilder trace() {
        return new AsyncRequestBuilder(StandardMethods.TRACE);
    }

    public static AsyncRequestBuilder trace(URI uri) {
        return new AsyncRequestBuilder(StandardMethods.TRACE, uri);
    }

    public static AsyncRequestBuilder trace(String uri) {
        return new AsyncRequestBuilder(StandardMethods.TRACE, uri);
    }

    public static AsyncRequestBuilder trace(HttpHost host, String path) {
        return new AsyncRequestBuilder(StandardMethods.TRACE, host, path);
    }

    public static AsyncRequestBuilder options() {
        return new AsyncRequestBuilder(StandardMethods.OPTIONS);
    }

    public static AsyncRequestBuilder options(URI uri) {
        return new AsyncRequestBuilder(StandardMethods.OPTIONS, uri);
    }

    public static AsyncRequestBuilder options(String uri) {
        return new AsyncRequestBuilder(StandardMethods.OPTIONS, uri);
    }

    public static AsyncRequestBuilder options(HttpHost host, String path) {
        return new AsyncRequestBuilder(StandardMethods.OPTIONS, host, path);
    }

    public AsyncRequestBuilder setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String getMethod() {
        return this.method;
    }

    public URI getUri() {
        return this.uri;
    }

    public AsyncRequestBuilder setUri(URI uri) {
        this.uri = uri;
        this.host = null;
        this.path = null;
        return this;
    }

    public AsyncRequestBuilder setUri(String uri) {
        this.uri = uri != null ? URI.create(uri) : null;
        this.host = null;
        this.path = null;
        return this;
    }

    public ProtocolVersion getVersion() {
        return this.version;
    }

    public AsyncRequestBuilder setVersion(ProtocolVersion version) {
        this.version = version;
        return this;
    }

    public Header getFirstHeader(String name) {
        return this.headergroup != null ? this.headergroup.getFirstHeader(name) : null;
    }

    public Header getLastHeader(String name) {
        return this.headergroup != null ? this.headergroup.getLastHeader(name) : null;
    }

    public Header[] getHeaders(String name) {
        return this.headergroup != null ? this.headergroup.getHeaders(name) : null;
    }

    public AsyncRequestBuilder addHeader(Header header) {
        if (this.headergroup == null) {
            this.headergroup = new HeaderGroup();
        }
        this.headergroup.addHeader(header);
        return this;
    }

    public AsyncRequestBuilder addHeader(String name, String value) {
        if (this.headergroup == null) {
            this.headergroup = new HeaderGroup();
        }
        this.headergroup.addHeader((Header)new BasicHeader(name, (Object)value));
        return this;
    }

    public AsyncRequestBuilder removeHeader(Header header) {
        if (this.headergroup == null) {
            this.headergroup = new HeaderGroup();
        }
        this.headergroup.removeHeader(header);
        return this;
    }

    public AsyncRequestBuilder removeHeaders(String name) {
        if (name == null || this.headergroup == null) {
            return this;
        }
        Iterator i = this.headergroup.headerIterator();
        while (i.hasNext()) {
            Header header = (Header)i.next();
            if (!name.equalsIgnoreCase(header.getName())) continue;
            i.remove();
        }
        return this;
    }

    public AsyncRequestBuilder setHeader(Header header) {
        if (this.headergroup == null) {
            this.headergroup = new HeaderGroup();
        }
        this.headergroup.setHeader(header);
        return this;
    }

    public AsyncRequestBuilder setHeader(String name, String value) {
        if (this.headergroup == null) {
            this.headergroup = new HeaderGroup();
        }
        this.headergroup.setHeader((Header)new BasicHeader(name, (Object)value));
        return this;
    }

    public List<NameValuePair> getParameters() {
        return this.parameters != null ? new ArrayList<NameValuePair>(this.parameters) : new ArrayList();
    }

    public AsyncRequestBuilder addParameter(NameValuePair nvp) {
        Args.notNull((Object)nvp, (String)"Name value pair");
        if (this.parameters == null) {
            this.parameters = new LinkedList<NameValuePair>();
        }
        this.parameters.add(nvp);
        return this;
    }

    public AsyncRequestBuilder addParameter(String name, String value) {
        return this.addParameter((NameValuePair)new BasicNameValuePair(name, value));
    }

    public AsyncRequestBuilder addParameters(NameValuePair ... nvps) {
        for (NameValuePair nvp : nvps) {
            this.addParameter(nvp);
        }
        return this;
    }

    public RequestConfig getConfig() {
        return this.config;
    }

    public AsyncRequestBuilder setConfig(RequestConfig config) {
        this.config = config;
        return this;
    }

    public AsyncEntityProducer getEntity() {
        return this.entityProducer;
    }

    public AsyncRequestBuilder setEntity(AsyncEntityProducer entityProducer) {
        this.entityProducer = entityProducer;
        return this;
    }

    public AsyncRequestBuilder setEntity(String content, ContentType contentType) {
        this.entityProducer = new BasicAsyncEntityProducer((CharSequence)content, contentType);
        return this;
    }

    public AsyncRequestBuilder setEntity(byte[] content, ContentType contentType) {
        this.entityProducer = new BasicAsyncEntityProducer(content, contentType);
        return this;
    }

    public AsyncRequestProducer build() {
        BasicHttpRequest request;
        AsyncEntityProducer entityProducerCopy = this.entityProducer;
        if (this.parameters != null && !this.parameters.isEmpty()) {
            if (entityProducerCopy == null && (StandardMethods.POST.name().equalsIgnoreCase(this.method) || StandardMethods.PUT.name().equalsIgnoreCase(this.method))) {
                String content = URLEncodedUtils.format(this.parameters, (Charset)(this.charset != null ? this.charset : ContentType.APPLICATION_FORM_URLENCODED.getCharset()));
                entityProducerCopy = new StringAsyncEntityProducer((CharSequence)content, ContentType.APPLICATION_FORM_URLENCODED);
            } else {
                try {
                    this.uri = new URIBuilder(this.uri).setCharset(this.charset).addParameters(this.parameters).build();
                }
                catch (URISyntaxException ex) {
                    // empty catch block
                }
            }
        }
        BasicHttpRequest basicHttpRequest = this.host != null ? new BasicHttpRequest(this.method, this.host, !TextUtils.isBlank((CharSequence)this.path) ? this.path : "/") : (request = new BasicHttpRequest(this.method, this.uri != null ? this.uri : URI.create("/")));
        if (this.headergroup != null) {
            request.setHeaders(this.headergroup.getAllHeaders());
        }
        if (this.version != null) {
            request.setVersion(this.version);
        }
        return new DefaultAsyncRequestProducer((HttpRequest)request, entityProducerCopy, this.config);
    }
}

