/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.util;

import java.util.concurrent.TimeUnit;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TimeValue;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class Timeout
extends TimeValue {
    public static final Timeout DISABLED = new Timeout(0L, TimeUnit.MILLISECONDS);
    public static final Timeout UNDEFINED_MILLISECONDS = new Timeout(-1L, TimeUnit.MILLISECONDS);
    public static final Timeout UNDEFINED_SECONDS = new Timeout(-1L, TimeUnit.SECONDS);

    public static Timeout of(long duration, TimeUnit timeUnit) {
        return new Timeout(duration, timeUnit);
    }

    public static Timeout ofDays(long days) {
        return Timeout.of(days, TimeUnit.DAYS);
    }

    public static Timeout ofHours(long hours) {
        return Timeout.of(hours, TimeUnit.HOURS);
    }

    public static Timeout ofMicroseconds(long microseconds) {
        return Timeout.of(microseconds, TimeUnit.MICROSECONDS);
    }

    public static Timeout ofMillis(long milliseconds) {
        return Timeout.of(milliseconds, TimeUnit.MILLISECONDS);
    }

    public static Timeout ofMinutes(long minutes) {
        return Timeout.of(minutes, TimeUnit.MINUTES);
    }

    public static Timeout ofNanoseconds(long nanoseconds) {
        return Timeout.of(nanoseconds, TimeUnit.NANOSECONDS);
    }

    public static Timeout ofSeconds(long seconds) {
        return Timeout.of(seconds, TimeUnit.SECONDS);
    }

    private static long validateDuration(long duration) {
        if (duration < -1L) {
            throw new IllegalArgumentException("Duration may not be less than -1");
        }
        return duration;
    }

    Timeout(long duration, TimeUnit timeUnit) {
        super(Timeout.validateDuration(duration), Args.notNull(timeUnit, "timeUnit"));
    }

    public boolean isDisabled() {
        return this.getDuration() == 0L;
    }

    public boolean isEnabled() {
        return !this.isDisabled() && !this.isUndefinedMilliseconds() && !this.isUndefinedSeconds();
    }

    public boolean isUndefinedMilliseconds() {
        return this.getDuration() == -1L && this.getTimeUnit() == TimeUnit.MILLISECONDS;
    }

    public boolean isUndefinedSeconds() {
        return this.getDuration() == -1L && this.getTimeUnit() == TimeUnit.SECONDS;
    }
}

