/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.reactor;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.reactor.SessionRequest;
import org.apache.hc.core5.reactor.SessionRequestCallback;
import org.apache.hc.core5.reactor.TlsCapableIOSession;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
public class SessionRequestImpl
implements SessionRequest {
    private volatile boolean completed;
    private volatile SelectionKey key;
    private final NamedEndpoint remoteEndpoint;
    private final SocketAddress remoteAddress;
    private final SocketAddress localAddress;
    private final Object attachment;
    private final SessionRequestCallback callback;
    private volatile int connectTimeout;
    private volatile TlsCapableIOSession session = null;
    private volatile IOException exception = null;

    public SessionRequestImpl(NamedEndpoint remoteEndpoint, SocketAddress remoteAddress, SocketAddress localAddress, Object attachment, SessionRequestCallback callback) {
        this.remoteEndpoint = Args.notNull(remoteEndpoint, "Remote endpoint");
        this.remoteAddress = Args.notNull(remoteAddress, "Remote address");
        this.localAddress = localAddress;
        this.attachment = attachment;
        this.callback = callback;
        this.connectTimeout = 0;
    }

    @Override
    public NamedEndpoint getRemoteEndpoint() {
        return this.remoteEndpoint;
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.localAddress;
    }

    @Override
    public Object getAttachment() {
        return this.attachment;
    }

    @Override
    public boolean isCompleted() {
        return this.completed;
    }

    protected void setKey(SelectionKey key) {
        this.key = key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitFor() throws InterruptedException {
        if (this.completed) {
            return;
        }
        SessionRequestImpl sessionRequestImpl = this;
        synchronized (sessionRequestImpl) {
            while (!this.completed) {
                this.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TlsCapableIOSession getSession() {
        SessionRequestImpl sessionRequestImpl = this;
        synchronized (sessionRequestImpl) {
            return this.session;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IOException getException() {
        SessionRequestImpl sessionRequestImpl = this;
        synchronized (sessionRequestImpl) {
            return this.exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completed(TlsCapableIOSession session) {
        Args.notNull(session, "Session");
        if (this.completed) {
            return;
        }
        this.completed = true;
        SessionRequestImpl sessionRequestImpl = this;
        synchronized (sessionRequestImpl) {
            this.session = session;
            if (this.callback != null) {
                this.callback.completed(this);
            }
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failed(IOException exception) {
        if (exception == null) {
            return;
        }
        if (this.completed) {
            return;
        }
        this.completed = true;
        SelectionKey key = this.key;
        if (key != null) {
            key.cancel();
            SelectableChannel channel = key.channel();
            try {
                channel.close();
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
        SessionRequestImpl sessionRequestImpl = this;
        synchronized (sessionRequestImpl) {
            this.exception = exception;
            if (this.callback != null) {
                this.callback.failed(this);
            }
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timeout() {
        if (this.completed) {
            return;
        }
        this.completed = true;
        SelectionKey key = this.key;
        if (key != null) {
            key.cancel();
            SelectableChannel channel = key.channel();
            if (channel.isOpen()) {
                try {
                    channel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        SessionRequestImpl sessionRequestImpl = this;
        synchronized (sessionRequestImpl) {
            if (this.callback != null) {
                this.callback.timeout(this);
            }
        }
    }

    @Override
    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public void setConnectTimeout(int timeout) {
        if (this.connectTimeout != timeout) {
            this.connectTimeout = timeout;
            SelectionKey key = this.key;
            if (key != null) {
                key.selector().wakeup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel() {
        if (this.completed) {
            return false;
        }
        this.completed = true;
        SelectionKey key = this.key;
        if (key != null) {
            key.cancel();
            SelectableChannel channel = key.channel();
            if (channel.isOpen()) {
                try {
                    channel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        SessionRequestImpl sessionRequestImpl = this;
        synchronized (sessionRequestImpl) {
            if (this.callback != null) {
                this.callback.cancelled(this);
            }
            this.notifyAll();
        }
        return true;
    }
}

