/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.reactor;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.ByteChannel;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLContext;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.io.ShutdownType;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.reactor.Command;
import org.apache.hc.core5.reactor.IOEventHandler;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.TlsCapableIOSession;
import org.apache.hc.core5.reactor.ssl.SSLBufferManagement;
import org.apache.hc.core5.reactor.ssl.SSLIOSession;
import org.apache.hc.core5.reactor.ssl.SSLMode;
import org.apache.hc.core5.reactor.ssl.SSLSessionInitializer;
import org.apache.hc.core5.reactor.ssl.SSLSessionVerifier;
import org.apache.hc.core5.reactor.ssl.TlsDetails;
import org.apache.hc.core5.util.Asserts;

@Contract(threading=ThreadingBehavior.SAFE)
class InternalIOSession
implements TlsCapableIOSession {
    private final NamedEndpoint namedEndpoint;
    private final IOSession ioSession;
    private final AtomicReference<SSLIOSession> tlsSessionRef;
    private final Queue<InternalIOSession> closedSessions;
    private final AtomicBoolean connected;
    private final AtomicBoolean closed;
    private volatile long lastAccessTime;

    InternalIOSession(NamedEndpoint namedEndpoint, IOSession ioSession, Queue<InternalIOSession> closedSessions) {
        this.namedEndpoint = namedEndpoint;
        this.ioSession = ioSession;
        this.closedSessions = closedSessions;
        this.tlsSessionRef = new AtomicReference<Object>(null);
        this.connected = new AtomicBoolean(false);
        this.closed = new AtomicBoolean(false);
        this.updateAccessTime();
    }

    @Override
    public String getId() {
        return this.ioSession.getId();
    }

    void updateAccessTime() {
        this.lastAccessTime = System.currentTimeMillis();
    }

    long getLastAccessTime() {
        return this.lastAccessTime;
    }

    private IOSession getSessionImpl() {
        SSLIOSession tlsSession = this.tlsSessionRef.get();
        if (tlsSession != null) {
            return tlsSession;
        }
        return this.ioSession;
    }

    IOEventHandler getEventHandler() {
        IOEventHandler handler = this.ioSession.getHandler();
        Asserts.notNull(handler, "IO event handler");
        return handler;
    }

    void onConnected() {
        block7: {
            try {
                SSLIOSession tlsSession = this.tlsSessionRef.get();
                if (tlsSession != null) {
                    try {
                        if (!tlsSession.isInitialized()) {
                            tlsSession.initialize();
                        }
                        break block7;
                    }
                    catch (Exception ex) {
                        IOEventHandler handler = this.getEventHandler();
                        handler.exception(tlsSession, ex);
                    }
                    break block7;
                }
                if (this.connected.compareAndSet(false, true)) {
                    IOEventHandler handler = this.getEventHandler();
                    handler.connected(this.ioSession);
                }
            }
            catch (RuntimeException ex) {
                this.shutdown(ShutdownType.IMMEDIATE);
                throw ex;
            }
        }
    }

    void onInputReady() {
        try {
            SSLIOSession tlsSession = this.tlsSessionRef.get();
            if (tlsSession != null) {
                try {
                    if (!tlsSession.isInitialized()) {
                        tlsSession.initialize();
                    }
                    if (tlsSession.isAppInputReady()) {
                        do {
                            IOEventHandler handler = this.getEventHandler();
                            handler.inputReady(tlsSession);
                        } while (tlsSession.hasInputDate());
                    }
                    tlsSession.inboundTransport();
                }
                catch (IOException ex) {
                    IOEventHandler handler = this.getEventHandler();
                    handler.exception(tlsSession, ex);
                    tlsSession.shutdown(ShutdownType.IMMEDIATE);
                }
            } else {
                IOEventHandler handler = this.getEventHandler();
                handler.inputReady(this.ioSession);
            }
        }
        catch (RuntimeException ex) {
            this.shutdown(ShutdownType.IMMEDIATE);
            throw ex;
        }
    }

    void onOutputReady() {
        try {
            SSLIOSession tlsSession = this.tlsSessionRef.get();
            if (tlsSession != null) {
                try {
                    if (!tlsSession.isInitialized()) {
                        tlsSession.initialize();
                    }
                    if (tlsSession.isAppOutputReady()) {
                        IOEventHandler handler = this.getEventHandler();
                        handler.outputReady(tlsSession);
                    }
                    tlsSession.outboundTransport();
                }
                catch (IOException ex) {
                    IOEventHandler handler = this.getEventHandler();
                    handler.exception(tlsSession, ex);
                    tlsSession.shutdown(ShutdownType.IMMEDIATE);
                }
            } else {
                IOEventHandler handler = this.getEventHandler();
                handler.outputReady(this.ioSession);
            }
        }
        catch (RuntimeException ex) {
            this.shutdown(ShutdownType.IMMEDIATE);
            throw ex;
        }
    }

    void onTimeout() {
        try {
            IOEventHandler handler = this.getEventHandler();
            handler.timeout(this.ioSession);
            SSLIOSession tlsSession = this.tlsSessionRef.get();
            if (tlsSession != null && tlsSession.isOutboundDone() && !tlsSession.isInboundDone()) {
                tlsSession.shutdown(ShutdownType.IMMEDIATE);
            }
        }
        catch (RuntimeException ex) {
            this.shutdown(ShutdownType.IMMEDIATE);
            throw ex;
        }
    }

    void onDisconnected() {
        IOEventHandler handler = this.getEventHandler();
        handler.disconnected(this.ioSession);
    }

    @Override
    public void startTls(SSLContext sslContext, SSLBufferManagement sslBufferManagement, SSLSessionInitializer initializer, SSLSessionVerifier verifier) {
        if (!this.tlsSessionRef.compareAndSet(null, new SSLIOSession(this.namedEndpoint, this.ioSession, this.namedEndpoint != null ? SSLMode.CLIENT : SSLMode.SERVER, sslContext, sslBufferManagement, initializer, verifier, new Callback<SSLIOSession>(){

            @Override
            public void execute(SSLIOSession sslSession) {
                if (InternalIOSession.this.connected.compareAndSet(false, true)) {
                    IOEventHandler handler = InternalIOSession.this.getEventHandler();
                    handler.connected(sslSession);
                }
            }
        }))) {
            throw new IllegalStateException("TLS already activated");
        }
    }

    @Override
    public TlsDetails getTlsDetails() {
        SSLIOSession sslIoSession = this.tlsSessionRef.get();
        return sslIoSession != null ? sslIoSession.getTlsDetails() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            try {
                this.getSessionImpl().close();
            }
            finally {
                this.closedSessions.add(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown(ShutdownType shutdownType) {
        if (this.closed.compareAndSet(false, true)) {
            try {
                this.getSessionImpl().shutdown(shutdownType);
            }
            finally {
                this.closedSessions.add(this);
            }
        }
    }

    @Override
    public int getStatus() {
        return this.getSessionImpl().getStatus();
    }

    @Override
    public boolean isClosed() {
        return this.getSessionImpl().isClosed();
    }

    @Override
    public IOEventHandler getHandler() {
        return this.ioSession.getHandler();
    }

    @Override
    public void setHandler(IOEventHandler eventHandler) {
        this.ioSession.setHandler(eventHandler);
    }

    @Override
    public void addLast(Command command) {
        this.getSessionImpl().addLast(command);
    }

    @Override
    public void addFirst(Command command) {
        this.getSessionImpl().addFirst(command);
    }

    @Override
    public Command getCommand() {
        return this.getSessionImpl().getCommand();
    }

    @Override
    public ByteChannel channel() {
        return this.getSessionImpl().channel();
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.ioSession.getRemoteAddress();
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.ioSession.getLocalAddress();
    }

    @Override
    public int getEventMask() {
        return this.getSessionImpl().getEventMask();
    }

    @Override
    public void setEventMask(int ops) {
        this.getSessionImpl().setEventMask(ops);
    }

    @Override
    public void setEvent(int op) {
        this.getSessionImpl().setEvent(op);
    }

    @Override
    public void clearEvent(int op) {
        this.getSessionImpl().clearEvent(op);
    }

    @Override
    public int getSocketTimeout() {
        return this.ioSession.getSocketTimeout();
    }

    @Override
    public void setSocketTimeout(int timeout) {
        this.ioSession.setSocketTimeout(timeout);
    }

    public String toString() {
        return this.getSessionImpl().toString();
    }
}

