/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.reactor;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.ByteChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.io.ShutdownType;
import org.apache.hc.core5.reactor.Command;
import org.apache.hc.core5.reactor.IOEventHandler;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.SAFE)
class IOSessionImpl
implements IOSession {
    private static final AtomicLong COUNT = new AtomicLong(0L);
    private final SelectionKey key;
    private final SocketChannel channel;
    private final String id;
    private final AtomicInteger status;
    private final AtomicInteger eventMask;
    private final Deque<Command> commandQueue;
    private volatile IOEventHandler eventHandler;
    private volatile int socketTimeout;

    public IOSessionImpl(SelectionKey key, SocketChannel socketChannel) {
        this.key = Args.notNull(key, "Selection key");
        this.channel = Args.notNull(socketChannel, "Socket channel");
        this.commandQueue = new ConcurrentLinkedDeque<Command>();
        this.socketTimeout = 0;
        this.eventMask = new AtomicInteger(key.interestOps());
        this.id = "i/o-" + Long.toHexString(COUNT.incrementAndGet());
        this.status = new AtomicInteger(0);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public IOEventHandler getHandler() {
        return this.eventHandler;
    }

    @Override
    public void setHandler(IOEventHandler handler) {
        this.eventHandler = handler;
    }

    @Override
    public void addLast(Command command) {
        this.commandQueue.addLast(command);
        this.setEvent(4);
    }

    @Override
    public void addFirst(Command command) {
        this.commandQueue.addFirst(command);
        this.setEvent(4);
    }

    @Override
    public Command getCommand() {
        return this.commandQueue.poll();
    }

    @Override
    public ByteChannel channel() {
        return this.channel;
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.channel.socket().getLocalSocketAddress();
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.channel.socket().getRemoteSocketAddress();
    }

    @Override
    public int getEventMask() {
        return this.key.interestOps();
    }

    @Override
    public void setEventMask(int newValue) {
        if (this.status.get() == Integer.MAX_VALUE) {
            return;
        }
        int currentValue = this.eventMask.get();
        if (newValue == currentValue) {
            return;
        }
        if (this.eventMask.compareAndSet(currentValue, newValue)) {
            this.key.interestOps(newValue);
            this.key.selector().wakeup();
        }
    }

    @Override
    public void setEvent(int op) {
        int newValue;
        int currentValue;
        if (this.status.get() == Integer.MAX_VALUE) {
            return;
        }
        while (!this.eventMask.compareAndSet(currentValue = this.eventMask.get(), newValue = currentValue | op)) {
        }
        this.key.interestOps(newValue);
        this.key.selector().wakeup();
    }

    @Override
    public void clearEvent(int op) {
        int newValue;
        int currentValue;
        if (this.status.get() == Integer.MAX_VALUE) {
            return;
        }
        while (!this.eventMask.compareAndSet(currentValue = this.eventMask.get(), newValue = currentValue & ~op)) {
        }
        this.key.interestOps(newValue);
        this.key.selector().wakeup();
    }

    @Override
    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    @Override
    public void setSocketTimeout(int timeout) {
        this.socketTimeout = timeout;
    }

    @Override
    public void close() {
        if (this.status.compareAndSet(0, Integer.MAX_VALUE)) {
            this.key.cancel();
            this.key.attach(null);
            try {
                this.key.channel().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.key.selector().isOpen()) {
                this.key.selector().wakeup();
            }
        }
    }

    @Override
    public int getStatus() {
        return this.status.get();
    }

    @Override
    public boolean isClosed() {
        return this.status.get() == Integer.MAX_VALUE || !this.channel.isOpen();
    }

    @Override
    public void shutdown(ShutdownType shutdownType) {
        this.close();
    }

    private static void formatOps(StringBuilder buffer, int ops) {
        if ((ops & 1) > 0) {
            buffer.append('r');
        }
        if ((ops & 4) > 0) {
            buffer.append('w');
        }
        if ((ops & 0x10) > 0) {
            buffer.append('a');
        }
        if ((ops & 8) > 0) {
            buffer.append('c');
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.id).append("[");
        switch (this.status.get()) {
            case 0: {
                buffer.append("ACTIVE");
                break;
            }
            case 1: {
                buffer.append("CLOSING");
                break;
            }
            case 0x7FFFFFFF: {
                buffer.append("CLOSED");
            }
        }
        buffer.append("][");
        if (this.key.isValid()) {
            IOSessionImpl.formatOps(buffer, this.key.interestOps());
            buffer.append(":");
            IOSessionImpl.formatOps(buffer, this.key.readyOps());
        }
        buffer.append("]");
        return buffer.toString();
    }
}

