/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.reactor;

import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.core5.concurrent.Cancellable;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.io.ShutdownType;
import org.apache.hc.core5.reactor.IOEventHandlerFactory;
import org.apache.hc.core5.reactor.IOReactor;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.reactor.IOReactorException;
import org.apache.hc.core5.reactor.IOReactorStatus;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.IOSessionImpl;
import org.apache.hc.core5.reactor.InternalIOSession;
import org.apache.hc.core5.reactor.SessionRequestImpl;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TimeValue;

class IOReactorImpl
implements IOReactor {
    private final IOReactorConfig reactorConfig;
    private final IOEventHandlerFactory eventHandlerFactory;
    private final Selector selector;
    private final Queue<InternalIOSession> closedSessions;
    private final Queue<PendingSession> pendingSessions;
    private final AtomicReference<IOReactorStatus> status;
    private final AtomicBoolean shutdownInitiated;
    private final Object shutdownMutex;
    private final Callback<IOSession> sessionShutdownCallback;
    private volatile long lastTimeoutCheck;

    IOReactorImpl(IOEventHandlerFactory eventHandlerFactory, IOReactorConfig reactorConfig, Callback<IOSession> sessionShutdownCallback) {
        this.reactorConfig = Args.notNull(reactorConfig, "I/O reactor config");
        this.eventHandlerFactory = Args.notNull(eventHandlerFactory, "Event handler factory");
        this.sessionShutdownCallback = sessionShutdownCallback;
        this.shutdownInitiated = new AtomicBoolean(false);
        this.closedSessions = new ConcurrentLinkedQueue<InternalIOSession>();
        this.pendingSessions = new ConcurrentLinkedQueue<PendingSession>();
        try {
            this.selector = Selector.open();
        }
        catch (IOException ex) {
            throw new IllegalStateException("Unexpected failure opening I/O selector", ex);
        }
        this.shutdownMutex = new Object();
        this.status = new AtomicReference<IOReactorStatus>(IOReactorStatus.INACTIVE);
    }

    @Override
    public IOReactorStatus getStatus() {
        return this.status.get();
    }

    private void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void cancelQuietly(Cancellable cancellable) {
        if (cancellable != null) {
            cancellable.cancel();
        }
    }

    void enqueuePendingSession(SocketChannel socketChannel, SessionRequestImpl sessionRequest) {
        Args.notNull(socketChannel, "SocketChannel");
        this.pendingSessions.add(new PendingSession(socketChannel, sessionRequest));
        this.selector.wakeup();
    }

    @Override
    public void execute() throws InterruptedIOException, IOReactorException {
        if (this.status.compareAndSet(IOReactorStatus.INACTIVE, IOReactorStatus.ACTIVE)) {
            this.doExecute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExecute() throws InterruptedIOException, IOReactorException {
        long selectTimeout = this.reactorConfig.getSelectInterval();
        try {
            while (!Thread.currentThread().isInterrupted()) {
                int readyCount;
                try {
                    readyCount = this.selector.select(selectTimeout);
                }
                catch (InterruptedIOException ex) {
                    throw ex;
                }
                catch (IOException ex) {
                    throw new IOReactorException("Unexpected selector failure", ex);
                }
                if (this.status.get().compareTo(IOReactorStatus.SHUTTING_DOWN) >= 0) {
                    if (this.shutdownInitiated.compareAndSet(false, true)) {
                        this.initiateSessionShutdown();
                    }
                    this.closePendingSessions();
                }
                if (this.status.get().compareTo(IOReactorStatus.SHUT_DOWN) == 0) {
                } else {
                    if (readyCount > 0) {
                        this.processEvents(this.selector.selectedKeys());
                    }
                    this.validateActiveChannels();
                    this.processClosedSessions();
                    if (this.status.get().compareTo(IOReactorStatus.ACTIVE) == 0) {
                        this.processPendingSessions();
                    }
                    if (this.status.get().compareTo(IOReactorStatus.SHUTTING_DOWN) == 0 && this.selector.keys().isEmpty()) {
                        this.status.set(IOReactorStatus.SHUT_DOWN);
                    }
                    if (this.status.get().compareTo(IOReactorStatus.SHUT_DOWN) != 0) continue;
                }
                break;
            }
        }
        catch (ClosedSelectorException closedSelectorException) {
            try {
                this.closePendingSessions();
                this.closeActiveChannels();
                this.processClosedSessions();
            }
            finally {
                this.status.set(IOReactorStatus.SHUT_DOWN);
                Object object = this.shutdownMutex;
                synchronized (object) {
                    this.shutdownMutex.notifyAll();
                }
            }
        }
        finally {
            try {
                this.closePendingSessions();
                this.closeActiveChannels();
                this.processClosedSessions();
            }
            finally {
                this.status.set(IOReactorStatus.SHUT_DOWN);
                Object readyCount = this.shutdownMutex;
                synchronized (readyCount) {
                    this.shutdownMutex.notifyAll();
                }
            }
        }
    }

    private void initiateSessionShutdown() {
        if (this.sessionShutdownCallback != null) {
            Set<SelectionKey> keys = this.selector.keys();
            for (SelectionKey key : keys) {
                InternalIOSession session = (InternalIOSession)key.attachment();
                if (session == null) continue;
                this.sessionShutdownCallback.execute(session);
            }
        }
    }

    private void validateActiveChannels() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastTimeoutCheck >= this.reactorConfig.getSelectInterval()) {
            this.lastTimeoutCheck = currentTime;
            for (SelectionKey key : this.selector.keys()) {
                this.timeoutCheck(key, currentTime);
            }
        }
    }

    private void processEvents(Set<SelectionKey> selectedKeys) {
        for (SelectionKey key : selectedKeys) {
            this.processEvent(key);
        }
        selectedKeys.clear();
    }

    private void processEvent(SelectionKey key) {
        InternalIOSession session = (InternalIOSession)key.attachment();
        try {
            if (key.isReadable()) {
                session.updateAccessTime();
                session.onInputReady();
            }
            if (key.isWritable()) {
                session.updateAccessTime();
                session.onOutputReady();
            }
        }
        catch (CancelledKeyException ex) {
            session.shutdown(ShutdownType.GRACEFUL);
        }
        catch (RuntimeException ex) {
            session.shutdown(ShutdownType.IMMEDIATE);
            throw ex;
        }
    }

    private void processPendingSessions() throws IOReactorException {
        PendingSession pendingSession;
        while ((pendingSession = this.pendingSessions.poll()) != null) {
            InternalIOSession session;
            SessionRequestImpl sessionRequest;
            try {
                SocketChannel socketChannel = pendingSession.socketChannel;
                sessionRequest = pendingSession.sessionRequest;
                socketChannel.configureBlocking(false);
                SelectionKey key = socketChannel.register(this.selector, 1);
                session = new InternalIOSession(sessionRequest != null ? sessionRequest.getRemoteEndpoint() : null, new IOSessionImpl(key, socketChannel), this.closedSessions);
                session.setHandler(this.eventHandlerFactory.createHandler(session, sessionRequest != null ? sessionRequest.getAttachment() : null));
                session.setSocketTimeout(this.reactorConfig.getSoTimeout().toMillisIntBound());
                key.attach(session);
            }
            catch (ClosedChannelException ex) {
                sessionRequest = pendingSession.sessionRequest;
                if (sessionRequest != null) {
                    sessionRequest.failed(ex);
                }
                return;
            }
            catch (IOException ex) {
                throw new IOReactorException("Failure registering channel with the selector", ex);
            }
            try {
                SessionRequestImpl sessionRequest2 = pendingSession.sessionRequest;
                if (sessionRequest2 != null) {
                    sessionRequest2.completed(session);
                }
                session.onConnected();
            }
            catch (CancelledKeyException ex) {
                session.shutdown(ShutdownType.GRACEFUL);
            }
        }
    }

    private void processClosedSessions() {
        InternalIOSession session;
        while ((session = this.closedSessions.poll()) != null) {
            try {
                session.onDisconnected();
            }
            catch (CancelledKeyException cancelledKeyException) {}
        }
    }

    private void timeoutCheck(SelectionKey key, long now) {
        InternalIOSession session = (InternalIOSession)key.attachment();
        if (session != null) {
            try {
                int timeout = session.getSocketTimeout();
                if (timeout > 0 && session.getLastAccessTime() + (long)timeout < now) {
                    session.onTimeout();
                }
            }
            catch (CancelledKeyException ex) {
                session.shutdown(ShutdownType.GRACEFUL);
            }
            catch (RuntimeException ex) {
                session.shutdown(ShutdownType.IMMEDIATE);
                throw ex;
            }
        }
    }

    private void closePendingSessions() {
        PendingSession pendingSession;
        while ((pendingSession = this.pendingSessions.poll()) != null) {
            this.cancelQuietly(pendingSession.sessionRequest);
            this.closeQuietly(pendingSession.socketChannel);
        }
    }

    private void closeActiveChannels() {
        Set<SelectionKey> keys = this.selector.keys();
        for (SelectionKey key : keys) {
            InternalIOSession session = (InternalIOSession)key.attachment();
            this.closeQuietly(session);
        }
        this.closeQuietly(this.selector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awaitShutdown(TimeValue waitTime) throws InterruptedException {
        Args.notNull(waitTime, "Wait time");
        long deadline = System.currentTimeMillis() + waitTime.toMillis();
        long remaining = waitTime.toMillis();
        Object object = this.shutdownMutex;
        synchronized (object) {
            while (this.status.get().compareTo(IOReactorStatus.SHUT_DOWN) < 0) {
                this.shutdownMutex.wait(remaining);
                remaining = deadline - System.currentTimeMillis();
                if (remaining > 0L) continue;
                return;
            }
        }
    }

    @Override
    public void initiateShutdown() {
        if (this.status.compareAndSet(IOReactorStatus.ACTIVE, IOReactorStatus.SHUTTING_DOWN)) {
            this.selector.wakeup();
        }
    }

    void forceShutdown() {
        this.status.set(IOReactorStatus.SHUT_DOWN);
        this.selector.wakeup();
    }

    @Override
    public void shutdown(ShutdownType shutdownType) {
        this.initiateShutdown();
        try {
            if (shutdownType == ShutdownType.GRACEFUL) {
                this.awaitShutdown(TimeValue.ofSeconds(5L));
            }
            this.forceShutdown();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void close() {
        this.shutdown(ShutdownType.GRACEFUL);
    }

    private static class PendingSession {
        final SocketChannel socketChannel;
        final SessionRequestImpl sessionRequest;

        private PendingSession(SocketChannel socketChannel, SessionRequestImpl sessionRequest) {
            this.socketChannel = socketChannel;
            this.sessionRequest = sessionRequest;
        }
    }
}

