/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.reactor;

import java.util.concurrent.TimeUnit;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TimeValue;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public final class IOReactorConfig {
    private static final int AVAIL_PROCS = Runtime.getRuntime().availableProcessors();
    public static final IOReactorConfig DEFAULT = new Builder().build();
    private final long selectInterval;
    private final int ioThreadCount;
    private final TimeValue soTimeout;
    private final boolean soReuseAddress;
    private final TimeValue soLinger;
    private final boolean soKeepAlive;
    private final boolean tcpNoDelay;
    private final int sndBufSize;
    private final int rcvBufSize;
    private final int backlogSize;

    IOReactorConfig(long selectInterval, int ioThreadCount, TimeValue soTimeout, boolean soReuseAddress, TimeValue soLinger, boolean soKeepAlive, boolean tcpNoDelay, int sndBufSize, int rcvBufSize, int backlogSize) {
        this.selectInterval = selectInterval;
        this.ioThreadCount = ioThreadCount;
        this.soTimeout = soTimeout;
        this.soReuseAddress = soReuseAddress;
        this.soLinger = soLinger;
        this.soKeepAlive = soKeepAlive;
        this.tcpNoDelay = tcpNoDelay;
        this.sndBufSize = sndBufSize;
        this.rcvBufSize = rcvBufSize;
        this.backlogSize = backlogSize;
    }

    public long getSelectInterval() {
        return this.selectInterval;
    }

    public int getIoThreadCount() {
        return this.ioThreadCount;
    }

    public TimeValue getSoTimeout() {
        return this.soTimeout;
    }

    public boolean isSoReuseAddress() {
        return this.soReuseAddress;
    }

    public TimeValue getSoLinger() {
        return this.soLinger;
    }

    public boolean isSoKeepalive() {
        return this.soKeepAlive;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public int getSndBufSize() {
        return this.sndBufSize;
    }

    public int getRcvBufSize() {
        return this.rcvBufSize;
    }

    public int getBacklogSize() {
        return this.backlogSize;
    }

    public static Builder custom() {
        return new Builder();
    }

    public static Builder copy(IOReactorConfig config) {
        Args.notNull(config, "I/O reactor config");
        return new Builder().setSelectInterval(config.getSelectInterval()).setIoThreadCount(config.getIoThreadCount()).setSoTimeout(config.getSoTimeout()).setSoReuseAddress(config.isSoReuseAddress()).setSoLinger(config.getSoLinger()).setSoKeepAlive(config.isSoKeepalive()).setTcpNoDelay(config.isTcpNoDelay()).setSndBufSize(config.getSndBufSize()).setRcvBufSize(config.getRcvBufSize()).setBacklogSize(config.getBacklogSize());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[selectInterval=").append(this.selectInterval).append(", ioThreadCount=").append(this.ioThreadCount).append(", soTimeout=").append(this.soTimeout).append(", soReuseAddress=").append(this.soReuseAddress).append(", soLinger=").append(this.soLinger).append(", soKeepAlive=").append(this.soKeepAlive).append(", tcpNoDelay=").append(this.tcpNoDelay).append(", sndBufSize=").append(this.sndBufSize).append(", rcvBufSize=").append(this.rcvBufSize).append(", backlogSize=").append(this.backlogSize).append("]");
        return builder.toString();
    }

    static /* synthetic */ int access$000() {
        return AVAIL_PROCS;
    }

    public static class Builder {
        private long selectInterval = 1000L;
        private int ioThreadCount = IOReactorConfig.access$000();
        private TimeValue soTimeout = TimeValue.ZERO_MILLISECONDS;
        private boolean soReuseAddress = false;
        private TimeValue soLinger = TimeValue.NEG_ONE_SECONDS;
        private boolean soKeepAlive = false;
        private boolean tcpNoDelay = true;
        private int sndBufSize = 0;
        private int rcvBufSize = 0;
        private int backlogSize = 0;

        Builder() {
        }

        public Builder setSelectInterval(long selectInterval) {
            this.selectInterval = selectInterval;
            return this;
        }

        public Builder setIoThreadCount(int ioThreadCount) {
            this.ioThreadCount = ioThreadCount;
            return this;
        }

        public Builder setSoTimeout(int soTimeout, TimeUnit timeUnit) {
            this.soTimeout = TimeValue.of(soTimeout, timeUnit);
            return this;
        }

        public Builder setSoTimeout(TimeValue soTimeout) {
            this.soTimeout = soTimeout;
            return this;
        }

        public Builder setSoReuseAddress(boolean soReuseAddress) {
            this.soReuseAddress = soReuseAddress;
            return this;
        }

        public Builder setSoLinger(int soLinger, TimeUnit timeUnit) {
            this.soLinger = TimeValue.of(soLinger, timeUnit);
            return this;
        }

        public Builder setSoLinger(TimeValue soLinger) {
            this.soLinger = soLinger;
            return this;
        }

        public Builder setSoKeepAlive(boolean soKeepAlive) {
            this.soKeepAlive = soKeepAlive;
            return this;
        }

        public Builder setTcpNoDelay(boolean tcpNoDelay) {
            this.tcpNoDelay = tcpNoDelay;
            return this;
        }

        public Builder setSndBufSize(int sndBufSize) {
            this.sndBufSize = sndBufSize;
            return this;
        }

        public Builder setRcvBufSize(int rcvBufSize) {
            this.rcvBufSize = rcvBufSize;
            return this;
        }

        public Builder setBacklogSize(int backlogSize) {
            this.backlogSize = backlogSize;
            return this;
        }

        public IOReactorConfig build() {
            return new IOReactorConfig(this.selectInterval, this.ioThreadCount, this.soTimeout != null ? this.soTimeout : TimeValue.ZERO_MILLISECONDS, this.soReuseAddress, this.soLinger != null ? this.soLinger : TimeValue.NEG_ONE_SECONDS, this.soKeepAlive, this.tcpNoDelay, this.sndBufSize, this.rcvBufSize, this.backlogSize);
        }
    }
}

