/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.reactor;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadFactory;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.reactor.AbstractMultiworkerIOReactor;
import org.apache.hc.core5.reactor.IOEventHandlerFactory;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.reactor.IOReactorException;
import org.apache.hc.core5.reactor.IOReactorExceptionHandler;
import org.apache.hc.core5.reactor.IOReactorStatus;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.ListenerEndpoint;
import org.apache.hc.core5.reactor.ListenerEndpointClosedCallback;
import org.apache.hc.core5.reactor.ListenerEndpointImpl;
import org.apache.hc.core5.reactor.ListeningIOReactor;
import org.apache.hc.core5.util.Asserts;

public class DefaultListeningIOReactor
extends AbstractMultiworkerIOReactor
implements ListeningIOReactor {
    private final IOReactorConfig reactorConfig;
    private final IOReactorExceptionHandler exceptionHandler;
    private final Queue<ListenerEndpointImpl> requestQueue;
    private final Set<ListenerEndpointImpl> endpoints;
    private final Set<SocketAddress> pausedEndpoints;
    private volatile boolean paused;

    public DefaultListeningIOReactor(IOEventHandlerFactory eventHandlerFactory, IOReactorConfig ioReactorConfig, ThreadFactory threadFactory, IOReactorExceptionHandler exceptionHandler, Callback<IOSession> sessionShutdownCallback) throws IOReactorException {
        super(eventHandlerFactory, ioReactorConfig, threadFactory, sessionShutdownCallback);
        this.reactorConfig = ioReactorConfig != null ? ioReactorConfig : IOReactorConfig.DEFAULT;
        this.exceptionHandler = exceptionHandler;
        this.requestQueue = new ConcurrentLinkedQueue<ListenerEndpointImpl>();
        this.endpoints = Collections.synchronizedSet(new HashSet());
        this.pausedEndpoints = new HashSet<SocketAddress>();
    }

    public DefaultListeningIOReactor(IOEventHandlerFactory eventHandlerFactory, IOReactorConfig config, IOReactorExceptionHandler exceptionHandler, Callback<IOSession> sessionShutdownCallback) throws IOReactorException {
        this(eventHandlerFactory, config, null, exceptionHandler, sessionShutdownCallback);
    }

    public DefaultListeningIOReactor(IOEventHandlerFactory eventHandlerFactory) throws IOReactorException {
        this(eventHandlerFactory, (IOReactorConfig)null, (IOReactorExceptionHandler)null, (Callback<IOSession>)null);
    }

    @Override
    protected void cancelRequests() {
        ListenerEndpointImpl request;
        while ((request = this.requestQueue.poll()) != null) {
            request.cancel();
        }
    }

    @Override
    protected void processEvents(int readyCount) throws IOReactorException {
        if (!this.paused) {
            this.processSessionRequests();
        }
        if (readyCount > 0) {
            Set<SelectionKey> selectedKeys = this.selector().selectedKeys();
            for (SelectionKey key : selectedKeys) {
                this.processEvent(key);
            }
            selectedKeys.clear();
        }
    }

    private void processEvent(SelectionKey key) throws IOReactorException {
        block7: {
            try {
                if (!key.isAcceptable()) break block7;
                ServerSocketChannel serverChannel = (ServerSocketChannel)key.channel();
                while (true) {
                    SocketChannel socketChannel;
                    block9: {
                        block8: {
                            socketChannel = null;
                            try {
                                socketChannel = serverChannel.accept();
                            }
                            catch (IOException ex) {
                                if (this.exceptionHandler != null && this.exceptionHandler.handle(ex)) break block8;
                                throw new IOReactorException("Failure accepting connection", ex);
                            }
                        }
                        if (socketChannel == null) break block7;
                        try {
                            this.prepareSocket(socketChannel.socket());
                        }
                        catch (IOException ex) {
                            if (this.exceptionHandler != null && this.exceptionHandler.handle(ex)) break block9;
                            throw new IOReactorException("Failure initalizing socket", ex);
                        }
                    }
                    this.enqueuePendingSession(socketChannel, null);
                }
            }
            catch (CancelledKeyException ex) {
                ListenerEndpoint endpoint = (ListenerEndpoint)key.attachment();
                this.endpoints.remove(endpoint);
                key.attach(null);
            }
        }
    }

    private ListenerEndpointImpl createEndpoint(SocketAddress address) {
        return new ListenerEndpointImpl(address, new ListenerEndpointClosedCallback(){

            @Override
            public void endpointClosed(ListenerEndpoint endpoint) {
                DefaultListeningIOReactor.this.endpoints.remove(endpoint);
            }
        });
    }

    @Override
    public ListenerEndpoint listen(SocketAddress address) {
        IOReactorStatus status = this.getStatus();
        Asserts.check(status == IOReactorStatus.INACTIVE || status == IOReactorStatus.ACTIVE, "I/O reactor has been shut down");
        ListenerEndpointImpl request = this.createEndpoint(address);
        this.requestQueue.add(request);
        this.selector().wakeup();
        return request;
    }

    private void processSessionRequests() throws IOReactorException {
        ListenerEndpointImpl request;
        while ((request = this.requestQueue.poll()) != null) {
            ServerSocketChannel serverChannel;
            SocketAddress address = request.getAddress();
            try {
                serverChannel = ServerSocketChannel.open();
            }
            catch (IOException ex) {
                throw new IOReactorException("Failure opening server socket", ex);
            }
            try {
                ServerSocket socket = serverChannel.socket();
                socket.setReuseAddress(this.reactorConfig.isSoReuseAddress());
                int millis = this.reactorConfig.getSoTimeout().toMillisIntBound();
                if (millis > 0) {
                    socket.setSoTimeout(millis);
                }
                if (this.reactorConfig.getRcvBufSize() > 0) {
                    socket.setReceiveBufferSize(this.reactorConfig.getRcvBufSize());
                }
                serverChannel.configureBlocking(false);
                socket.bind(address, this.reactorConfig.getBacklogSize());
            }
            catch (IOException ex) {
                DefaultListeningIOReactor.closeChannel(serverChannel);
                request.failed(ex);
                if (this.exceptionHandler == null || !this.exceptionHandler.handle(ex)) {
                    throw new IOReactorException("Failure binding socket to address " + address, ex);
                }
                return;
            }
            try {
                SelectionKey key = serverChannel.register(this.selector(), 16);
                key.attach(request);
                request.setKey(key);
            }
            catch (IOException ex) {
                DefaultListeningIOReactor.closeChannel(serverChannel);
                throw new IOReactorException("Failure registering channel with the selector", ex);
            }
            this.endpoints.add(request);
            request.completed(serverChannel.socket().getLocalSocketAddress());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ListenerEndpoint> getEndpoints() {
        HashSet<ListenerEndpoint> set = new HashSet<ListenerEndpoint>();
        Set<ListenerEndpointImpl> set2 = this.endpoints;
        synchronized (set2) {
            Iterator<ListenerEndpointImpl> it = this.endpoints.iterator();
            while (it.hasNext()) {
                ListenerEndpoint endpoint = it.next();
                if (!endpoint.isClosed()) {
                    set.add(endpoint);
                    continue;
                }
                it.remove();
            }
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause() throws IOException {
        if (this.paused) {
            return;
        }
        this.paused = true;
        Set<ListenerEndpointImpl> set = this.endpoints;
        synchronized (set) {
            for (ListenerEndpointImpl endpoint : this.endpoints) {
                if (endpoint.isClosed()) continue;
                endpoint.close();
                this.pausedEndpoints.add(endpoint.getAddress());
            }
            this.endpoints.clear();
        }
    }

    @Override
    public void resume() throws IOException {
        if (!this.paused) {
            return;
        }
        this.paused = false;
        for (SocketAddress address : this.pausedEndpoints) {
            ListenerEndpointImpl request = this.createEndpoint(address);
            this.requestQueue.add(request);
        }
        this.pausedEndpoints.clear();
        this.selector().wakeup();
    }
}

