/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.reactor;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadFactory;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.reactor.AbstractMultiworkerIOReactor;
import org.apache.hc.core5.reactor.ConnectingIOReactor;
import org.apache.hc.core5.reactor.IOEventHandlerFactory;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.reactor.IOReactorException;
import org.apache.hc.core5.reactor.IOReactorStatus;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.SessionRequest;
import org.apache.hc.core5.reactor.SessionRequestCallback;
import org.apache.hc.core5.reactor.SessionRequestHandle;
import org.apache.hc.core5.reactor.SessionRequestImpl;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Asserts;

public class DefaultConnectingIOReactor
extends AbstractMultiworkerIOReactor
implements ConnectingIOReactor {
    private final IOReactorConfig reactorConfig;
    private final Queue<SessionRequestImpl> requestQueue;
    private final long selectInterval;
    private long lastTimeoutCheck;

    public DefaultConnectingIOReactor(IOEventHandlerFactory eventHandlerFactory, IOReactorConfig ioReactorConfig, ThreadFactory threadFactory, Callback<IOSession> sessionShutdownCallback) throws IOReactorException {
        super(eventHandlerFactory, ioReactorConfig, threadFactory, sessionShutdownCallback);
        this.reactorConfig = ioReactorConfig != null ? ioReactorConfig : IOReactorConfig.DEFAULT;
        this.requestQueue = new ConcurrentLinkedQueue<SessionRequestImpl>();
        this.selectInterval = this.reactorConfig.getSelectInterval();
        this.lastTimeoutCheck = System.currentTimeMillis();
    }

    public DefaultConnectingIOReactor(IOEventHandlerFactory eventHandlerFactory, IOReactorConfig config, Callback<IOSession> sessionShutdownCallback) throws IOReactorException {
        this(eventHandlerFactory, config, null, sessionShutdownCallback);
    }

    public DefaultConnectingIOReactor(IOEventHandlerFactory eventHandlerFactory) throws IOReactorException {
        this(eventHandlerFactory, null, null);
    }

    @Override
    protected void cancelRequests() {
        SessionRequestImpl request;
        while ((request = this.requestQueue.poll()) != null) {
            request.cancel();
        }
    }

    @Override
    protected void processEvents(int readyCount) throws IOReactorException {
        long currentTime;
        this.processSessionRequests();
        if (readyCount > 0) {
            Set<SelectionKey> selectedKeys = this.selector().selectedKeys();
            for (SelectionKey key : selectedKeys) {
                this.processEvent(key);
            }
            selectedKeys.clear();
        }
        if ((currentTime = System.currentTimeMillis()) - this.lastTimeoutCheck >= this.selectInterval) {
            this.lastTimeoutCheck = currentTime;
            Set<SelectionKey> keys = this.selector().keys();
            this.processTimeouts(keys);
        }
    }

    private void processEvent(SelectionKey key) {
        block8: {
            try {
                if (!key.isConnectable()) break block8;
                SocketChannel socketChannel = (SocketChannel)key.channel();
                SessionRequestHandle requestHandle = (SessionRequestHandle)key.attachment();
                SessionRequestImpl sessionRequest = requestHandle.getSessionRequest();
                try {
                    socketChannel.finishConnect();
                }
                catch (IOException ex) {
                    sessionRequest.failed(ex);
                }
                key.cancel();
                key.attach(null);
                if (!sessionRequest.isCompleted()) {
                    this.enqueuePendingSession(socketChannel, sessionRequest);
                } else {
                    try {
                        socketChannel.close();
                    }
                    catch (IOException ignore) {}
                }
            }
            catch (CancelledKeyException ex) {
                SessionRequestImpl sessionRequest;
                SessionRequestHandle requestHandle = (SessionRequestHandle)key.attachment();
                key.attach(null);
                if (requestHandle == null || (sessionRequest = requestHandle.getSessionRequest()) == null) break block8;
                sessionRequest.cancel();
            }
        }
    }

    private void processTimeouts(Set<SelectionKey> keys) {
        long now = System.currentTimeMillis();
        for (SelectionKey key : keys) {
            SessionRequestHandle handle;
            SessionRequestImpl sessionRequest;
            int timeout;
            Object attachment = key.attachment();
            if (!(attachment instanceof SessionRequestHandle) || (timeout = (sessionRequest = (handle = (SessionRequestHandle)key.attachment()).getSessionRequest()).getConnectTimeout()) <= 0 || handle.getRequestTime() + (long)timeout >= now) continue;
            sessionRequest.timeout();
        }
    }

    @Override
    public SessionRequest connect(NamedEndpoint remoteEndpoint, SocketAddress remoteAddress, SocketAddress localAddress, Object attachment, SessionRequestCallback callback) {
        Args.notNull(remoteEndpoint, "Remote endpoint");
        IOReactorStatus status = this.getStatus();
        Asserts.check(status == IOReactorStatus.INACTIVE || status == IOReactorStatus.ACTIVE, "I/O reactor has been shut down");
        SessionRequestImpl sessionRequest = new SessionRequestImpl(remoteEndpoint, remoteAddress != null ? remoteAddress : new InetSocketAddress(remoteEndpoint.getHostName(), remoteEndpoint.getPort()), localAddress, attachment, callback);
        this.requestQueue.add(sessionRequest);
        this.selector().wakeup();
        return sessionRequest;
    }

    private void validateAddress(SocketAddress address) throws UnknownHostException {
        InetSocketAddress endpoint;
        if (address == null) {
            return;
        }
        if (address instanceof InetSocketAddress && (endpoint = (InetSocketAddress)address).isUnresolved()) {
            throw new UnknownHostException(endpoint.getHostName());
        }
    }

    private void processSessionRequests() throws IOReactorException {
        SessionRequestImpl request;
        while ((request = this.requestQueue.poll()) != null) {
            SocketChannel socketChannel;
            if (request.isCompleted()) continue;
            try {
                socketChannel = SocketChannel.open();
            }
            catch (IOException ex) {
                request.failed(ex);
                return;
            }
            try {
                boolean connected;
                this.validateAddress(request.getLocalAddress());
                this.validateAddress(request.getRemoteAddress());
                socketChannel.configureBlocking(false);
                this.prepareSocket(socketChannel.socket());
                if (request.getLocalAddress() != null) {
                    Socket sock = socketChannel.socket();
                    sock.setReuseAddress(this.reactorConfig.isSoReuseAddress());
                    sock.bind(request.getLocalAddress());
                }
                if (connected = socketChannel.connect(request.getRemoteAddress())) {
                    this.enqueuePendingSession(socketChannel, request);
                    continue;
                }
            }
            catch (IOException ex) {
                DefaultConnectingIOReactor.closeChannel(socketChannel);
                request.failed(ex);
                return;
            }
            SessionRequestHandle requestHandle = new SessionRequestHandle(request);
            try {
                SelectionKey key = socketChannel.register(this.selector(), 8, requestHandle);
                request.setKey(key);
            }
            catch (IOException ex) {
                DefaultConnectingIOReactor.closeChannel(socketChannel);
                throw new IOReactorException("Failure registering channel with the selector", ex);
            }
        }
    }
}

