/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.reactor;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.core5.concurrent.DefaultThreadFactory;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.io.ShutdownType;
import org.apache.hc.core5.reactor.ExceptionEvent;
import org.apache.hc.core5.reactor.IOEventHandlerFactory;
import org.apache.hc.core5.reactor.IOReactor;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.reactor.IOReactorException;
import org.apache.hc.core5.reactor.IOReactorImpl;
import org.apache.hc.core5.reactor.IOReactorStatus;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.SessionRequestImpl;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TimeValue;

public abstract class AbstractMultiworkerIOReactor
implements IOReactor {
    private final IOReactorConfig reactorConfig;
    private final Selector selector;
    private final int workerCount;
    private final IOEventHandlerFactory eventHandlerFactory;
    private final ThreadFactory threadFactory;
    private final Callback<IOSession> sessionShutdownCallback;
    private final IOReactorImpl[] dispatchers;
    private final IODispatchWorker[] workers;
    private final Thread[] threads;
    private final List<ExceptionEvent> auditLog;
    private final AtomicReference<IOReactorStatus> status;
    private final Object shutdownMutex;
    private int currentWorker = 0;

    public AbstractMultiworkerIOReactor(IOEventHandlerFactory eventHandlerFactory, IOReactorConfig reactorConfig, ThreadFactory threadFactory, Callback<IOSession> sessionShutdownCallback) throws IOReactorException {
        this.eventHandlerFactory = Args.notNull(eventHandlerFactory, "Event handler factory");
        this.reactorConfig = reactorConfig != null ? reactorConfig : IOReactorConfig.DEFAULT;
        try {
            this.selector = Selector.open();
        }
        catch (IOException ex) {
            throw new IOReactorException("Failure opening selector", ex);
        }
        this.threadFactory = threadFactory != null ? threadFactory : new DefaultThreadFactory("I/O dispatcher", true);
        this.sessionShutdownCallback = sessionShutdownCallback;
        this.auditLog = new ArrayList<ExceptionEvent>();
        this.workerCount = this.reactorConfig.getIoThreadCount();
        this.dispatchers = new IOReactorImpl[this.workerCount];
        this.workers = new IODispatchWorker[this.workerCount];
        this.threads = new Thread[this.workerCount];
        this.status = new AtomicReference<IOReactorStatus>(IOReactorStatus.INACTIVE);
        this.shutdownMutex = new Object();
    }

    public AbstractMultiworkerIOReactor(IOEventHandlerFactory eventHandlerFactory, Callback<IOSession> sessionShutdownCallback) throws IOReactorException {
        this(eventHandlerFactory, null, null, sessionShutdownCallback);
    }

    Selector selector() {
        return this.selector;
    }

    @Override
    public IOReactorStatus getStatus() {
        return this.status.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ExceptionEvent> getAuditLog() {
        List<ExceptionEvent> list = this.auditLog;
        synchronized (list) {
            return new ArrayList<ExceptionEvent>(this.auditLog);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addExceptionEvent(Throwable ex, Date timestamp) {
        if (ex == null) {
            return;
        }
        List<ExceptionEvent> list = this.auditLog;
        synchronized (list) {
            this.auditLog.add(new ExceptionEvent(ex, timestamp != null ? timestamp : new Date()));
        }
    }

    void addExceptionEvent(Throwable ex) {
        this.addExceptionEvent(ex, null);
    }

    protected abstract void processEvents(int var1) throws IOReactorException;

    protected abstract void cancelRequests();

    @Override
    public void execute() throws InterruptedIOException, IOReactorException {
        if (this.status.compareAndSet(IOReactorStatus.INACTIVE, IOReactorStatus.ACTIVE)) {
            this.doExecute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExecute() throws InterruptedIOException, IOReactorException {
        try {
            IOReactorImpl dispatcher;
            int i;
            for (i = 0; i < this.dispatchers.length; ++i) {
                this.dispatchers[i] = dispatcher = new IOReactorImpl(this.eventHandlerFactory, this.reactorConfig, this.sessionShutdownCallback);
            }
            for (i = 0; i < this.workerCount; ++i) {
                dispatcher = this.dispatchers[i];
                this.workers[i] = new IODispatchWorker(dispatcher);
                this.threads[i] = this.threadFactory.newThread(this.workers[i]);
            }
            for (i = 0; i < this.workerCount; ++i) {
                if (this.status.get().compareTo(IOReactorStatus.ACTIVE) != 0) {
                    return;
                }
                this.threads[i].start();
            }
            long selectTimeout = this.reactorConfig.getSelectInterval();
            while (!Thread.currentThread().isInterrupted()) {
                int readyCount;
                if (this.status.get().compareTo(IOReactorStatus.ACTIVE) != 0) {
                    break;
                }
                try {
                    readyCount = this.selector.select(selectTimeout);
                }
                catch (InterruptedIOException ex) {
                    throw ex;
                }
                catch (IOException ex) {
                    throw new IOReactorException("Unexpected selector failure", ex);
                }
                if (this.status.get().compareTo(IOReactorStatus.ACTIVE) != 0) {
                    break;
                }
                this.processEvents(readyCount);
                for (int i2 = 0; i2 < this.workerCount; ++i2) {
                    IODispatchWorker worker = this.workers[i2];
                    Throwable ex = worker.getThrowable();
                    if (ex == null) continue;
                    throw new IOReactorException("I/O dispatch worker terminated abnormally", ex);
                }
            }
        }
        catch (ClosedSelectorException ex) {
            this.addExceptionEvent(ex);
        }
        catch (IOReactorException ex) {
            if (ex.getCause() != null) {
                this.addExceptionEvent(ex.getCause());
            }
            throw ex;
        }
        finally {
            try {
                this.cancelRequests();
                this.closeActiveChannels();
                try {
                    this.selector.close();
                }
                catch (IOException ex) {
                    this.addExceptionEvent(ex);
                }
            }
            finally {
                Object ex = this.shutdownMutex;
                synchronized (ex) {
                    this.status.set(IOReactorStatus.SHUT_DOWN);
                    this.shutdownMutex.notifyAll();
                }
            }
        }
    }

    private void closeActiveChannels() {
        for (SelectionKey key : this.selector.keys()) {
            try {
                SelectableChannel channel = key.channel();
                if (channel == null) continue;
                channel.close();
            }
            catch (IOException ex) {
                this.addExceptionEvent(ex);
            }
        }
    }

    protected void enqueuePendingSession(SocketChannel channel, SessionRequestImpl sessionRequest) {
        int i = Math.abs(this.currentWorker++ % this.workerCount);
        this.dispatchers[i].enqueuePendingSession(channel, sessionRequest);
    }

    protected SelectionKey registerChannel(SelectableChannel channel, int ops) throws ClosedChannelException {
        return channel.register(this.selector, ops);
    }

    protected void prepareSocket(Socket socket) throws IOException {
        int linger;
        socket.setTcpNoDelay(this.reactorConfig.isTcpNoDelay());
        socket.setKeepAlive(this.reactorConfig.isSoKeepalive());
        int millis = this.reactorConfig.getSoTimeout().toMillisIntBound();
        if (millis > 0) {
            socket.setSoTimeout(millis);
        }
        if (this.reactorConfig.getSndBufSize() > 0) {
            socket.setSendBufferSize(this.reactorConfig.getSndBufSize());
        }
        if (this.reactorConfig.getRcvBufSize() > 0) {
            socket.setReceiveBufferSize(this.reactorConfig.getRcvBufSize());
        }
        if ((linger = this.reactorConfig.getSoLinger().toSecondsIntBound()) >= 0) {
            socket.setSoLinger(true, linger);
        }
    }

    @Override
    public void initiateShutdown() {
        if (this.status.compareAndSet(IOReactorStatus.ACTIVE, IOReactorStatus.SHUTTING_DOWN)) {
            this.selector.wakeup();
            for (int i = 0; i < this.workerCount; ++i) {
                IOReactorImpl dispatcher = this.dispatchers[i];
                if (dispatcher == null) continue;
                dispatcher.initiateShutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awaitShutdown(TimeValue waitTime) throws InterruptedException {
        int i;
        Args.notNull(waitTime, "Wait time");
        if (this.status.get() == IOReactorStatus.INACTIVE) {
            return;
        }
        long deadline = System.currentTimeMillis() + waitTime.toMillis();
        long remaining = waitTime.toMillis();
        Object object = this.shutdownMutex;
        synchronized (object) {
            while (this.status.get().compareTo(IOReactorStatus.SHUT_DOWN) < 0) {
                this.shutdownMutex.wait(remaining);
                remaining = deadline - System.currentTimeMillis();
                if (remaining > 0L) continue;
                return;
            }
        }
        for (i = 0; i < this.dispatchers.length; ++i) {
            IOReactorImpl dispatcher = this.dispatchers[i];
            if (dispatcher == null || dispatcher.getStatus().compareTo(IOReactorStatus.SHUT_DOWN) >= 0) continue;
            dispatcher.awaitShutdown(TimeValue.of(remaining, TimeUnit.MILLISECONDS));
            remaining = deadline - System.currentTimeMillis();
            if (remaining > 0L) continue;
            return;
        }
        for (i = 0; i < this.threads.length; ++i) {
            Thread thread = this.threads[i];
            thread.join(remaining);
            remaining = deadline - System.currentTimeMillis();
            if (remaining > 0L) continue;
            return;
        }
    }

    private void forceShutdown() {
        int i;
        this.status.set(IOReactorStatus.SHUT_DOWN);
        this.selector.wakeup();
        for (i = 0; i < this.dispatchers.length; ++i) {
            IOReactorImpl dispatcher = this.dispatchers[i];
            if (dispatcher == null) continue;
            dispatcher.forceShutdown();
        }
        for (i = 0; i < this.threads.length; ++i) {
            Thread thread = this.threads[i];
            thread.interrupt();
        }
    }

    @Override
    public void shutdown(ShutdownType shutdownType) {
        if (this.status.get() == IOReactorStatus.INACTIVE) {
            return;
        }
        this.initiateShutdown();
        try {
            if (shutdownType == ShutdownType.GRACEFUL) {
                this.awaitShutdown(TimeValue.ofSeconds(5L));
            }
            this.forceShutdown();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void close() {
        this.shutdown(ShutdownType.GRACEFUL);
    }

    static void closeChannel(Channel channel) {
        try {
            channel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static class IODispatchWorker
    implements Runnable {
        final IOReactorImpl dispatcher;
        private volatile Throwable throwable;

        public IODispatchWorker(IOReactorImpl dispatcher) {
            this.dispatcher = dispatcher;
        }

        @Override
        public void run() {
            try {
                this.dispatcher.execute();
            }
            catch (Error ex) {
                this.throwable = ex;
                throw ex;
            }
            catch (Exception ex) {
                this.throwable = ex;
            }
        }

        public Throwable getThrowable() {
            return this.throwable;
        }
    }
}

