/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.pool;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.apache.hc.core5.io.GracefullyCloseable;
import org.apache.hc.core5.io.ShutdownType;
import org.apache.hc.core5.pool.PoolEntry;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Asserts;
import org.apache.hc.core5.util.TimeValue;

final class RoutePool<T, C extends GracefullyCloseable> {
    private final T route;
    private final Set<PoolEntry<T, C>> leased;
    private final LinkedList<PoolEntry<T, C>> available;

    RoutePool(T route) {
        this.route = route;
        this.leased = new HashSet<PoolEntry<T, C>>();
        this.available = new LinkedList();
    }

    public final T getRoute() {
        return this.route;
    }

    public int getLeasedCount() {
        return this.leased.size();
    }

    public int getAvailableCount() {
        return this.available.size();
    }

    public int getAllocatedCount() {
        return this.available.size() + this.leased.size();
    }

    public PoolEntry<T, C> getFree(Object state) {
        if (!this.available.isEmpty()) {
            PoolEntry entry;
            Iterator it;
            if (state != null) {
                it = this.available.iterator();
                while (it.hasNext()) {
                    entry = (PoolEntry)it.next();
                    if (!state.equals(entry.getState())) continue;
                    it.remove();
                    this.leased.add(entry);
                    return entry;
                }
            }
            it = this.available.iterator();
            while (it.hasNext()) {
                entry = (PoolEntry)it.next();
                if (entry.getState() != null) continue;
                it.remove();
                this.leased.add(entry);
                return entry;
            }
        }
        return null;
    }

    public PoolEntry<T, C> getLastUsed() {
        if (!this.available.isEmpty()) {
            return this.available.getLast();
        }
        return null;
    }

    public boolean remove(PoolEntry<T, C> entry) {
        Args.notNull(entry, "Pool entry");
        return this.available.remove(entry) || this.leased.remove(entry);
    }

    public void free(PoolEntry<T, C> entry, boolean reusable) {
        Args.notNull(entry, "Pool entry");
        boolean found = this.leased.remove(entry);
        Asserts.check(found, "Entry %s has not been leased from this pool", entry);
        if (reusable) {
            this.available.addFirst(entry);
        }
    }

    public PoolEntry<T, C> createEntry(TimeValue timeToLive) {
        PoolEntry entry = new PoolEntry(this.route, timeToLive);
        this.leased.add(entry);
        return entry;
    }

    public void shutdown(ShutdownType shutdownType) {
        for (PoolEntry poolEntry : this.available) {
            poolEntry.discardConnection(shutdownType);
        }
        this.available.clear();
        for (PoolEntry poolEntry : this.leased) {
            poolEntry.discardConnection(shutdownType);
        }
        this.leased.clear();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[route: ");
        buffer.append(this.route);
        buffer.append("][leased: ");
        buffer.append(this.leased.size());
        buffer.append("][available: ");
        buffer.append(this.available.size());
        buffer.append("]");
        return buffer.toString();
    }
}

