/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.pool;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.core5.io.GracefullyCloseable;
import org.apache.hc.core5.io.ShutdownType;
import org.apache.hc.core5.pool.LeaseRequest;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TimeValue;

public final class PoolEntry<T, C extends GracefullyCloseable> {
    private final T route;
    private final TimeValue timeToLive;
    private final AtomicReference<C> connRef;
    private volatile Object state;
    private volatile long created;
    private volatile long updated;
    private volatile long expiry;
    private volatile long validityDeadline;

    public PoolEntry(T route, TimeValue timeToLive) {
        this.route = Args.notNull(route, "Route");
        this.timeToLive = TimeValue.defaultsToNegativeOneMillisecond(timeToLive);
        this.connRef = new AtomicReference<Object>(null);
    }

    public PoolEntry(T route) {
        this(route, null);
    }

    public T getRoute() {
        return this.route;
    }

    public C getConnection() {
        return (C)((GracefullyCloseable)this.connRef.get());
    }

    public long getValidityDeadline() {
        return this.validityDeadline;
    }

    public Object getState() {
        return this.state;
    }

    public long getUpdated() {
        return this.updated;
    }

    public long getExpiry() {
        return this.expiry;
    }

    public boolean hasConnection() {
        return this.connRef.get() != null;
    }

    public void assignConnection(C conn) {
        Args.notNull(conn, "connection");
        if (!this.connRef.compareAndSet(null, conn)) {
            throw new IllegalStateException("Connection already assigned");
        }
        this.updated = this.created = System.currentTimeMillis();
        this.expiry = this.validityDeadline = LeaseRequest.calculateDeadline(this.created, this.timeToLive);
        this.state = null;
    }

    public void discardConnection(ShutdownType shutdownType) {
        GracefullyCloseable connection = this.connRef.getAndSet(null);
        if (connection != null) {
            this.state = null;
            this.created = 0L;
            this.updated = 0L;
            this.expiry = 0L;
            this.validityDeadline = 0L;
            connection.shutdown(shutdownType);
        }
    }

    public void updateExpiry(TimeValue expiryTime) {
        Args.notNull(expiryTime, "Expiry time");
        long currentTime = System.currentTimeMillis();
        long newExpiry = LeaseRequest.calculateDeadline(currentTime, expiryTime);
        this.expiry = Math.min(newExpiry, this.getValidityDeadline());
        this.updated = currentTime;
    }

    public void updateState(Object state) {
        this.state = state;
        this.updated = System.currentTimeMillis();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[route:");
        buffer.append(this.route);
        buffer.append("][state:");
        buffer.append(this.state);
        buffer.append("]");
        return buffer.toString();
    }
}

