/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.pool;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.concurrent.BasicFuture;
import org.apache.hc.core5.io.GracefullyCloseable;
import org.apache.hc.core5.pool.PoolEntry;
import org.apache.hc.core5.util.TimeValue;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
class LeaseRequest<T, C extends GracefullyCloseable> {
    private final T route;
    private final Object state;
    private final long deadline;
    private final BasicFuture<PoolEntry<T, C>> future;
    private final AtomicBoolean completed;
    private volatile PoolEntry<T, C> result;
    private volatile Exception ex;

    static long calculateDeadline(long currentTimeMillis, TimeValue timeValue) {
        long time;
        long l = time = TimeValue.isPositive(timeValue) ? currentTimeMillis + timeValue.toMillis() : Long.MAX_VALUE;
        if (time < 0L && TimeValue.isPositive(timeValue)) {
            return Long.MAX_VALUE;
        }
        return time;
    }

    public LeaseRequest(T route, Object state, TimeValue requestTimeout, BasicFuture<PoolEntry<T, C>> future) {
        this.route = route;
        this.state = state;
        this.deadline = LeaseRequest.calculateDeadline(System.currentTimeMillis(), requestTimeout);
        this.future = future;
        this.completed = new AtomicBoolean(false);
    }

    public T getRoute() {
        return this.route;
    }

    public Object getState() {
        return this.state;
    }

    public long getDeadline() {
        return this.deadline;
    }

    public boolean isDone() {
        return this.completed.get();
    }

    public void failed(Exception ex) {
        if (this.completed.compareAndSet(false, true)) {
            this.ex = ex;
        }
    }

    public void completed(PoolEntry<T, C> result) {
        if (this.completed.compareAndSet(false, true)) {
            this.result = result;
        }
    }

    public BasicFuture<PoolEntry<T, C>> getFuture() {
        return this.future;
    }

    public PoolEntry<T, C> getResult() {
        return this.result;
    }

    public Exception getException() {
        return this.ex;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        buffer.append(this.route);
        buffer.append("][");
        buffer.append(this.state);
        buffer.append("]");
        return buffer.toString();
    }
}

