/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.nio.support;

import java.io.IOException;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.nio.AsyncRequestConsumer;
import org.apache.hc.core5.http.nio.support.AbstractServerExchangeHandler;
import org.apache.hc.core5.http.nio.support.RequestConsumerSupplier;
import org.apache.hc.core5.http.nio.support.ResponseHandler;
import org.apache.hc.core5.http.nio.support.ResponseTrigger;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;

public class BasicServerExchangeHandler<T>
extends AbstractServerExchangeHandler<T> {
    private final RequestConsumerSupplier<T> consumerSupplier;
    private final ResponseHandler<T> responseHandler;

    public BasicServerExchangeHandler(RequestConsumerSupplier<T> consumerSupplier, ResponseHandler<T> responseHandler) {
        this.consumerSupplier = Args.notNull(consumerSupplier, "Consumer supplier");
        this.responseHandler = Args.notNull(responseHandler, "Response handler");
    }

    @Override
    protected AsyncRequestConsumer<T> supplyConsumer(HttpRequest request, HttpContext context) throws HttpException {
        return this.consumerSupplier.get(request, context);
    }

    @Override
    protected void handle(T requestMessage, ResponseTrigger responseTrigger, HttpContext context) throws HttpException, IOException {
        this.responseHandler.handle(requestMessage, responseTrigger, context);
    }
}

