/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.nio.support;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.nio.AsyncClientExchangeHandler;
import org.apache.hc.core5.http.nio.AsyncRequestProducer;
import org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import org.apache.hc.core5.http.nio.CapacityChannel;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.http.nio.RequestChannel;
import org.apache.hc.core5.util.Args;

public class BasicClientExchangeHandler<T>
implements AsyncClientExchangeHandler {
    private final AsyncRequestProducer requestProducer;
    private final AsyncResponseConsumer<T> responseConsumer;
    private final FutureCallback<T> resultCallback;
    private final AtomicBoolean outputTerminated;

    public BasicClientExchangeHandler(AsyncRequestProducer requestProducer, AsyncResponseConsumer<T> responseConsumer, FutureCallback<T> resultCallback) {
        this.requestProducer = Args.notNull(requestProducer, "Request producer");
        this.responseConsumer = Args.notNull(responseConsumer, "Response consumer");
        this.resultCallback = resultCallback;
        this.outputTerminated = new AtomicBoolean(false);
    }

    @Override
    public void produceRequest(RequestChannel requestChannel) throws HttpException, IOException {
        HttpRequest request = this.requestProducer.produceRequest();
        EntityDetails entityDetails = this.requestProducer.getEntityDetails();
        requestChannel.sendRequest(request, entityDetails);
    }

    @Override
    public int available() {
        return this.requestProducer.available();
    }

    @Override
    public void produce(DataStreamChannel channel) throws IOException {
        if (this.outputTerminated.get()) {
            channel.endStream();
            return;
        }
        this.requestProducer.produce(channel);
    }

    @Override
    public void consumeInformation(HttpResponse response) throws HttpException, IOException {
    }

    @Override
    public void consumeResponse(HttpResponse response, EntityDetails entityDetails) throws HttpException, IOException {
        if (response.getCode() >= 400) {
            this.outputTerminated.set(true);
            this.requestProducer.releaseResources();
        }
        this.responseConsumer.consumeResponse(response, entityDetails, new FutureCallback<T>(){

            @Override
            public void completed(T result) {
                BasicClientExchangeHandler.this.releaseResources();
                if (BasicClientExchangeHandler.this.resultCallback != null) {
                    BasicClientExchangeHandler.this.resultCallback.completed(result);
                }
            }

            @Override
            public void failed(Exception ex) {
                BasicClientExchangeHandler.this.releaseResources();
                if (BasicClientExchangeHandler.this.resultCallback != null) {
                    BasicClientExchangeHandler.this.resultCallback.failed(ex);
                }
            }

            @Override
            public void cancelled() {
                BasicClientExchangeHandler.this.releaseResources();
                if (BasicClientExchangeHandler.this.resultCallback != null) {
                    BasicClientExchangeHandler.this.resultCallback.cancelled();
                }
            }
        });
    }

    @Override
    public void cancel() {
        this.releaseResources();
        if (this.resultCallback != null) {
            this.resultCallback.cancelled();
        }
    }

    @Override
    public void updateCapacity(CapacityChannel capacityChannel) throws IOException {
        this.responseConsumer.updateCapacity(capacityChannel);
    }

    @Override
    public int consume(ByteBuffer src) throws IOException {
        return this.responseConsumer.consume(src);
    }

    @Override
    public void streamEnd(List<? extends Header> trailers) throws HttpException, IOException {
        this.responseConsumer.streamEnd(trailers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void failed(Exception cause) {
        try {
            this.requestProducer.failed(cause);
            this.responseConsumer.failed(cause);
        }
        finally {
            this.releaseResources();
            if (this.resultCallback != null) {
                this.resultCallback.failed(cause);
            }
        }
    }

    @Override
    public final void releaseResources() {
        this.requestProducer.releaseResources();
        this.responseConsumer.releaseResources();
    }
}

