/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.nio.support;

import java.io.IOException;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.AsyncResponseProducer;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.util.Args;

public class BasicAsyncResponseProducer
implements AsyncResponseProducer {
    private final HttpResponse response;
    private final AsyncEntityProducer entityProducer;

    public BasicAsyncResponseProducer(HttpResponse response, AsyncEntityProducer entityProducer) {
        Args.notNull(response, "Response");
        this.response = response;
        this.entityProducer = entityProducer;
    }

    @Override
    public HttpResponse produceResponse() {
        return this.response;
    }

    @Override
    public final EntityDetails getEntityDetails() {
        return this.entityProducer;
    }

    @Override
    public final int available() {
        return this.entityProducer != null ? this.entityProducer.available() : 0;
    }

    @Override
    public final void produce(DataStreamChannel channel) throws IOException {
        if (this.entityProducer != null) {
            this.entityProducer.produce(channel);
        }
    }

    @Override
    public final void failed(Exception cause) {
        this.releaseResources();
    }

    @Override
    public final void releaseResources() {
        if (this.entityProducer != null) {
            this.entityProducer.releaseResources();
        }
    }
}

