/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.nio.support;

import java.io.IOException;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.AsyncRequestProducer;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.util.Args;

public class BasicAsyncRequestProducer
implements AsyncRequestProducer {
    private final HttpRequest request;
    private final AsyncEntityProducer entityProducer;

    public BasicAsyncRequestProducer(HttpRequest request, AsyncEntityProducer entityProducer) {
        Args.notNull(request, "Request");
        this.request = request;
        this.entityProducer = entityProducer;
    }

    @Override
    public final HttpRequest produceRequest() {
        return this.request;
    }

    @Override
    public final EntityDetails getEntityDetails() {
        return this.entityProducer;
    }

    @Override
    public final int available() {
        return this.entityProducer != null ? this.entityProducer.available() : 0;
    }

    @Override
    public final void produce(DataStreamChannel channel) throws IOException {
        if (this.entityProducer != null) {
            this.entityProducer.produce(channel);
        }
    }

    @Override
    public final void failed(Exception cause) {
        this.releaseResources();
    }

    @Override
    public final void releaseResources() {
        if (this.entityProducer != null) {
            this.entityProducer.releaseResources();
        }
    }
}

