/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.nio.support;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.message.BasicHttpResponse;
import org.apache.hc.core5.http.nio.AsyncPushProducer;
import org.apache.hc.core5.http.nio.AsyncRequestConsumer;
import org.apache.hc.core5.http.nio.AsyncResponseProducer;
import org.apache.hc.core5.http.nio.AsyncServerExchangeHandler;
import org.apache.hc.core5.http.nio.BasicResponseProducer;
import org.apache.hc.core5.http.nio.CapacityChannel;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.http.nio.HttpContextAware;
import org.apache.hc.core5.http.nio.ResponseChannel;
import org.apache.hc.core5.http.nio.support.ResponseTrigger;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Asserts;

public abstract class AbstractServerExchangeHandler<T>
implements HttpContextAware,
AsyncServerExchangeHandler {
    private final AtomicReference<AsyncRequestConsumer<T>> requestConsumerRef = new AtomicReference<Object>(null);
    private final AtomicReference<AsyncResponseProducer> responseProducerRef = new AtomicReference<Object>(null);
    private volatile HttpContext context;
    private volatile boolean expectationFailed;

    protected AsyncResponseProducer verify(HttpRequest request, HttpContext context) throws IOException, HttpException {
        return null;
    }

    protected abstract AsyncRequestConsumer<T> supplyConsumer(HttpRequest var1, HttpContext var2) throws HttpException;

    protected abstract void handle(T var1, ResponseTrigger var2, HttpContext var3) throws HttpException, IOException;

    @Override
    public void setContext(HttpContext context) {
        this.context = context;
    }

    @Override
    public final void handleRequest(HttpRequest request, EntityDetails entityDetails, final ResponseChannel responseChannel) throws HttpException, IOException {
        Header h;
        AsyncRequestConsumer<T> requestConsumer = this.supplyConsumer(request, this.context);
        if (requestConsumer == null) {
            throw new HttpException("Unable to handle request");
        }
        this.requestConsumerRef.set(requestConsumer);
        if (entityDetails != null && (h = request.getFirstHeader("Expect")) != null && "100-continue".equalsIgnoreCase(h.getValue())) {
            AsyncResponseProducer producer = this.verify(request, this.context);
            if (producer != null) {
                this.expectationFailed = true;
                this.responseProducerRef.set(producer);
                responseChannel.sendResponse(producer.produceResponse(), producer.getEntityDetails());
                return;
            }
            responseChannel.sendInformation(new BasicHttpResponse(100));
        }
        final ResponseTrigger responseTrigger = new ResponseTrigger(){

            @Override
            public void submitResponse(AsyncResponseProducer producer) throws HttpException, IOException {
                if (AbstractServerExchangeHandler.this.responseProducerRef.compareAndSet(null, producer)) {
                    responseChannel.sendResponse(producer.produceResponse(), producer.getEntityDetails());
                }
            }

            @Override
            public void pushPromise(HttpRequest promise, AsyncPushProducer pushProducer) throws HttpException, IOException {
                responseChannel.pushPromise(promise, pushProducer);
            }

            public String toString() {
                return "Response trigger: " + responseChannel;
            }
        };
        requestConsumer.consumeRequest(request, entityDetails, new FutureCallback<T>(){

            @Override
            public void completed(T result) {
                try {
                    AbstractServerExchangeHandler.this.handle(result, responseTrigger, AbstractServerExchangeHandler.this.context);
                }
                catch (HttpException ex) {
                    try {
                        responseTrigger.submitResponse(new BasicResponseProducer(500, ex.getMessage()));
                    }
                    catch (IOException | HttpException ex2) {
                        this.failed(ex2);
                    }
                }
                catch (IOException ex) {
                    this.failed(ex);
                }
            }

            @Override
            public void failed(Exception ex) {
                AbstractServerExchangeHandler.this.failed(ex);
            }

            @Override
            public void cancelled() {
                AbstractServerExchangeHandler.this.releaseResources();
            }
        });
    }

    @Override
    public final void updateCapacity(CapacityChannel capacityChannel) throws IOException {
        if (!this.expectationFailed) {
            AsyncRequestConsumer<T> requestConsumer = this.requestConsumerRef.get();
            Asserts.notNull(requestConsumer, "Data consumer");
            requestConsumer.updateCapacity(capacityChannel);
        } else {
            capacityChannel.update(Integer.MAX_VALUE);
        }
    }

    @Override
    public final int consume(ByteBuffer src) throws IOException {
        if (!this.expectationFailed) {
            AsyncRequestConsumer<T> requestConsumer = this.requestConsumerRef.get();
            Asserts.notNull(requestConsumer, "Data consumer");
            return requestConsumer.consume(src);
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public final void streamEnd(List<? extends Header> trailers) throws HttpException, IOException {
        if (!this.expectationFailed) {
            AsyncRequestConsumer<T> requestConsumer = this.requestConsumerRef.get();
            Asserts.notNull(requestConsumer, "Data consumer");
            requestConsumer.streamEnd(trailers);
        }
    }

    @Override
    public final int available() {
        AsyncResponseProducer dataProducer = this.responseProducerRef.get();
        return dataProducer != null ? dataProducer.available() : 0;
    }

    @Override
    public final void produce(DataStreamChannel channel) throws IOException {
        AsyncResponseProducer dataProducer = this.responseProducerRef.get();
        Asserts.notNull(dataProducer, "Data producer");
        dataProducer.produce(channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void failed(Exception cause) {
        try {
            AsyncResponseProducer dataProducer;
            AsyncRequestConsumer<T> requestConsumer = this.requestConsumerRef.get();
            if (requestConsumer != null) {
                requestConsumer.failed(cause);
            }
            if ((dataProducer = this.responseProducerRef.get()) != null) {
                dataProducer.failed(cause);
            }
        }
        finally {
            this.releaseResources();
        }
    }

    @Override
    public final void releaseResources() {
        AsyncResponseProducer dataProducer;
        AsyncRequestConsumer requestConsumer = this.requestConsumerRef.getAndSet(null);
        if (requestConsumer != null) {
            requestConsumer.releaseResources();
        }
        if ((dataProducer = (AsyncResponseProducer)this.responseProducerRef.getAndSet(null)) != null) {
            dataProducer.releaseResources();
        }
    }
}

