/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.nio;

import java.io.IOException;
import java.net.URI;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.message.BasicHttpRequest;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.AsyncRequestProducer;
import org.apache.hc.core5.http.nio.DataStreamChannel;

public class BasicRequestProducer
implements AsyncRequestProducer {
    private final HttpRequest request;
    private final AsyncEntityProducer dataProducer;

    public BasicRequestProducer(HttpRequest request, AsyncEntityProducer dataProducer) {
        this.request = request;
        this.dataProducer = dataProducer;
    }

    public BasicRequestProducer(String method, HttpHost host, String path, AsyncEntityProducer dataProducer) {
        this(new BasicHttpRequest(method, host, path), dataProducer);
    }

    public BasicRequestProducer(String method, HttpHost host, String path) {
        this(method, host, path, null);
    }

    public BasicRequestProducer(String method, URI requestUri, AsyncEntityProducer dataProducer) {
        this(new BasicHttpRequest(method, requestUri), dataProducer);
    }

    public BasicRequestProducer(String method, URI requestUri) {
        this(method, requestUri, null);
    }

    @Override
    public HttpRequest produceRequest() {
        return this.request;
    }

    @Override
    public EntityDetails getEntityDetails() {
        return this.dataProducer;
    }

    @Override
    public int available() {
        return this.dataProducer != null ? this.dataProducer.available() : 0;
    }

    @Override
    public void produce(DataStreamChannel channel) throws IOException {
        if (this.dataProducer != null) {
            this.dataProducer.produce(channel);
        }
    }

    @Override
    public void failed(Exception cause) {
        this.releaseResources();
    }

    @Override
    public void releaseResources() {
        if (this.dataProducer != null) {
            this.dataProducer.releaseResources();
        }
    }
}

