/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.MethodNotSupportedException;
import org.apache.hc.core5.http.MisdirectedRequestException;
import org.apache.hc.core5.http.NotImplementedException;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.UnsupportedHttpVersionException;
import org.apache.hc.core5.http.impl.LazyEntityDetails;
import org.apache.hc.core5.http.impl.nio.Http1StreamChannel;
import org.apache.hc.core5.http.impl.nio.MessageState;
import org.apache.hc.core5.http.nio.AsyncPushProducer;
import org.apache.hc.core5.http.nio.AsyncResponseProducer;
import org.apache.hc.core5.http.nio.AsyncServerExchangeHandler;
import org.apache.hc.core5.http.nio.BasicResponseProducer;
import org.apache.hc.core5.http.nio.CapacityChannel;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.http.nio.HandlerFactory;
import org.apache.hc.core5.http.nio.HttpContextAware;
import org.apache.hc.core5.http.nio.ResourceHolder;
import org.apache.hc.core5.http.nio.ResponseChannel;
import org.apache.hc.core5.http.nio.support.ImmediateResponseExchangeHandler;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpCoreContext;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.util.Asserts;

class ServerHttp1StreamHandler
implements ResourceHolder {
    private final Http1StreamChannel<HttpResponse> outputChannel;
    private final DataStreamChannel internalDataChannel;
    private final HttpProcessor httpProcessor;
    private final HandlerFactory<AsyncServerExchangeHandler> exchangeHandlerFactory;
    private final ConnectionReuseStrategy connectionReuseStrategy;
    private final HttpCoreContext context;
    private final AtomicBoolean responseCommitted;
    private final AtomicBoolean done;
    private volatile boolean keepAlive;
    private volatile AsyncServerExchangeHandler exchangeHandler;
    private volatile HttpRequest receivedRequest;
    private volatile MessageState requestState;
    private volatile MessageState responseState;

    ServerHttp1StreamHandler(final Http1StreamChannel<HttpResponse> outputChannel, HttpProcessor httpProcessor, ConnectionReuseStrategy connectionReuseStrategy, HandlerFactory<AsyncServerExchangeHandler> exchangeHandlerFactory, HttpCoreContext context) {
        this.outputChannel = outputChannel;
        this.internalDataChannel = new DataStreamChannel(){

            @Override
            public void requestOutput() {
                outputChannel.requestOutput();
            }

            @Override
            public void endStream(List<? extends Header> trailers) throws IOException {
                outputChannel.complete(trailers);
                if (!ServerHttp1StreamHandler.this.keepAlive) {
                    outputChannel.close();
                }
                ServerHttp1StreamHandler.this.responseState = MessageState.COMPLETE;
            }

            @Override
            public int write(ByteBuffer src) throws IOException {
                return outputChannel.write(src);
            }

            @Override
            public void endStream() throws IOException {
                this.endStream(null);
            }
        };
        this.httpProcessor = httpProcessor;
        this.connectionReuseStrategy = connectionReuseStrategy;
        this.exchangeHandlerFactory = exchangeHandlerFactory;
        this.context = context;
        this.responseCommitted = new AtomicBoolean(false);
        this.done = new AtomicBoolean(false);
        this.keepAlive = true;
        this.requestState = MessageState.HEADERS;
        this.responseState = MessageState.IDLE;
    }

    private void validateResponse(HttpResponse response, EntityDetails responseEntityDetails) throws HttpException {
        int status = response.getCode();
        switch (status) {
            case 204: 
            case 304: {
                if (responseEntityDetails == null) break;
                throw new HttpException("Response " + status + " must not enclose an entity");
            }
        }
    }

    private void commitResponse(HttpResponse response, EntityDetails responseEntityDetails) throws HttpException, IOException {
        if (this.responseCommitted.compareAndSet(false, true)) {
            boolean endStream;
            ProtocolVersion transportVersion = response.getVersion();
            if (transportVersion != null && transportVersion.greaterEquals(HttpVersion.HTTP_2)) {
                throw new UnsupportedHttpVersionException("Unsupported version: " + transportVersion);
            }
            int status = response.getCode();
            if (status < 200) {
                throw new HttpException("Invalid response: " + status);
            }
            Asserts.notNull(this.receivedRequest, "Received request");
            String method = this.receivedRequest.getMethod();
            this.context.setAttribute("http.response", response);
            this.httpProcessor.process(response, responseEntityDetails, (HttpContext)this.context);
            boolean bl = endStream = responseEntityDetails == null || method.equalsIgnoreCase("HEAD");
            if (!this.connectionReuseStrategy.keepAlive(this.receivedRequest, response, this.context)) {
                this.keepAlive = false;
            }
            this.outputChannel.submit(response, endStream);
            if (endStream) {
                if (!this.keepAlive) {
                    this.outputChannel.close();
                }
                this.responseState = MessageState.COMPLETE;
            } else {
                this.responseState = MessageState.BODY;
                this.exchangeHandler.produce(this.internalDataChannel);
            }
        } else {
            throw new HttpException("Response already committed");
        }
    }

    private void commitInformation(HttpResponse response) throws IOException, HttpException {
        if (this.responseCommitted.get()) {
            throw new HttpException("Response already committed");
        }
        int status = response.getCode();
        if (status < 100 || status >= 200) {
            throw new HttpException("Invalid intermediate response: " + status);
        }
        this.outputChannel.submit(response, true);
    }

    private void commitPromise() throws HttpException {
        throw new HttpException("HTTP/1.1 does not support server push");
    }

    void activateChannel() throws IOException, HttpException {
        this.outputChannel.activate();
    }

    boolean isResponseFinal() {
        return this.responseState == MessageState.COMPLETE;
    }

    boolean isCompleted() {
        return this.requestState == MessageState.COMPLETE && this.responseState == MessageState.COMPLETE;
    }

    AsyncResponseProducer handleException(Exception ex) {
        int code = ex instanceof MethodNotSupportedException ? 501 : (ex instanceof UnsupportedHttpVersionException ? 505 : (ex instanceof NotImplementedException ? 501 : (ex instanceof ProtocolException ? 400 : 500)));
        String message = ex.getMessage();
        if (message == null) {
            message = ex.toString();
        }
        return new BasicResponseProducer(code, message);
    }

    void consumeHeader(HttpRequest request, boolean requestEndStream) throws HttpException, IOException {
        AsyncServerExchangeHandler handler;
        if (this.done.get() || this.requestState != MessageState.HEADERS) {
            throw new ProtocolException("Unexpected message head");
        }
        this.receivedRequest = request;
        this.requestState = requestEndStream ? MessageState.COMPLETE : MessageState.BODY;
        try {
            handler = this.exchangeHandlerFactory.create(request);
        }
        catch (MisdirectedRequestException ex) {
            handler = new ImmediateResponseExchangeHandler(421, ex.getMessage());
        }
        catch (HttpException ex) {
            handler = new ImmediateResponseExchangeHandler(500, ex.getMessage());
        }
        if (handler == null) {
            handler = new ImmediateResponseExchangeHandler(404, "Cannot handle request");
        }
        this.exchangeHandler = handler;
        ProtocolVersion transportVersion = request.getVersion();
        if (transportVersion != null && transportVersion.greaterEquals(HttpVersion.HTTP_2)) {
            throw new UnsupportedHttpVersionException("Unsupported version: " + transportVersion);
        }
        this.context.setProtocolVersion(transportVersion);
        this.context.setAttribute("http.request", request);
        if (this.exchangeHandler instanceof HttpContextAware) {
            ((HttpContextAware)((Object)this.exchangeHandler)).setContext(this.context);
        }
        LazyEntityDetails requestEntityDetails = requestEndStream ? null : new LazyEntityDetails(request);
        ResponseChannel responseChannel = new ResponseChannel(){

            @Override
            public void sendInformation(HttpResponse response) throws HttpException, IOException {
                ServerHttp1StreamHandler.this.commitInformation(response);
            }

            @Override
            public void sendResponse(HttpResponse response, EntityDetails responseEntityDetails) throws HttpException, IOException {
                ServerHttp1StreamHandler.this.validateResponse(response, responseEntityDetails);
                ServerHttp1StreamHandler.this.commitResponse(response, responseEntityDetails);
            }

            @Override
            public void pushPromise(HttpRequest promise, AsyncPushProducer pushProducer) throws HttpException, IOException {
                ServerHttp1StreamHandler.this.commitPromise();
            }
        };
        try {
            this.httpProcessor.process(request, (EntityDetails)requestEntityDetails, (HttpContext)this.context);
            this.exchangeHandler.handleRequest(request, requestEntityDetails, responseChannel);
        }
        catch (HttpException ex) {
            if (!this.responseCommitted.get()) {
                AsyncResponseProducer responseProducer = this.handleException(ex);
                this.exchangeHandler = new ImmediateResponseExchangeHandler(responseProducer);
                this.exchangeHandler.handleRequest(request, requestEntityDetails, responseChannel);
            }
            throw ex;
        }
    }

    boolean isOutputReady() {
        switch (this.responseState) {
            case BODY: {
                return this.exchangeHandler.available() > 0;
            }
        }
        return false;
    }

    void produceOutput() throws HttpException, IOException {
        switch (this.responseState) {
            case BODY: {
                this.exchangeHandler.produce(this.internalDataChannel);
            }
        }
    }

    int consumeData(ByteBuffer src) throws HttpException, IOException {
        if (this.done.get() || this.requestState != MessageState.BODY) {
            throw new ProtocolException("Unexpected message data");
        }
        if (this.responseState == MessageState.ACK) {
            this.outputChannel.requestOutput();
        }
        return this.exchangeHandler.consume(src);
    }

    void updateCapacity(CapacityChannel capacityChannel) throws IOException {
        this.exchangeHandler.updateCapacity(capacityChannel);
    }

    void dataEnd(List<? extends Header> trailers) throws HttpException, IOException {
        if (this.done.get() || this.requestState != MessageState.BODY) {
            throw new ProtocolException("Unexpected message data");
        }
        this.requestState = MessageState.COMPLETE;
        this.exchangeHandler.streamEnd(trailers);
    }

    void failed(Exception cause) {
        this.exchangeHandler.failed(cause);
    }

    @Override
    public void releaseResources() {
        if (this.done.compareAndSet(false, true)) {
            this.requestState = MessageState.COMPLETE;
            this.responseState = MessageState.COMPLETE;
            this.exchangeHandler.releaseResources();
        }
    }

    public String toString() {
        return "[requestState=" + (Object)((Object)this.requestState) + ", responseState=" + (Object)((Object)this.responseState) + ']';
    }
}

