/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.nio;

import java.io.IOException;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.hc.core5.http.EndpointDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpMessage;
import org.apache.hc.core5.http.Message;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.config.H1Config;
import org.apache.hc.core5.http.impl.BasicEndpointDetails;
import org.apache.hc.core5.http.impl.BasicHttpConnectionMetrics;
import org.apache.hc.core5.http.impl.BasicHttpTransportMetrics;
import org.apache.hc.core5.http.impl.CharCodingSupport;
import org.apache.hc.core5.http.impl.ConnectionListener;
import org.apache.hc.core5.http.impl.nio.ChunkEncoder;
import org.apache.hc.core5.http.impl.nio.SessionInputBufferImpl;
import org.apache.hc.core5.http.impl.nio.SessionOutputBufferImpl;
import org.apache.hc.core5.http.impl.nio.UpgradeableHttpConnection;
import org.apache.hc.core5.http.nio.AsyncClientExchangeHandler;
import org.apache.hc.core5.http.nio.CapacityChannel;
import org.apache.hc.core5.http.nio.ContentDecoder;
import org.apache.hc.core5.http.nio.ContentEncoder;
import org.apache.hc.core5.http.nio.NHttpMessageParser;
import org.apache.hc.core5.http.nio.NHttpMessageWriter;
import org.apache.hc.core5.http.nio.ResourceHolder;
import org.apache.hc.core5.http.nio.SessionInputBuffer;
import org.apache.hc.core5.http.nio.SessionOutputBuffer;
import org.apache.hc.core5.http.nio.command.ExecutionCommand;
import org.apache.hc.core5.http.nio.command.ShutdownCommand;
import org.apache.hc.core5.io.ShutdownType;
import org.apache.hc.core5.net.InetAddressUtils;
import org.apache.hc.core5.reactor.Command;
import org.apache.hc.core5.reactor.IOEventHandler;
import org.apache.hc.core5.reactor.TlsCapableIOSession;
import org.apache.hc.core5.reactor.ssl.SSLBufferManagement;
import org.apache.hc.core5.reactor.ssl.SSLSessionInitializer;
import org.apache.hc.core5.reactor.ssl.SSLSessionVerifier;
import org.apache.hc.core5.reactor.ssl.TlsDetails;
import org.apache.hc.core5.util.Args;

abstract class AbstractHttp1StreamDuplexer<IncomingMessage extends HttpMessage, OutgoingMessage extends HttpMessage>
implements ResourceHolder,
UpgradeableHttpConnection {
    private final TlsCapableIOSession ioSession;
    private final H1Config h1Config;
    private final SessionInputBufferImpl inbuf;
    private final SessionOutputBufferImpl outbuf;
    private final BasicHttpTransportMetrics inTransportMetrics;
    private final BasicHttpTransportMetrics outTransportMetrics;
    private final BasicHttpConnectionMetrics connMetrics;
    private final NHttpMessageParser<IncomingMessage> incomingMessageParser;
    private final NHttpMessageWriter<OutgoingMessage> outgoingMessageWriter;
    private final ByteBuffer contentBuffer;
    private final ConnectionListener connectionListener;
    private final Lock outputLock;
    private final AtomicInteger outputRequests;
    private volatile Message<IncomingMessage, ContentDecoder> incomingMessage;
    private volatile Message<OutgoingMessage, ContentEncoder> outgoingMessage;
    private volatile ConnectionState connState = ConnectionState.READY;
    private volatile ProtocolVersion version;
    private volatile EndpointDetails endpointDetails;

    AbstractHttp1StreamDuplexer(TlsCapableIOSession ioSession, H1Config h1Config, CharCodingConfig charCodingConfig, NHttpMessageParser<IncomingMessage> incomingMessageParser, NHttpMessageWriter<OutgoingMessage> outgoingMessageWriter, ConnectionListener connectionListener) {
        this.ioSession = Args.notNull(ioSession, "I/O session");
        this.h1Config = h1Config != null ? h1Config : H1Config.DEFAULT;
        int bufferSize = this.h1Config.getBufferSize();
        this.inbuf = new SessionInputBufferImpl(bufferSize, bufferSize < 512 ? bufferSize : 512, this.h1Config.getMaxLineLength(), CharCodingSupport.createDecoder(charCodingConfig));
        this.outbuf = new SessionOutputBufferImpl(bufferSize, bufferSize < 512 ? bufferSize : 512, CharCodingSupport.createEncoder(charCodingConfig));
        this.inTransportMetrics = new BasicHttpTransportMetrics();
        this.outTransportMetrics = new BasicHttpTransportMetrics();
        this.connMetrics = new BasicHttpConnectionMetrics(this.inTransportMetrics, this.outTransportMetrics);
        this.incomingMessageParser = incomingMessageParser;
        this.outgoingMessageWriter = outgoingMessageWriter;
        this.contentBuffer = ByteBuffer.allocate(this.h1Config.getBufferSize());
        this.connectionListener = connectionListener;
        this.outputLock = new ReentrantLock();
        this.outputRequests = new AtomicInteger(0);
        this.connState = ConnectionState.READY;
    }

    void shutdownSession(ShutdownType shutdownType) {
        if (shutdownType == ShutdownType.GRACEFUL) {
            this.connState = ConnectionState.GRACEFUL_SHUTDOWN;
            this.ioSession.addLast(new ShutdownCommand(ShutdownType.GRACEFUL));
        } else {
            this.connState = ConnectionState.SHUTDOWN;
            this.ioSession.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdownSession(Exception exception) throws IOException {
        this.connState = ConnectionState.SHUTDOWN;
        try {
            this.terminate(exception);
        }
        finally {
            this.ioSession.close();
        }
    }

    abstract void disconnected();

    abstract void terminate(Exception var1);

    abstract void updateInputMetrics(IncomingMessage var1, BasicHttpConnectionMetrics var2);

    abstract void updateOutputMetrics(OutgoingMessage var1, BasicHttpConnectionMetrics var2);

    abstract void consumeHeader(IncomingMessage var1, boolean var2) throws HttpException, IOException;

    abstract ContentDecoder handleIncomingMessage(IncomingMessage var1, ReadableByteChannel var2, SessionInputBuffer var3, BasicHttpTransportMetrics var4) throws HttpException;

    abstract ContentEncoder handleOutgoingMessage(OutgoingMessage var1, WritableByteChannel var2, SessionOutputBuffer var3, BasicHttpTransportMetrics var4) throws HttpException;

    abstract int consumeData(ByteBuffer var1) throws HttpException, IOException;

    abstract void updateCapacity(CapacityChannel var1) throws HttpException, IOException;

    abstract void dataEnd(List<? extends Header> var1) throws HttpException, IOException;

    abstract boolean isOutputReady();

    abstract void produceOutput() throws HttpException, IOException;

    abstract void execute(ExecutionCommand var1) throws HttpException, IOException;

    abstract void inputEnd() throws HttpException, IOException;

    abstract void outputEnd() throws HttpException, IOException;

    abstract boolean inputIdle();

    abstract boolean outputIdle();

    abstract boolean handleTimeout();

    private void processCommands() throws HttpException, IOException {
        Command command;
        block3: {
            while (true) {
                if ((command = this.ioSession.getCommand()) == null) {
                    return;
                }
                if (command instanceof ShutdownCommand) {
                    ShutdownCommand shutdownCommand = (ShutdownCommand)command;
                    this.requestShutdown(shutdownCommand.getType());
                    continue;
                }
                if (!(command instanceof ExecutionCommand)) break block3;
                if (this.connState.compareTo(ConnectionState.GRACEFUL_SHUTDOWN) < 0) break;
                command.cancel();
            }
            this.execute((ExecutionCommand)command);
            return;
        }
        throw new HttpException("Unexpected command: " + command.getClass());
    }

    public final void onConnect(ByteBuffer prefeed) throws HttpException, IOException {
        if (this.connectionListener != null) {
            this.connectionListener.onConnect(this);
        }
        if (prefeed != null) {
            this.inbuf.put(prefeed);
        }
        this.connState = ConnectionState.ACTIVE;
        this.processCommands();
    }

    public final void onInput() throws HttpException, IOException {
        while (this.connState.compareTo(ConnectionState.SHUTDOWN) < 0) {
            int totalBytesRead = 0;
            int messagesReceived = 0;
            if (this.incomingMessage == null) {
                int bytesRead;
                if (this.connState.compareTo(ConnectionState.GRACEFUL_SHUTDOWN) >= 0 && this.inputIdle()) {
                    this.ioSession.clearEvent(1);
                    return;
                }
                do {
                    HttpMessage messageHead;
                    if ((bytesRead = this.inbuf.fill(this.ioSession.channel())) > 0) {
                        totalBytesRead += bytesRead;
                        this.inTransportMetrics.incrementBytesTransferred(bytesRead);
                    }
                    if ((messageHead = (HttpMessage)this.incomingMessageParser.parse(this.inbuf, bytesRead == -1)) == null) continue;
                    ++messagesReceived;
                    this.incomingMessageParser.reset();
                    this.version = messageHead.getVersion();
                    this.updateInputMetrics(messageHead, this.connMetrics);
                    ContentDecoder contentDecoder = this.handleIncomingMessage(messageHead, this.ioSession.channel(), this.inbuf, this.inTransportMetrics);
                    this.consumeHeader(messageHead, contentDecoder == null);
                    if (contentDecoder != null) {
                        this.incomingMessage = new Message<HttpMessage, ContentDecoder>(messageHead, contentDecoder);
                        break;
                    }
                    this.inputEnd();
                    if (this.connState.compareTo(ConnectionState.ACTIVE) != 0) break;
                    this.ioSession.setEvent(1);
                } while (bytesRead > 0);
                if (bytesRead == -1 && !this.inbuf.hasData()) {
                    if (this.outputIdle() && this.inputIdle()) {
                        this.requestShutdown(ShutdownType.IMMEDIATE);
                    } else {
                        this.shutdownSession(new ConnectionClosedException("Connection closed by peer"));
                    }
                    return;
                }
            }
            if (this.incomingMessage != null) {
                int bytesRead;
                ContentDecoder contentDecoder = this.incomingMessage.getBody();
                while ((bytesRead = contentDecoder.read(this.contentBuffer)) > 0) {
                    if (bytesRead > 0) {
                        totalBytesRead += bytesRead;
                    }
                    this.contentBuffer.flip();
                    int capacity = this.consumeData(this.contentBuffer);
                    this.contentBuffer.clear();
                    if (capacity > 0) continue;
                    if (contentDecoder.isCompleted()) break;
                    this.ioSession.clearEvent(1);
                    this.updateCapacity(new CapacityChannel(){

                        @Override
                        public void update(int increment) throws IOException {
                            if (increment > 0) {
                                AbstractHttp1StreamDuplexer.this.requestSessionInput();
                            }
                        }
                    });
                    break;
                }
                if (contentDecoder.isCompleted()) {
                    this.dataEnd(contentDecoder.getTrailers());
                    this.incomingMessage = null;
                    this.ioSession.setEvent(1);
                    this.inputEnd();
                }
            }
            if (totalBytesRead != 0 || messagesReceived != 0) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onOutput() throws IOException, HttpException {
        this.outputLock.lock();
        try {
            int bytesWritten;
            if (this.outbuf.hasData() && (bytesWritten = this.outbuf.flush(this.ioSession.channel())) > 0) {
                this.outTransportMetrics.incrementBytesTransferred(bytesWritten);
            }
        }
        finally {
            this.outputLock.unlock();
        }
        if (this.connState.compareTo(ConnectionState.SHUTDOWN) < 0) {
            boolean outputEnd;
            if (this.isOutputReady()) {
                this.produceOutput();
            } else {
                boolean outputPending;
                int pendingOutputRequests = this.outputRequests.get();
                this.outputLock.lock();
                try {
                    outputPending = this.outbuf.hasData();
                }
                finally {
                    this.outputLock.unlock();
                }
                if (!outputPending && this.outputRequests.compareAndSet(pendingOutputRequests, 0)) {
                    this.ioSession.clearEvent(4);
                } else {
                    this.outputRequests.addAndGet(-pendingOutputRequests);
                }
            }
            this.outputLock.lock();
            try {
                outputEnd = this.outgoingMessage == null && !this.outbuf.hasData();
            }
            finally {
                this.outputLock.unlock();
            }
            if (outputEnd) {
                this.outputEnd();
                if (this.connState.compareTo(ConnectionState.ACTIVE) == 0) {
                    this.processCommands();
                } else if (this.connState.compareTo(ConnectionState.GRACEFUL_SHUTDOWN) >= 0 && this.inputIdle() && this.outputIdle()) {
                    this.connState = ConnectionState.SHUTDOWN;
                }
            }
        }
        if (this.connState.compareTo(ConnectionState.SHUTDOWN) >= 0) {
            this.ioSession.close();
            this.releaseResources();
        }
    }

    public final void onTimeout() throws IOException, HttpException {
        if (!this.handleTimeout()) {
            this.onException(new SocketTimeoutException());
        }
    }

    public final void onException(Exception ex) {
        block5: {
            if (this.connectionListener != null) {
                this.connectionListener.onError(this, ex);
            }
            try {
                Command command;
                this.shutdownSession(ex);
                while ((command = this.ioSession.getCommand()) != null) {
                    if (command instanceof ExecutionCommand) {
                        AsyncClientExchangeHandler exchangeHandler = ((ExecutionCommand)command).getExchangeHandler();
                        exchangeHandler.failed(ex);
                        exchangeHandler.releaseResources();
                        continue;
                    }
                    command.cancel();
                }
            }
            catch (IOException ex2) {
                if (this.connectionListener == null) break block5;
                this.connectionListener.onError(this, ex2);
            }
        }
    }

    public final void onDisconnect() {
        Command command;
        this.disconnected();
        while ((command = this.ioSession.getCommand()) != null) {
            command.cancel();
        }
        this.releaseResources();
        if (this.connectionListener != null) {
            this.connectionListener.onDisconnect(this);
        }
    }

    void requestShutdown(ShutdownType shutdownType) {
        switch (shutdownType) {
            case GRACEFUL: {
                if (this.connState != ConnectionState.ACTIVE) break;
                this.connState = ConnectionState.GRACEFUL_SHUTDOWN;
                break;
            }
            case IMMEDIATE: {
                this.connState = ConnectionState.SHUTDOWN;
            }
        }
        this.ioSession.setEvent(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void commitMessageHead(OutgoingMessage messageHead, boolean endStream) throws HttpException, IOException {
        this.outputLock.lock();
        try {
            ContentEncoder contentEncoder;
            this.outgoingMessageWriter.write(messageHead, this.outbuf);
            this.updateOutputMetrics(messageHead, this.connMetrics);
            if (!endStream && (contentEncoder = this.handleOutgoingMessage(messageHead, this.ioSession.channel(), this.outbuf, this.outTransportMetrics)) != null) {
                this.outgoingMessage = new Message<OutgoingMessage, ContentEncoder>(messageHead, contentEncoder);
            }
            this.outgoingMessageWriter.reset();
            this.ioSession.setEvent(4);
        }
        finally {
            this.outputLock.unlock();
        }
    }

    void requestSessionInput() {
        this.ioSession.setEvent(1);
    }

    void suspendSessionInput() {
        this.ioSession.clearEvent(1);
    }

    void requestSessionOutput() {
        this.outputRequests.incrementAndGet();
        this.ioSession.setEvent(4);
    }

    int getSessionTimeout() {
        return this.ioSession.getSocketTimeout();
    }

    void setSessionTimeout(int timeout) {
        this.ioSession.setSocketTimeout(timeout);
    }

    void suspendSessionOutput() {
        this.ioSession.clearEvent(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int streamOutput(ByteBuffer src) throws IOException {
        this.outputLock.lock();
        try {
            if (this.outgoingMessage == null) {
                throw new ClosedChannelException();
            }
            ContentEncoder contentEncoder = this.outgoingMessage.getBody();
            int bytesWritten = contentEncoder.write(src);
            if (bytesWritten > 0) {
                this.ioSession.setEvent(4);
            }
            int n = bytesWritten;
            return n;
        }
        finally {
            this.outputLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MessageDelineation endOutputStream(List<? extends Header> trailers) throws IOException {
        this.outputLock.lock();
        try {
            if (this.outgoingMessage == null) {
                MessageDelineation messageDelineation = MessageDelineation.NONE;
                return messageDelineation;
            }
            ContentEncoder contentEncoder = this.outgoingMessage.getBody();
            contentEncoder.complete(trailers);
            this.ioSession.setEvent(4);
            this.outgoingMessage = null;
            if (contentEncoder instanceof ChunkEncoder) {
                MessageDelineation messageDelineation = MessageDelineation.CHUNK_CODED;
                return messageDelineation;
            }
            MessageDelineation messageDelineation = MessageDelineation.MESSAGE_HEAD;
            return messageDelineation;
        }
        finally {
            this.outputLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isOutputCompleted() {
        this.outputLock.lock();
        try {
            if (this.outgoingMessage == null) {
                boolean bl = true;
                return bl;
            }
            ContentEncoder contentEncoder = this.outgoingMessage.getBody();
            boolean bl = contentEncoder.isCompleted();
            return bl;
        }
        finally {
            this.outputLock.unlock();
        }
    }

    @Override
    public void close() throws IOException {
        this.ioSession.addFirst(new ShutdownCommand(ShutdownType.GRACEFUL));
    }

    @Override
    public void shutdown(ShutdownType shutdownType) {
        this.ioSession.addFirst(new ShutdownCommand(shutdownType));
    }

    @Override
    public boolean isOpen() {
        return this.connState == ConnectionState.ACTIVE;
    }

    @Override
    public void setSocketTimeout(int timeout) {
        this.ioSession.setSocketTimeout(timeout);
    }

    @Override
    public EndpointDetails getEndpointDetails() {
        if (this.endpointDetails == null) {
            this.endpointDetails = new BasicEndpointDetails(this.ioSession.getRemoteAddress(), this.ioSession.getLocalAddress(), this.connMetrics);
        }
        return this.endpointDetails;
    }

    @Override
    public int getSocketTimeout() {
        return this.ioSession.getSocketTimeout();
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return this.version;
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.ioSession.getRemoteAddress();
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.ioSession.getLocalAddress();
    }

    @Override
    public SSLSession getSSLSession() {
        TlsDetails tlsDetails = this.ioSession.getTlsDetails();
        return tlsDetails != null ? tlsDetails.getSSLSession() : null;
    }

    @Override
    public TlsDetails getTlsDetails() {
        return this.ioSession.getTlsDetails();
    }

    @Override
    public void startTls(SSLContext sslContext, SSLBufferManagement sslBufferManagement, SSLSessionInitializer initializer, SSLSessionVerifier verifier) throws UnsupportedOperationException {
        this.ioSession.startTls(sslContext, sslBufferManagement, initializer, verifier);
    }

    @Override
    public void upgrade(IOEventHandler eventHandler) {
        this.ioSession.setHandler(eventHandler);
    }

    public String toString() {
        SocketAddress remoteAddress = this.ioSession.getRemoteAddress();
        SocketAddress localAddress = this.ioSession.getLocalAddress();
        StringBuilder buffer = new StringBuilder();
        InetAddressUtils.formatAddress(buffer, localAddress);
        buffer.append("->");
        InetAddressUtils.formatAddress(buffer, remoteAddress);
        return buffer.toString();
    }

    static enum MessageDelineation {
        NONE,
        CHUNK_CODED,
        MESSAGE_HEAD;

    }

    private static enum ConnectionState {
        READY,
        ACTIVE,
        GRACEFUL_SHUTDOWN,
        SHUTDOWN;

    }
}

