/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpResponseFactory;
import org.apache.hc.core5.http.MethodNotSupportedException;
import org.apache.hc.core5.http.NotImplementedException;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.UnsupportedHttpVersionException;
import org.apache.hc.core5.http.impl.DefaultConnectionReuseStrategy;
import org.apache.hc.core5.http.impl.Http1StreamListener;
import org.apache.hc.core5.http.impl.io.DefaultClassicHttpResponseFactory;
import org.apache.hc.core5.http.io.HttpExpectationVerifier;
import org.apache.hc.core5.http.io.HttpRequestHandler;
import org.apache.hc.core5.http.io.HttpRequestHandlerMapper;
import org.apache.hc.core5.http.io.HttpServerConnection;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class HttpService {
    private final HttpProcessor processor;
    private final HttpRequestHandlerMapper handlerMapper;
    private final ConnectionReuseStrategy connReuseStrategy;
    private final HttpResponseFactory<ClassicHttpResponse> responseFactory;
    private final HttpExpectationVerifier expectationVerifier;
    private final Http1StreamListener streamListener;

    public HttpService(HttpProcessor processor, ConnectionReuseStrategy connReuseStrategy, HttpResponseFactory<ClassicHttpResponse> responseFactory, HttpRequestHandlerMapper handlerMapper, HttpExpectationVerifier expectationVerifier, Http1StreamListener streamListener) {
        this.processor = Args.notNull(processor, "HTTP processor");
        this.connReuseStrategy = connReuseStrategy != null ? connReuseStrategy : DefaultConnectionReuseStrategy.INSTANCE;
        this.responseFactory = responseFactory != null ? responseFactory : DefaultClassicHttpResponseFactory.INSTANCE;
        this.handlerMapper = handlerMapper;
        this.expectationVerifier = expectationVerifier;
        this.streamListener = streamListener;
    }

    public HttpService(HttpProcessor processor, ConnectionReuseStrategy connReuseStrategy, HttpResponseFactory<ClassicHttpResponse> responseFactory, HttpRequestHandlerMapper handlerMapper) {
        this(processor, connReuseStrategy, responseFactory, handlerMapper, null, null);
    }

    public HttpService(HttpProcessor processor, HttpRequestHandlerMapper handlerMapper) {
        this(processor, null, null, handlerMapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(HttpServerConnection conn, HttpContext context) throws IOException, HttpException {
        ClassicHttpRequest request = conn.receiveRequestHeader();
        if (this.streamListener != null) {
            this.streamListener.onRequestHead(conn, request);
        }
        try (Closeable response = null;){
            InputStream instream;
            try {
                boolean expectContinue;
                conn.receiveRequestEntity(request);
                ProtocolVersion transportVersion = request.getVersion();
                if (transportVersion != null) {
                    context.setProtocolVersion(transportVersion);
                }
                context.setAttribute("http.ssl-ession", conn.getSSLSession());
                context.setAttribute("http.connection-endpoint", conn.getEndpointDetails());
                context.setAttribute("http.request", request);
                this.processor.process(request, (EntityDetails)request.getEntity(), context);
                Header expect = request.getFirstHeader("Expect");
                boolean bl = expectContinue = expect != null && "100-continue".equalsIgnoreCase(expect.getValue());
                if (expectContinue) {
                    ClassicHttpResponse ack = this.responseFactory.newHttpResponse(100);
                    if (this.expectationVerifier != null) {
                        this.expectationVerifier.verify(request, ack, context);
                    }
                    if (ack.getCode() < 200) {
                        conn.sendResponseHeader(ack);
                        if (this.streamListener != null) {
                            this.streamListener.onResponseHead(conn, ack);
                        }
                        conn.flush();
                    } else {
                        response = ack;
                    }
                }
                if (response == null) {
                    response = this.responseFactory.newHttpResponse(200);
                    this.doService(request, (ClassicHttpResponse)response, context);
                }
            }
            catch (HttpException ex) {
                if (response != null) {
                    response.close();
                }
                response = this.responseFactory.newHttpResponse(500);
                this.handleException(ex, (ClassicHttpResponse)response);
            }
            context.setAttribute("http.response", response);
            this.processor.process((HttpResponse)((Object)response), (EntityDetails)response.getEntity(), context);
            conn.sendResponseHeader((ClassicHttpResponse)response);
            if (this.streamListener != null) {
                this.streamListener.onResponseHead(conn, (HttpResponse)((Object)response));
            }
            if (this.canResponseHaveBody(request, (ClassicHttpResponse)response)) {
                conn.sendResponseEntity((ClassicHttpResponse)response);
            }
            conn.flush();
            HttpEntity entity = request.getEntity();
            if (entity != null && entity.isStreaming() && (instream = entity.getContent()) != null) {
                instream.close();
            }
            boolean keepAlive = this.connReuseStrategy.keepAlive(request, (HttpResponse)((Object)response), context);
            if (this.streamListener != null) {
                this.streamListener.onExchangeComplete(conn, keepAlive);
            }
            if (!keepAlive) {
                conn.close();
            }
        }
    }

    private boolean canResponseHaveBody(ClassicHttpRequest request, ClassicHttpResponse response) {
        if (request != null && "HEAD".equalsIgnoreCase(request.getMethod())) {
            return false;
        }
        int status = response.getCode();
        return status >= 200 && status != 204 && status != 304;
    }

    protected void handleException(HttpException ex, ClassicHttpResponse response) {
        if (ex instanceof MethodNotSupportedException) {
            response.setCode(501);
        } else if (ex instanceof UnsupportedHttpVersionException) {
            response.setCode(505);
        } else if (ex instanceof NotImplementedException) {
            response.setCode(501);
        } else if (ex instanceof ProtocolException) {
            response.setCode(400);
        } else {
            response.setCode(500);
        }
        String message = ex.getMessage();
        if (message == null) {
            message = ex.toString();
        }
        StringEntity entity = new StringEntity(message, ContentType.TEXT_PLAIN);
        response.setEntity(entity);
    }

    protected void doService(ClassicHttpRequest request, ClassicHttpResponse response, HttpContext context) throws HttpException, IOException {
        HttpRequestHandler handler = null;
        if (this.handlerMapper != null) {
            handler = this.handlerMapper.lookup(request, context);
        }
        if (handler != null) {
            handler.handle(request, response, context);
        } else {
            response.setCode(501);
        }
    }
}

