/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.io;

import java.io.IOException;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.impl.DefaultConnectionReuseStrategy;
import org.apache.hc.core5.http.impl.Http1StreamListener;
import org.apache.hc.core5.http.io.HttpClientConnection;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class HttpRequestExecutor {
    public static final int DEFAULT_WAIT_FOR_CONTINUE = 3000;
    private final int waitForContinue;
    private final ConnectionReuseStrategy connReuseStrategy;
    private final Http1StreamListener streamListener;

    public HttpRequestExecutor(int waitForContinue, ConnectionReuseStrategy connReuseStrategy, Http1StreamListener streamListener) {
        this.waitForContinue = Args.positive(waitForContinue, "Wait for continue time");
        this.connReuseStrategy = connReuseStrategy != null ? connReuseStrategy : DefaultConnectionReuseStrategy.INSTANCE;
        this.streamListener = streamListener;
    }

    public HttpRequestExecutor(ConnectionReuseStrategy connReuseStrategy) {
        this(3000, connReuseStrategy, null);
    }

    public HttpRequestExecutor() {
        this(3000, null, null);
    }

    protected boolean canResponseHaveBody(ClassicHttpRequest request, ClassicHttpResponse response) {
        if ("HEAD".equalsIgnoreCase(request.getMethod())) {
            return false;
        }
        int status = response.getCode();
        return status >= 200 && status != 204 && status != 304;
    }

    public ClassicHttpResponse execute(ClassicHttpRequest request, HttpClientConnection conn, HttpContext context) throws IOException, HttpException {
        Args.notNull(request, "HTTP request");
        Args.notNull(conn, "Client connection");
        Args.notNull(context, "HTTP context");
        try {
            HttpEntity entity;
            HttpResponse response = null;
            context.setAttribute("http.ssl-ession", conn.getSSLSession());
            context.setAttribute("http.connection-endpoint", conn.getEndpointDetails());
            conn.sendRequestHeader(request);
            if (this.streamListener != null) {
                this.streamListener.onRequestHead(conn, request);
            }
            if ((entity = request.getEntity()) != null) {
                boolean expectContinue;
                Header expect = request.getFirstHeader("Expect");
                boolean bl = expectContinue = expect != null && "100-continue".equalsIgnoreCase(expect.getValue());
                if (expectContinue) {
                    conn.flush();
                    if (conn.isDataAvailable(this.waitForContinue)) {
                        int status;
                        response = conn.receiveResponseHeader();
                        if (this.streamListener != null) {
                            this.streamListener.onResponseHead(conn, response);
                        }
                        if ((status = response.getCode()) < 200) {
                            if (status != 100) {
                                throw new ProtocolException("Unexpected response: " + response.getCode());
                            }
                            response = null;
                            conn.sendRequestEntity(request);
                        } else {
                            if (this.canResponseHaveBody(request, (ClassicHttpResponse)response)) {
                                conn.receiveResponseEntity((ClassicHttpResponse)response);
                            }
                            conn.terminateRequest(request);
                        }
                    } else {
                        conn.sendRequestEntity(request);
                    }
                } else {
                    conn.sendRequestEntity(request);
                }
            }
            conn.flush();
            while (response == null || response.getCode() < 200) {
                response = conn.receiveResponseHeader();
                if (this.streamListener != null) {
                    this.streamListener.onResponseHead(conn, response);
                }
                if (!this.canResponseHaveBody(request, (ClassicHttpResponse)response)) continue;
                conn.receiveResponseEntity((ClassicHttpResponse)response);
            }
            return response;
        }
        catch (IOException | RuntimeException | HttpException ex) {
            HttpRequestExecutor.closeConnection(conn);
            throw ex;
        }
    }

    private static void closeConnection(HttpClientConnection conn) {
        try {
            conn.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void preProcess(ClassicHttpRequest request, HttpProcessor processor, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        Args.notNull(processor, "HTTP processor");
        Args.notNull(context, "HTTP context");
        context.setAttribute("http.request", request);
        processor.process(request, (EntityDetails)request.getEntity(), context);
    }

    public void postProcess(ClassicHttpResponse response, HttpProcessor processor, HttpContext context) throws HttpException, IOException {
        Args.notNull(response, "HTTP response");
        Args.notNull(processor, "HTTP processor");
        Args.notNull(context, "HTTP context");
        ProtocolVersion transportVersion = response.getVersion();
        if (transportVersion != null) {
            context.setProtocolVersion(transportVersion);
        }
        context.setAttribute("http.response", response);
        processor.process(response, (EntityDetails)response.getEntity(), context);
    }

    public boolean keepAlive(ClassicHttpRequest request, ClassicHttpResponse response, HttpClientConnection connection, HttpContext context) throws IOException {
        boolean keepAlive;
        Args.notNull(connection, "HTTP connection");
        Args.notNull(request, "HTTP request");
        Args.notNull(response, "HTTP response");
        Args.notNull(context, "HTTP context");
        boolean bl = keepAlive = connection.isConsistent() && this.connReuseStrategy.keepAlive(request, response, context);
        if (this.streamListener != null) {
            this.streamListener.onExchangeComplete(connection, keepAlive);
        }
        return keepAlive;
    }
}

