/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.bootstrap;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.core5.http.ExceptionListener;
import org.apache.hc.core5.io.GracefullyCloseable;
import org.apache.hc.core5.io.ShutdownType;
import org.apache.hc.core5.reactor.AbstractMultiworkerIOReactor;
import org.apache.hc.core5.reactor.ExceptionEvent;
import org.apache.hc.core5.reactor.IOReactorStatus;
import org.apache.hc.core5.util.TimeValue;

abstract class IOReactorExecutor<T extends AbstractMultiworkerIOReactor>
implements GracefullyCloseable {
    private final T ioReactor;
    private final ExceptionListener exceptionListener;
    private final ExecutorService executorService;
    private final AtomicReference<Status> status;

    IOReactorExecutor(T ioReactor, ExceptionListener exceptionListener, ThreadFactory threadFactory) {
        this.ioReactor = ioReactor;
        this.exceptionListener = exceptionListener;
        this.executorService = Executors.newSingleThreadExecutor(threadFactory);
        this.status = new AtomicReference<Status>(Status.READY);
    }

    protected void execute() {
        if (this.status.compareAndSet(Status.READY, Status.RUNNING)) {
            this.executorService.execute(new Runnable(){

                @Override
                public void run() {
                    block2: {
                        try {
                            IOReactorExecutor.this.ioReactor.execute();
                        }
                        catch (Exception ex) {
                            if (IOReactorExecutor.this.exceptionListener == null) break block2;
                            IOReactorExecutor.this.exceptionListener.onError(ex);
                        }
                    }
                }
            });
        }
    }

    T reactor() {
        return this.ioReactor;
    }

    public IOReactorStatus getStatus() {
        return ((AbstractMultiworkerIOReactor)this.ioReactor).getStatus();
    }

    public List<ExceptionEvent> getAuditLog() {
        return ((AbstractMultiworkerIOReactor)this.ioReactor).getAuditLog();
    }

    public void awaitShutdown(TimeValue waitTime) throws InterruptedException {
        ((AbstractMultiworkerIOReactor)this.ioReactor).awaitShutdown(waitTime);
    }

    public void initiateShutdown() {
        ((AbstractMultiworkerIOReactor)this.ioReactor).initiateShutdown();
    }

    @Override
    public void shutdown(ShutdownType shutdownType) {
        ((AbstractMultiworkerIOReactor)this.ioReactor).shutdown(shutdownType);
    }

    @Override
    public void close() {
        this.shutdown(ShutdownType.GRACEFUL);
    }

    static enum Status {
        READY,
        RUNNING,
        TERMINATED;

    }
}

