/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.bootstrap;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLSocketFactory;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.hc.core5.http.ConnectionRequestTimeoutException;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.config.H1Config;
import org.apache.hc.core5.http.config.SocketConfig;
import org.apache.hc.core5.http.impl.io.DefaultBHttpClientConnectionFactory;
import org.apache.hc.core5.http.impl.io.HttpRequestExecutor;
import org.apache.hc.core5.http.io.EofSensorInputStream;
import org.apache.hc.core5.http.io.EofSensorWatcher;
import org.apache.hc.core5.http.io.HttpClientConnection;
import org.apache.hc.core5.http.io.HttpConnectionFactory;
import org.apache.hc.core5.http.io.ResponseHandler;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.HttpEntityWrapper;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.io.GracefullyCloseable;
import org.apache.hc.core5.io.ShutdownType;
import org.apache.hc.core5.pool.ConnPoolControl;
import org.apache.hc.core5.pool.ControlledConnPool;
import org.apache.hc.core5.pool.PoolEntry;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TimeValue;

public class HttpRequester
implements GracefullyCloseable {
    private final HttpRequestExecutor requestExecutor;
    private final HttpProcessor httpProcessor;
    private final ControlledConnPool<HttpHost, HttpClientConnection> connPool;
    private final SocketConfig socketConfig;
    private final HttpConnectionFactory<? extends HttpClientConnection> connectFactory;
    private final SSLSocketFactory sslSocketFactory;

    public HttpRequester(HttpRequestExecutor requestExecutor, HttpProcessor httpProcessor, ControlledConnPool<HttpHost, HttpClientConnection> connPool, SocketConfig socketConfig, HttpConnectionFactory<? extends HttpClientConnection> connectFactory, SSLSocketFactory sslSocketFactory) {
        this.requestExecutor = Args.notNull(requestExecutor, "Request executor");
        this.httpProcessor = Args.notNull(httpProcessor, "HTTP processor");
        this.connPool = Args.notNull(connPool, "Connection pool");
        this.socketConfig = socketConfig != null ? socketConfig : SocketConfig.DEFAULT;
        this.connectFactory = connectFactory != null ? connectFactory : new DefaultBHttpClientConnectionFactory(H1Config.DEFAULT, CharCodingConfig.DEFAULT);
        this.sslSocketFactory = sslSocketFactory != null ? sslSocketFactory : (SSLSocketFactory)SSLSocketFactory.getDefault();
    }

    public ClassicHttpResponse execute(HttpClientConnection connection, ClassicHttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(connection, "HTTP connection");
        Args.notNull(request, "HTTP request");
        Args.notNull(context, "HTTP context");
        if (!connection.isOpen()) {
            throw new ConnectionClosedException("Connection is closed");
        }
        this.requestExecutor.preProcess(request, this.httpProcessor, context);
        ClassicHttpResponse response = this.requestExecutor.execute(request, connection, context);
        this.requestExecutor.postProcess(response, this.httpProcessor, context);
        return response;
    }

    public boolean keepAlive(HttpClientConnection connection, ClassicHttpRequest request, ClassicHttpResponse response, HttpContext context) throws IOException {
        boolean keepAlive = this.requestExecutor.keepAlive(request, response, connection, context);
        if (!keepAlive) {
            connection.close();
        }
        return keepAlive;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T execute(HttpClientConnection connection, ClassicHttpRequest request, HttpContext context, ResponseHandler<T> responseHandler) throws HttpException, IOException {
        try (ClassicHttpResponse response = this.execute(connection, request, context);){
            T result = responseHandler.handleResponse(response);
            EntityUtils.consume(response.getEntity());
            boolean keepAlive = this.requestExecutor.keepAlive(request, response, connection, context);
            if (!keepAlive) {
                connection.close();
            }
            T t = result;
            return t;
        }
        catch (IOException | RuntimeException | HttpException ex) {
            connection.shutdown(ShutdownType.IMMEDIATE);
            throw ex;
        }
    }

    private Socket createSocket(HttpHost targetHost) throws IOException {
        int linger;
        Socket sock = new Socket();
        sock.setSoTimeout(this.socketConfig.getSoTimeout().toMillisIntBound());
        sock.setReuseAddress(this.socketConfig.isSoReuseAddress());
        sock.setTcpNoDelay(this.socketConfig.isTcpNoDelay());
        sock.setKeepAlive(this.socketConfig.isSoKeepAlive());
        if (this.socketConfig.getRcvBufSize() > 0) {
            sock.setReceiveBufferSize(this.socketConfig.getRcvBufSize());
        }
        if (this.socketConfig.getSndBufSize() > 0) {
            sock.setSendBufferSize(this.socketConfig.getSndBufSize());
        }
        if ((linger = this.socketConfig.getSoLinger().toMillisIntBound()) >= 0) {
            sock.setSoLinger(true, linger);
        }
        String scheme = targetHost.getSchemeName();
        int port = targetHost.getPort();
        if (port < 0) {
            if (URIScheme.HTTP.same(scheme)) {
                port = 80;
            } else if (URIScheme.HTTPS.same(scheme)) {
                port = 443;
            }
        }
        InetSocketAddress targetAddress = targetHost.getAddress() != null ? new InetSocketAddress(targetHost.getAddress(), port) : new InetSocketAddress(targetHost.getHostName(), port);
        sock.connect(targetAddress, this.socketConfig.getSoTimeout().toMillisIntBound());
        if (URIScheme.HTTPS.same(scheme)) {
            return this.sslSocketFactory.createSocket(sock, targetHost.getHostName(), port, true);
        }
        return sock;
    }

    public ClassicHttpResponse execute(HttpHost targetHost, final ClassicHttpRequest request, TimeValue connectTimeout, final HttpContext context) throws HttpException, IOException {
        PoolEntry<HttpHost, HttpClientConnection> poolEntry;
        Args.notNull(targetHost, "HTTP host");
        Args.notNull(request, "HTTP request");
        Future leaseFuture = this.connPool.lease(targetHost, null, null);
        TimeValue timeout = connectTimeout != null ? connectTimeout : TimeValue.ZERO_MILLISECONDS;
        try {
            poolEntry = leaseFuture.get(timeout.getDuration(), timeout.getTimeUnit());
        }
        catch (InterruptedException ex) {
            throw new InterruptedIOException(ex.getMessage());
        }
        catch (ExecutionException ex) {
            throw new HttpException("Unexpected failure leasing connection", ex);
        }
        catch (TimeoutException ex) {
            throw new ConnectionRequestTimeoutException("Connection request timeout");
        }
        final PoolEntryHolder connectionHolder = new PoolEntryHolder(poolEntry);
        try {
            ClassicHttpResponse response;
            HttpEntity entity;
            HttpClientConnection connection = poolEntry.getConnection();
            if (connection == null) {
                Socket socket = this.createSocket(targetHost);
                connection = this.connectFactory.createConnection(socket);
                poolEntry.assignConnection(connection);
            }
            if ((entity = (response = this.execute(connection, request, context)).getEntity()) != null) {
                response.setEntity(new HttpEntityWrapper(entity){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    private void releaseConnection() throws IOException {
                        try {
                            HttpClientConnection localConn = connectionHolder.getConnection();
                            if (localConn != null && HttpRequester.this.requestExecutor.keepAlive(request, response, localConn, context)) {
                                InputStream content;
                                if (super.isStreaming() && (content = super.getContent()) != null) {
                                    content.close();
                                }
                                connectionHolder.releaseConnection();
                            }
                        }
                        finally {
                            connectionHolder.discardConnection();
                        }
                    }

                    private void abortConnection() {
                        connectionHolder.discardConnection();
                    }

                    @Override
                    public boolean isStreaming() {
                        return true;
                    }

                    @Override
                    public InputStream getContent() throws IOException {
                        return new EofSensorInputStream(super.getContent(), new EofSensorWatcher(){

                            @Override
                            public boolean eofDetected(InputStream wrapped) throws IOException {
                                this.releaseConnection();
                                return false;
                            }

                            @Override
                            public boolean streamClosed(InputStream wrapped) throws IOException {
                                this.releaseConnection();
                                return false;
                            }

                            @Override
                            public boolean streamAbort(InputStream wrapped) throws IOException {
                                this.abortConnection();
                                return false;
                            }
                        });
                    }

                    @Override
                    public void writeTo(OutputStream outstream) throws IOException {
                        try {
                            if (outstream != null) {
                                super.writeTo(outstream);
                            }
                            this.close();
                        }
                        catch (IOException | RuntimeException ex) {
                            this.abortConnection();
                        }
                    }

                    @Override
                    public void close() throws IOException {
                        this.releaseConnection();
                    }
                });
            }
            return response;
        }
        catch (IOException | RuntimeException | HttpException ex) {
            connectionHolder.discardConnection();
            throw ex;
        }
    }

    public <T> T execute(HttpHost targetHost, ClassicHttpRequest request, TimeValue connectTimeout, HttpContext context, ResponseHandler<T> responseHandler) throws HttpException, IOException {
        try (ClassicHttpResponse response = this.execute(targetHost, request, connectTimeout, context);){
            T result = responseHandler.handleResponse(response);
            EntityUtils.consume(response.getEntity());
            T t = result;
            return t;
        }
    }

    public ConnPoolControl<HttpHost> getConnPoolControl() {
        return this.connPool;
    }

    @Override
    public void shutdown(ShutdownType shutdownType) {
        this.connPool.shutdown(shutdownType);
    }

    @Override
    public void close() throws IOException {
        this.connPool.close();
    }

    private class PoolEntryHolder {
        private final AtomicReference<PoolEntry<HttpHost, HttpClientConnection>> poolEntryRef;

        PoolEntryHolder(PoolEntry<HttpHost, HttpClientConnection> poolEntry) {
            this.poolEntryRef = new AtomicReference<PoolEntry<HttpHost, HttpClientConnection>>(poolEntry);
        }

        HttpClientConnection getConnection() {
            PoolEntry<HttpHost, HttpClientConnection> poolEntry = this.poolEntryRef.get();
            return poolEntry != null ? poolEntry.getConnection() : null;
        }

        void releaseConnection() {
            PoolEntry poolEntry = this.poolEntryRef.getAndSet(null);
            if (poolEntry != null) {
                HttpClientConnection connection = (HttpClientConnection)poolEntry.getConnection();
                HttpRequester.this.connPool.release(poolEntry, connection != null && connection.isOpen());
            }
        }

        void discardConnection() {
            PoolEntry poolEntry = this.poolEntryRef.getAndSet(null);
            if (poolEntry != null) {
                poolEntry.discardConnection(ShutdownType.IMMEDIATE);
                HttpRequester.this.connPool.release(poolEntry, false);
            }
        }
    }
}

