/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.bootstrap;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.core5.concurrent.BasicFuture;
import org.apache.hc.core5.concurrent.ComplexFuture;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.ExceptionListener;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.impl.bootstrap.AsyncRequester;
import org.apache.hc.core5.http.nio.AsyncClientEndpoint;
import org.apache.hc.core5.http.nio.AsyncClientExchangeHandler;
import org.apache.hc.core5.http.nio.AsyncRequestProducer;
import org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import org.apache.hc.core5.http.nio.CapacityChannel;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.http.nio.RequestChannel;
import org.apache.hc.core5.http.nio.command.ExecutionCommand;
import org.apache.hc.core5.http.nio.command.ShutdownCommand;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.http.nio.support.BasicClientExchangeHandler;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpCoreContext;
import org.apache.hc.core5.io.ShutdownType;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.pool.ControlledConnPool;
import org.apache.hc.core5.pool.PoolEntry;
import org.apache.hc.core5.reactor.IOEventHandlerFactory;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.reactor.IOReactorException;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.SessionRequest;
import org.apache.hc.core5.reactor.SessionRequestCallback;
import org.apache.hc.core5.reactor.TlsCapableIOSession;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TimeValue;

public class HttpAsyncRequester
extends AsyncRequester {
    private final ControlledConnPool<HttpHost, IOSession> connPool;
    private final TlsStrategy tlsStrategy;

    public HttpAsyncRequester(IOReactorConfig ioReactorConfig, IOEventHandlerFactory eventHandlerFactory, ControlledConnPool<HttpHost, IOSession> connPool, TlsStrategy tlsStrategy, ExceptionListener exceptionListener) throws IOReactorException {
        super(eventHandlerFactory, ioReactorConfig, exceptionListener, new Callback<IOSession>(){

            @Override
            public void execute(IOSession session) {
                session.addFirst(new ShutdownCommand(ShutdownType.GRACEFUL));
            }
        });
        this.connPool = Args.notNull(connPool, "Connection pool");
        this.tlsStrategy = tlsStrategy;
    }

    public void start() throws IOException {
        this.execute();
    }

    public Future<AsyncClientEndpoint> connect(HttpHost host, TimeValue timeout, Object attachment, FutureCallback<AsyncClientEndpoint> callback) {
        return this.doConnect(host, timeout, attachment, callback);
    }

    protected Future<AsyncClientEndpoint> doConnect(final HttpHost host, final TimeValue timeout, final Object attachment, FutureCallback<AsyncClientEndpoint> callback) {
        Args.notNull(host, "Host");
        Args.notNull(timeout, "Timeout");
        final ComplexFuture<AsyncClientEndpoint> resultFuture = new ComplexFuture<AsyncClientEndpoint>(callback);
        Future<PoolEntry<HttpHost, IOSession>> leaseFuture = this.connPool.lease(host, null, new FutureCallback<PoolEntry<HttpHost, IOSession>>(){

            @Override
            public void completed(final PoolEntry<HttpHost, IOSession> poolEntry) {
                final InternalAsyncClientEndpoint endpoint = new InternalAsyncClientEndpoint(poolEntry);
                IOSession ioSession = poolEntry.getConnection();
                if (ioSession != null && ioSession.isClosed()) {
                    poolEntry.discardConnection(ShutdownType.IMMEDIATE);
                }
                if (poolEntry.hasConnection()) {
                    resultFuture.completed(endpoint);
                } else {
                    SessionRequest sessionRequest = HttpAsyncRequester.this.requestSession(host, timeout, attachment, new SessionRequestCallback(){

                        @Override
                        public void completed(SessionRequest request) {
                            TlsCapableIOSession session = request.getSession();
                            if (HttpAsyncRequester.this.tlsStrategy != null && URIScheme.HTTPS.same(host.getSchemeName())) {
                                HttpAsyncRequester.this.tlsStrategy.upgrade(session, host, session.getLocalAddress(), session.getRemoteAddress(), attachment);
                            }
                            session.setSocketTimeout(timeout.toMillisIntBound());
                            poolEntry.assignConnection(session);
                            resultFuture.completed(endpoint);
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void failed(SessionRequest request) {
                            try {
                                resultFuture.failed(request.getException());
                            }
                            finally {
                                endpoint.releaseAndDiscard();
                            }
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void timeout(SessionRequest request) {
                            try {
                                resultFuture.failed(new SocketTimeoutException("Connect timeout"));
                            }
                            finally {
                                endpoint.releaseAndDiscard();
                            }
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void cancelled(SessionRequest request) {
                            try {
                                resultFuture.cancel();
                            }
                            finally {
                                endpoint.releaseAndDiscard();
                            }
                        }
                    });
                    resultFuture.setDependency(sessionRequest);
                }
            }

            @Override
            public void failed(Exception ex) {
                resultFuture.failed(ex);
            }

            @Override
            public void cancelled() {
                resultFuture.cancel();
            }
        });
        resultFuture.setDependency(leaseFuture);
        return resultFuture;
    }

    public Future<AsyncClientEndpoint> connect(HttpHost host, TimeValue timeout) throws InterruptedException {
        return this.connect(host, timeout, null, null);
    }

    public void execute(final AsyncClientExchangeHandler exchangeHandler, final TimeValue timeout, final HttpContext context) {
        Args.notNull(exchangeHandler, "Exchange handler");
        Args.notNull(timeout, "Timeout");
        Args.notNull(context, "Context");
        try {
            exchangeHandler.produceRequest(new RequestChannel(){

                @Override
                public void sendRequest(final HttpRequest request, final EntityDetails entityDetails) throws HttpException, IOException {
                    String scheme = request.getScheme();
                    URIAuthority authority = request.getAuthority();
                    if (authority == null) {
                        throw new ProtocolException("Request authority not specified");
                    }
                    HttpHost target = new HttpHost(authority, scheme);
                    HttpAsyncRequester.this.connect(target, timeout, null, new FutureCallback<AsyncClientEndpoint>(){

                        @Override
                        public void completed(final AsyncClientEndpoint endpoint) {
                            endpoint.execute(new AsyncClientExchangeHandler(){

                                @Override
                                public void releaseResources() {
                                    endpoint.releaseAndDiscard();
                                    exchangeHandler.releaseResources();
                                }

                                @Override
                                public void failed(Exception cause) {
                                    endpoint.releaseAndDiscard();
                                    exchangeHandler.failed(cause);
                                }

                                @Override
                                public void cancel() {
                                    endpoint.releaseAndDiscard();
                                    exchangeHandler.cancel();
                                }

                                @Override
                                public void produceRequest(RequestChannel channel) throws HttpException, IOException {
                                    channel.sendRequest(request, entityDetails);
                                }

                                @Override
                                public int available() {
                                    return exchangeHandler.available();
                                }

                                @Override
                                public void produce(DataStreamChannel channel) throws IOException {
                                    exchangeHandler.produce(channel);
                                }

                                @Override
                                public void consumeInformation(HttpResponse response) throws HttpException, IOException {
                                    exchangeHandler.consumeInformation(response);
                                }

                                @Override
                                public void consumeResponse(HttpResponse response, EntityDetails entityDetails) throws HttpException, IOException {
                                    if (entityDetails == null) {
                                        endpoint.releaseAndReuse();
                                    }
                                    exchangeHandler.consumeResponse(response, entityDetails);
                                }

                                @Override
                                public void updateCapacity(CapacityChannel capacityChannel) throws IOException {
                                    exchangeHandler.updateCapacity(capacityChannel);
                                }

                                @Override
                                public int consume(ByteBuffer src) throws IOException {
                                    return exchangeHandler.consume(src);
                                }

                                @Override
                                public void streamEnd(List<? extends Header> trailers) throws HttpException, IOException {
                                    endpoint.releaseAndReuse();
                                    exchangeHandler.streamEnd(trailers);
                                }
                            }, context);
                        }

                        @Override
                        public void failed(Exception ex) {
                            exchangeHandler.failed(ex);
                        }

                        @Override
                        public void cancelled() {
                            exchangeHandler.cancel();
                        }
                    });
                }
            });
        }
        catch (IOException | HttpException ex) {
            exchangeHandler.failed(ex);
        }
    }

    public final <T> Future<T> execute(AsyncRequestProducer requestProducer, AsyncResponseConsumer<T> responseConsumer, TimeValue timeout, HttpContext context, FutureCallback<T> callback) {
        Args.notNull(requestProducer, "Request producer");
        Args.notNull(responseConsumer, "Response consumer");
        Args.notNull(timeout, "Timeout");
        final BasicFuture<T> future = new BasicFuture<T>(callback);
        BasicClientExchangeHandler<T> exchangeHandler = new BasicClientExchangeHandler<T>(requestProducer, responseConsumer, new FutureCallback<T>(){

            @Override
            public void completed(T result) {
                future.completed(result);
            }

            @Override
            public void failed(Exception ex) {
                future.failed(ex);
            }

            @Override
            public void cancelled() {
                future.cancel();
            }
        });
        this.execute(exchangeHandler, timeout, context != null ? context : HttpCoreContext.create());
        return future;
    }

    public final <T> Future<T> execute(AsyncRequestProducer requestProducer, AsyncResponseConsumer<T> responseConsumer, TimeValue timeout, FutureCallback<T> callback) {
        return this.execute(requestProducer, responseConsumer, timeout, null, callback);
    }

    private class InternalAsyncClientEndpoint
    extends AsyncClientEndpoint {
        final AtomicReference<PoolEntry<HttpHost, IOSession>> poolEntryRef;

        InternalAsyncClientEndpoint(PoolEntry<HttpHost, IOSession> poolEntry) {
            this.poolEntryRef = new AtomicReference<PoolEntry<HttpHost, IOSession>>(poolEntry);
        }

        @Override
        public void execute(AsyncClientExchangeHandler exchangeHandler, HttpContext context) {
            PoolEntry<HttpHost, IOSession> poolEntry = this.poolEntryRef.get();
            if (poolEntry == null) {
                throw new IllegalStateException("Endpoint has already been released");
            }
            IOSession ioSession = poolEntry.getConnection();
            if (ioSession == null) {
                throw new IllegalStateException("I/O session is invalid");
            }
            ioSession.addLast(new ExecutionCommand(exchangeHandler, context));
        }

        @Override
        public void releaseAndReuse() {
            PoolEntry poolEntry = this.poolEntryRef.getAndSet(null);
            if (poolEntry != null) {
                IOSession ioSession = (IOSession)poolEntry.getConnection();
                HttpAsyncRequester.this.connPool.release(poolEntry, ioSession != null && !ioSession.isClosed());
            }
        }

        @Override
        public void releaseAndDiscard() {
            PoolEntry poolEntry = this.poolEntryRef.getAndSet(null);
            if (poolEntry != null) {
                poolEntry.discardConnection(ShutdownType.IMMEDIATE);
                HttpAsyncRequester.this.connPool.release(poolEntry, false);
            }
        }
    }
}

