/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.bootstrap;

import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hc.core5.function.Supplier;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.nio.AsyncServerExchangeHandler;
import org.apache.hc.core5.http.nio.HandlerFactory;
import org.apache.hc.core5.http.nio.support.ImmediateResponseExchangeHandler;
import org.apache.hc.core5.http.protocol.UriPatternMatcher;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.util.Args;

public class AsyncServerExchangeHandlerRegistry
implements HandlerFactory<AsyncServerExchangeHandler> {
    private static final String LOCALHOST = "localhost";
    private final String canonicalHostName;
    private final UriPatternMatcher<Supplier<AsyncServerExchangeHandler>> primary;
    private final ConcurrentMap<String, UriPatternMatcher<Supplier<AsyncServerExchangeHandler>>> virtualMap;

    public AsyncServerExchangeHandlerRegistry(String canonicalHostName) {
        this.canonicalHostName = Args.notNull(canonicalHostName, "Canonical hostname").toLowerCase(Locale.ROOT);
        this.primary = new UriPatternMatcher();
        this.virtualMap = new ConcurrentHashMap<String, UriPatternMatcher<Supplier<AsyncServerExchangeHandler>>>();
    }

    private UriPatternMatcher<Supplier<AsyncServerExchangeHandler>> getPatternMatcher(String hostname) {
        if (hostname == null) {
            return this.primary;
        }
        if (hostname.equals(this.canonicalHostName) || hostname.equals(LOCALHOST)) {
            return this.primary;
        }
        return (UriPatternMatcher)this.virtualMap.get(hostname);
    }

    @Override
    public AsyncServerExchangeHandler create(HttpRequest request) throws HttpException {
        Supplier<AsyncServerExchangeHandler> supplier;
        URIAuthority authority = request.getAuthority();
        String key = authority != null ? authority.getHostName().toLowerCase(Locale.ROOT) : null;
        UriPatternMatcher<Supplier<AsyncServerExchangeHandler>> patternMatcher = this.getPatternMatcher(key);
        if (patternMatcher == null) {
            return new ImmediateResponseExchangeHandler(421, "Not authoritative");
        }
        String path = request.getPath();
        int i = path.indexOf("?");
        if (i != -1) {
            path = path.substring(0, i);
        }
        if ((supplier = patternMatcher.lookup(path)) != null) {
            return supplier.get();
        }
        return new ImmediateResponseExchangeHandler(404, "Resource not found");
    }

    public void register(String hostname, String uriPattern, Supplier<AsyncServerExchangeHandler> supplier) {
        String key;
        Args.notBlank(uriPattern, "URI pattern");
        Args.notNull(supplier, "Supplier");
        String string = key = hostname != null ? hostname.toLowerCase(Locale.ROOT) : null;
        if (hostname == null || hostname.equals(this.canonicalHostName) || hostname.equals(LOCALHOST)) {
            this.primary.register(uriPattern, supplier);
        } else {
            UriPatternMatcher newMatcher;
            UriPatternMatcher<Supplier<AsyncServerExchangeHandler>> matcher = (UriPatternMatcher<Supplier<AsyncServerExchangeHandler>>)this.virtualMap.get(key);
            if (matcher == null && (matcher = this.virtualMap.putIfAbsent(key, newMatcher = new UriPatternMatcher())) == null) {
                matcher = newMatcher;
            }
            matcher.register(uriPattern, supplier);
        }
    }
}

