/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.bootstrap;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.hc.core5.concurrent.DefaultThreadFactory;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.http.ExceptionListener;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.impl.bootstrap.IOReactorExecutor;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.reactor.ConnectionInitiator;
import org.apache.hc.core5.reactor.DefaultConnectingIOReactor;
import org.apache.hc.core5.reactor.IOEventHandlerFactory;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.reactor.IOReactorException;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.SessionRequest;
import org.apache.hc.core5.reactor.SessionRequestCallback;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TimeValue;

public class AsyncRequester
extends IOReactorExecutor<DefaultConnectingIOReactor>
implements ConnectionInitiator {
    public AsyncRequester(IOEventHandlerFactory eventHandlerFactory, IOReactorConfig ioReactorConfig, ExceptionListener exceptionListener, Callback<IOSession> sessionShutdownCallback) throws IOReactorException {
        super(new DefaultConnectingIOReactor(eventHandlerFactory, ioReactorConfig, new DefaultThreadFactory("requester-dispatch", true), sessionShutdownCallback), exceptionListener, new DefaultThreadFactory("connector", true));
    }

    private InetSocketAddress toSocketAddress(HttpHost host) {
        int port = host.getPort();
        if (port < 0) {
            String scheme = host.getSchemeName();
            if (URIScheme.HTTP.same(scheme)) {
                port = 80;
            } else if (URIScheme.HTTPS.same(scheme)) {
                port = 443;
            }
        }
        String hostName = host.getHostName();
        return new InetSocketAddress(hostName, port);
    }

    public SessionRequest requestSession(HttpHost host, TimeValue timeout, Object attachment, SessionRequestCallback callback) {
        Args.notNull(host, "Host");
        Args.notNull(timeout, "Timeout");
        SessionRequest sessionRequest = ((DefaultConnectingIOReactor)this.reactor()).connect(host, this.toSocketAddress(host), null, attachment, callback);
        sessionRequest.setConnectTimeout(timeout.toMillisIntBound());
        return sessionRequest;
    }

    @Override
    public SessionRequest connect(NamedEndpoint remoteEndpoint, SocketAddress remoteAddress, SocketAddress localAddress, Object attachment, SessionRequestCallback callback) {
        return ((DefaultConnectingIOReactor)this.reactor()).connect(remoteEndpoint, remoteAddress, localAddress, attachment, callback);
    }
}

