/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl;

import java.util.Collections;
import java.util.Set;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.MessageHeaders;
import org.apache.hc.core5.http.message.MessageSupport;
import org.apache.hc.core5.util.Args;

public class LazyEntityDetails
implements EntityDetails {
    private final MessageHeaders message;

    public LazyEntityDetails(MessageHeaders message) {
        this.message = Args.notNull(message, "Message");
    }

    @Override
    public long getContentLength() {
        return -1L;
    }

    @Override
    public String getContentType() {
        Header h = this.message.getFirstHeader("Content-Type");
        return h != null ? h.getValue() : null;
    }

    @Override
    public String getContentEncoding() {
        Header h = this.message.getFirstHeader("Content-Type");
        return h != null ? h.getValue() : null;
    }

    @Override
    public boolean isChunked() {
        return false;
    }

    @Override
    public Set<String> getTrailerNames() {
        Header h = this.message.getFirstHeader("Trailer");
        if (h == null) {
            return Collections.emptySet();
        }
        return MessageSupport.parseTokens(h);
    }
}

