/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.concurrent;

import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.core5.concurrent.BasicFuture;
import org.apache.hc.core5.concurrent.Cancellable;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.util.Args;

public final class ComplexFuture<T>
extends BasicFuture<T> {
    private final AtomicReference<Cancellable> dependencyRef = new AtomicReference<Object>(null);

    public ComplexFuture(FutureCallback<T> callback) {
        super(callback);
    }

    public void setDependency(Cancellable dependency) {
        Args.notNull(dependency, "dependency");
        if (this.isDone()) {
            dependency.cancel();
        } else {
            this.dependencyRef.set(dependency);
        }
    }

    public void setDependency(final Future<?> dependency) {
        Args.notNull(dependency, "dependency");
        this.setDependency(new Cancellable(){

            @Override
            public boolean cancel() {
                return dependency.cancel(true);
            }
        });
    }

    public void clearDependency() {
        this.dependencyRef.set(null);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean cancelled = super.cancel(mayInterruptIfRunning);
        Cancellable dependency = this.dependencyRef.getAndSet(null);
        if (dependency != null) {
            dependency.cancel();
        }
        return cancelled;
    }
}

