/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hc.client5.http.cache.InputLimit;
import org.apache.hc.client5.http.cache.Resource;
import org.apache.hc.client5.http.cache.ResourceFactory;
import org.apache.hc.client5.http.impl.cache.CombinedEntity;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.message.BasicClassicHttpResponse;

class SizeLimitedResponseReader {
    private final ResourceFactory resourceFactory;
    private final long maxResponseSizeBytes;
    private final HttpRequest request;
    private final ClassicHttpResponse response;
    private InputStream instream;
    private InputLimit limit;
    private Resource resource;
    private boolean consumed;

    public SizeLimitedResponseReader(ResourceFactory resourceFactory, long maxResponseSizeBytes, HttpRequest request, ClassicHttpResponse response) {
        this.resourceFactory = resourceFactory;
        this.maxResponseSizeBytes = maxResponseSizeBytes;
        this.request = request;
        this.response = response;
    }

    protected void readResponse() throws IOException {
        if (!this.consumed) {
            this.doConsume();
        }
    }

    private void ensureNotConsumed() {
        if (this.consumed) {
            throw new IllegalStateException("Response has already been consumed");
        }
    }

    private void ensureConsumed() {
        if (!this.consumed) {
            throw new IllegalStateException("Response has not been consumed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doConsume() throws IOException {
        this.ensureNotConsumed();
        this.consumed = true;
        this.limit = new InputLimit(this.maxResponseSizeBytes);
        HttpEntity entity = this.response.getEntity();
        if (entity == null) {
            return;
        }
        String uri = this.request.getRequestUri();
        this.instream = entity.getContent();
        try {
            this.resource = this.resourceFactory.generate(uri, this.instream, this.limit);
        }
        finally {
            if (!this.limit.isReached()) {
                this.instream.close();
            }
        }
    }

    boolean isLimitReached() {
        this.ensureConsumed();
        return this.limit.isReached();
    }

    Resource getResource() {
        this.ensureConsumed();
        return this.resource;
    }

    ClassicHttpResponse getReconstructedResponse() throws IOException {
        this.ensureConsumed();
        BasicClassicHttpResponse reconstructed = new BasicClassicHttpResponse(this.response.getCode()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void close() throws IOException {
                try {
                    super.close();
                }
                finally {
                    SizeLimitedResponseReader.this.response.close();
                }
            }
        };
        reconstructed.setHeaders(this.response.getAllHeaders());
        CombinedEntity combinedEntity = new CombinedEntity(this.resource, this.instream);
        HttpEntity entity = this.response.getEntity();
        if (entity != null) {
            combinedEntity.setContentType(entity.getContentType());
            combinedEntity.setContentEncoding(entity.getContentEncoding());
            combinedEntity.setChunked(entity.isChunked());
        }
        reconstructed.setEntity((HttpEntity)combinedEntity);
        return reconstructed;
    }
}

