/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.hc.client5.http.utils.DateUtils;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HeaderElement;
import org.apache.hc.core5.http.HttpMessage;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.MessageHeaders;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.message.MessageSupport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
class ResponseCachingPolicy {
    private static final String[] AUTH_CACHEABLE_PARAMS = new String[]{"s-maxage", "must-revalidate", "public"};
    private final long maxObjectSizeBytes;
    private final boolean sharedCache;
    private final boolean neverCache1_0ResponsesWithQueryString;
    private final Logger log = LogManager.getLogger(this.getClass());
    private static final Set<Integer> cacheableStatuses = new HashSet<Integer>(Arrays.asList(200, 203, 300, 301, 410));
    private final Set<Integer> uncacheableStatuses;

    public ResponseCachingPolicy(long maxObjectSizeBytes, boolean sharedCache, boolean neverCache1_0ResponsesWithQueryString, boolean allow303Caching) {
        this.maxObjectSizeBytes = maxObjectSizeBytes;
        this.sharedCache = sharedCache;
        this.neverCache1_0ResponsesWithQueryString = neverCache1_0ResponsesWithQueryString;
        this.uncacheableStatuses = allow303Caching ? new HashSet<Integer>(Arrays.asList(206)) : new HashSet<Integer>(Arrays.asList(206, 303));
    }

    public boolean isResponseCacheable(String httpMethod, HttpResponse response) {
        long contentLengthValue;
        boolean cacheable = false;
        if (!"GET".equals(httpMethod) && !"HEAD".equals(httpMethod)) {
            this.log.debug("Response was not cacheable.");
            return false;
        }
        int status = response.getCode();
        if (cacheableStatuses.contains(status)) {
            cacheable = true;
        } else {
            if (this.uncacheableStatuses.contains(status)) {
                return false;
            }
            if (this.unknownStatusCode(status)) {
                return false;
            }
        }
        Header contentLength = response.getFirstHeader("Content-Length");
        if (contentLength != null && (contentLengthValue = Long.parseLong(contentLength.getValue())) > this.maxObjectSizeBytes) {
            return false;
        }
        Header[] ageHeaders = response.getHeaders("Age");
        if (ageHeaders.length > 1) {
            return false;
        }
        Header[] expiresHeaders = response.getHeaders("Expires");
        if (expiresHeaders.length > 1) {
            return false;
        }
        Header[] dateHeaders = response.getHeaders("Date");
        if (dateHeaders.length != 1) {
            return false;
        }
        Date date = DateUtils.parseDate((String)dateHeaders[0].getValue());
        if (date == null) {
            return false;
        }
        Iterator it = MessageSupport.iterate((MessageHeaders)response, (String)"Vary");
        while (it.hasNext()) {
            HeaderElement elem = (HeaderElement)it.next();
            if (!"*".equals(elem.getName())) continue;
            return false;
        }
        if (this.isExplicitlyNonCacheable(response)) {
            return false;
        }
        return cacheable || this.isExplicitlyCacheable(response);
    }

    private boolean unknownStatusCode(int status) {
        if (status >= 100 && status <= 101) {
            return false;
        }
        if (status >= 200 && status <= 206) {
            return false;
        }
        if (status >= 300 && status <= 307) {
            return false;
        }
        if (status >= 400 && status <= 417) {
            return false;
        }
        return status < 500 || status > 505;
    }

    protected boolean isExplicitlyNonCacheable(HttpResponse response) {
        Iterator it = MessageSupport.iterate((MessageHeaders)response, (String)"Cache-Control");
        while (it.hasNext()) {
            HeaderElement elem = (HeaderElement)it.next();
            if (!"no-store".equals(elem.getName()) && !"no-cache".equals(elem.getName()) && (!this.sharedCache || !"private".equals(elem.getName()))) continue;
            return true;
        }
        return false;
    }

    protected boolean hasCacheControlParameterFrom(HttpMessage msg, String[] params) {
        Iterator it = MessageSupport.iterate((MessageHeaders)msg, (String)"Cache-Control");
        while (it.hasNext()) {
            HeaderElement elem = (HeaderElement)it.next();
            for (String param : params) {
                if (!param.equalsIgnoreCase(elem.getName())) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isExplicitlyCacheable(HttpResponse response) {
        if (response.getFirstHeader("Expires") != null) {
            return true;
        }
        String[] cacheableParams = new String[]{"max-age", "s-maxage", "must-revalidate", "proxy-revalidate", "public"};
        return this.hasCacheControlParameterFrom((HttpMessage)response, cacheableParams);
    }

    public boolean isResponseCacheable(HttpRequest request, HttpResponse response) {
        Header[] authNHeaders;
        if (this.requestProtocolGreaterThanAccepted(request)) {
            this.log.debug("Response was not cacheable.");
            return false;
        }
        String[] uncacheableRequestDirectives = new String[]{"no-store"};
        if (this.hasCacheControlParameterFrom((HttpMessage)request, uncacheableRequestDirectives)) {
            return false;
        }
        if (request.getRequestUri().contains("?")) {
            if (this.neverCache1_0ResponsesWithQueryString && this.from1_0Origin(response)) {
                this.log.debug("Response was not cacheable as it had a query string.");
                return false;
            }
            if (!this.isExplicitlyCacheable(response)) {
                this.log.debug("Response was not cacheable as it is missing explicit caching headers.");
                return false;
            }
        }
        if (this.expiresHeaderLessOrEqualToDateHeaderAndNoCacheControl(response)) {
            return false;
        }
        if (this.sharedCache && (authNHeaders = request.getHeaders("Authorization")) != null && authNHeaders.length > 0 && !this.hasCacheControlParameterFrom((HttpMessage)response, AUTH_CACHEABLE_PARAMS)) {
            return false;
        }
        String method = request.getMethod();
        return this.isResponseCacheable(method, response);
    }

    private boolean expiresHeaderLessOrEqualToDateHeaderAndNoCacheControl(HttpResponse response) {
        if (response.getFirstHeader("Cache-Control") != null) {
            return false;
        }
        Header expiresHdr = response.getFirstHeader("Expires");
        Header dateHdr = response.getFirstHeader("Date");
        if (expiresHdr == null || dateHdr == null) {
            return false;
        }
        Date expires = DateUtils.parseDate((String)expiresHdr.getValue());
        Date date = DateUtils.parseDate((String)dateHdr.getValue());
        if (expires == null || date == null) {
            return false;
        }
        return expires.equals(date) || expires.before(date);
    }

    private boolean from1_0Origin(HttpResponse response) {
        Iterator it = MessageSupport.iterate((MessageHeaders)response, (String)"Via");
        if (it.hasNext()) {
            HeaderElement elt = (HeaderElement)it.next();
            String proto = elt.toString().split("\\s")[0];
            if (proto.contains("/")) {
                return proto.equals("HTTP/1.0");
            }
            return proto.equals("1.0");
        }
        HttpVersion version = response.getVersion() != null ? response.getVersion() : HttpVersion.DEFAULT;
        return HttpVersion.HTTP_1_0.equals((Object)version);
    }

    private boolean requestProtocolGreaterThanAccepted(HttpRequest req) {
        HttpVersion version = req.getVersion() != null ? req.getVersion() : HttpVersion.DEFAULT;
        return version.compareToVersion((ProtocolVersion)HttpVersion.HTTP_1_1) > 0;
    }
}

