/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.hc.client5.http.impl.cache.RequestProtocolError;
import org.apache.hc.client5.http.protocol.ClientProtocolException;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HeaderElement;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.MessageHeaders;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.io.entity.HttpEntityWrapper;
import org.apache.hc.core5.http.message.BasicClassicHttpResponse;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.MessageSupport;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
class RequestProtocolCompliance {
    private final boolean weakETagOnPutDeleteAllowed;
    private static final List<String> disallowedWithNoCache = Arrays.asList("min-fresh", "max-stale", "max-age");

    public RequestProtocolCompliance() {
        this.weakETagOnPutDeleteAllowed = false;
    }

    public RequestProtocolCompliance(boolean weakETagOnPutDeleteAllowed) {
        this.weakETagOnPutDeleteAllowed = weakETagOnPutDeleteAllowed;
    }

    public List<RequestProtocolError> requestIsFatallyNonCompliant(HttpRequest request) {
        ArrayList<RequestProtocolError> theErrors = new ArrayList<RequestProtocolError>();
        RequestProtocolError anError = this.requestHasWeakETagAndRange(request);
        if (anError != null) {
            theErrors.add(anError);
        }
        if (!this.weakETagOnPutDeleteAllowed && (anError = this.requestHasWeekETagForPUTOrDELETEIfMatch(request)) != null) {
            theErrors.add(anError);
        }
        if ((anError = this.requestContainsNoCacheDirectiveWithFieldName(request)) != null) {
            theErrors.add(anError);
        }
        return theErrors;
    }

    public void makeRequestCompliant(ClassicHttpRequest request) throws ClientProtocolException {
        if (this.requestMustNotHaveEntity((HttpRequest)request)) {
            request.setEntity(null);
        }
        this.verifyRequestWithExpectContinueFlagHas100continueHeader(request);
        this.verifyOPTIONSRequestWithBodyHasContentType(request);
        this.decrementOPTIONSMaxForwardsIfGreaterThen0((HttpRequest)request);
        this.stripOtherFreshnessDirectivesWithNoCache((HttpRequest)request);
        if (this.requestVersionIsTooLow((HttpRequest)request) || this.requestMinorVersionIsTooHighMajorVersionsMatch((HttpRequest)request)) {
            request.setVersion((ProtocolVersion)HttpVersion.HTTP_1_1);
        }
    }

    private void stripOtherFreshnessDirectivesWithNoCache(HttpRequest request) {
        ArrayList<HeaderElement> outElts = new ArrayList<HeaderElement>();
        boolean shouldStrip = false;
        Iterator it = MessageSupport.iterate((MessageHeaders)request, (String)"Cache-Control");
        while (it.hasNext()) {
            HeaderElement elt = (HeaderElement)it.next();
            if (!disallowedWithNoCache.contains(elt.getName())) {
                outElts.add(elt);
            }
            if (!"no-cache".equals(elt.getName())) continue;
            shouldStrip = true;
        }
        if (!shouldStrip) {
            return;
        }
        request.removeHeaders("Cache-Control");
        request.setHeader("Cache-Control", (Object)this.buildHeaderFromElements(outElts));
    }

    private String buildHeaderFromElements(List<HeaderElement> outElts) {
        StringBuilder newHdr = new StringBuilder("");
        boolean first = true;
        for (HeaderElement elt : outElts) {
            if (!first) {
                newHdr.append(",");
            } else {
                first = false;
            }
            newHdr.append(elt.toString());
        }
        return newHdr.toString();
    }

    private boolean requestMustNotHaveEntity(HttpRequest request) {
        return "TRACE".equals(request.getMethod());
    }

    private void decrementOPTIONSMaxForwardsIfGreaterThen0(HttpRequest request) {
        if (!"OPTIONS".equals(request.getMethod())) {
            return;
        }
        Header maxForwards = request.getFirstHeader("Max-Forwards");
        if (maxForwards == null) {
            return;
        }
        request.removeHeaders("Max-Forwards");
        int currentMaxForwards = Integer.parseInt(maxForwards.getValue());
        request.setHeader("Max-Forwards", (Object)Integer.toString(currentMaxForwards - 1));
    }

    private void verifyOPTIONSRequestWithBodyHasContentType(ClassicHttpRequest request) {
        if (!"OPTIONS".equals(request.getMethod())) {
            return;
        }
        this.addContentTypeHeaderIfMissing(request);
    }

    private void addContentTypeHeaderIfMissing(ClassicHttpRequest request) {
        HttpEntity entity = request.getEntity();
        if (entity != null && entity.getContentType() == null) {
            HttpEntityWrapper entityWrapper = new HttpEntityWrapper(entity){

                public String getContentType() {
                    return ContentType.APPLICATION_OCTET_STREAM.getMimeType();
                }
            };
            request.setEntity((HttpEntity)entityWrapper);
        }
    }

    private void verifyRequestWithExpectContinueFlagHas100continueHeader(ClassicHttpRequest request) {
        if (request.containsHeader("Expect") && request.getEntity() != null) {
            this.add100ContinueHeaderIfMissing((HttpRequest)request);
        } else {
            this.remove100ContinueHeaderIfExists((HttpRequest)request);
        }
    }

    private void remove100ContinueHeaderIfExists(HttpRequest request) {
        boolean hasHeader = false;
        Header[] expectHeaders = request.getHeaders("Expect");
        ArrayList<HeaderElement> expectElementsThatAreNot100Continue = new ArrayList<HeaderElement>();
        for (Header h : expectHeaders) {
            for (HeaderElement elt : MessageSupport.parse((Header)h)) {
                if (!"100-continue".equalsIgnoreCase(elt.getName())) {
                    expectElementsThatAreNot100Continue.add(elt);
                    continue;
                }
                hasHeader = true;
            }
            if (hasHeader) {
                request.removeHeader(h);
                for (HeaderElement elt : expectElementsThatAreNot100Continue) {
                    BasicHeader newHeader = new BasicHeader("100-continue", (Object)elt.getName());
                    request.addHeader((Header)newHeader);
                }
                return;
            }
            expectElementsThatAreNot100Continue = new ArrayList();
        }
    }

    private void add100ContinueHeaderIfMissing(HttpRequest request) {
        boolean hasHeader = false;
        Iterator it = MessageSupport.iterate((MessageHeaders)request, (String)"Expect");
        while (it.hasNext()) {
            HeaderElement elt = (HeaderElement)it.next();
            if (!"100-continue".equalsIgnoreCase(elt.getName())) continue;
            hasHeader = true;
        }
        if (!hasHeader) {
            request.addHeader("Expect", (Object)"100-continue");
        }
    }

    protected boolean requestMinorVersionIsTooHighMajorVersionsMatch(HttpRequest request) {
        ProtocolVersion requestProtocol = request.getVersion();
        if (requestProtocol.getMajor() != HttpVersion.HTTP_1_1.getMajor()) {
            return false;
        }
        return requestProtocol.getMinor() > HttpVersion.HTTP_1_1.getMinor();
    }

    protected boolean requestVersionIsTooLow(HttpRequest request) {
        return request.getVersion().compareToVersion((ProtocolVersion)HttpVersion.HTTP_1_1) < 0;
    }

    public ClassicHttpResponse getErrorForRequest(RequestProtocolError errorCheck) {
        switch (errorCheck) {
            case BODY_BUT_NO_LENGTH_ERROR: {
                return new BasicClassicHttpResponse(411, "");
            }
            case WEAK_ETAG_AND_RANGE_ERROR: {
                return new BasicClassicHttpResponse(400, "Weak eTag not compatible with byte range");
            }
            case WEAK_ETAG_ON_PUTDELETE_METHOD_ERROR: {
                return new BasicClassicHttpResponse(400, "Weak eTag not compatible with PUT or DELETE requests");
            }
            case NO_CACHE_DIRECTIVE_WITH_FIELD_NAME: {
                return new BasicClassicHttpResponse(400, "No-Cache directive MUST NOT include a field name");
            }
        }
        throw new IllegalStateException("The request was compliant, therefore no error can be generated for it.");
    }

    private RequestProtocolError requestHasWeakETagAndRange(HttpRequest request) {
        String method = request.getMethod();
        if (!"GET".equals(method)) {
            return null;
        }
        Header range = request.getFirstHeader("Range");
        if (range == null) {
            return null;
        }
        Header ifRange = request.getFirstHeader("If-Range");
        if (ifRange == null) {
            return null;
        }
        String val = ifRange.getValue();
        if (val.startsWith("W/")) {
            return RequestProtocolError.WEAK_ETAG_AND_RANGE_ERROR;
        }
        return null;
    }

    private RequestProtocolError requestHasWeekETagForPUTOrDELETEIfMatch(HttpRequest request) {
        String method = request.getMethod();
        if (!"PUT".equals(method) && !"DELETE".equals(method)) {
            return null;
        }
        Header ifMatch = request.getFirstHeader("If-Match");
        if (ifMatch != null) {
            String val = ifMatch.getValue();
            if (val.startsWith("W/")) {
                return RequestProtocolError.WEAK_ETAG_ON_PUTDELETE_METHOD_ERROR;
            }
        } else {
            Header ifNoneMatch = request.getFirstHeader("If-None-Match");
            if (ifNoneMatch == null) {
                return null;
            }
            String val2 = ifNoneMatch.getValue();
            if (val2.startsWith("W/")) {
                return RequestProtocolError.WEAK_ETAG_ON_PUTDELETE_METHOD_ERROR;
            }
        }
        return null;
    }

    private RequestProtocolError requestContainsNoCacheDirectiveWithFieldName(HttpRequest request) {
        Iterator it = MessageSupport.iterate((MessageHeaders)request, (String)"Cache-Control");
        while (it.hasNext()) {
            HeaderElement elt = (HeaderElement)it.next();
            if (!"no-cache".equalsIgnoreCase(elt.getName()) || elt.getValue() == null) continue;
            return RequestProtocolError.NO_CACHE_DIRECTIVE_WITH_FIELD_NAME;
        }
        return null;
    }
}

