/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hc.client5.http.cache.InputLimit;
import org.apache.hc.client5.http.cache.Resource;
import org.apache.hc.client5.http.cache.ResourceFactory;
import org.apache.hc.client5.http.impl.cache.BasicIdGenerator;
import org.apache.hc.client5.http.impl.cache.FileResource;
import org.apache.hc.client5.http.impl.cache.IOUtils;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class FileResourceFactory
implements ResourceFactory {
    private final File cacheDir;
    private final BasicIdGenerator idgen;

    public FileResourceFactory(File cacheDir) {
        this.cacheDir = cacheDir;
        this.idgen = new BasicIdGenerator();
    }

    private File generateUniqueCacheFile(String requestId) {
        StringBuilder buffer = new StringBuilder();
        this.idgen.generate(buffer);
        buffer.append('.');
        int len = Math.min(requestId.length(), 100);
        for (int i = 0; i < len; ++i) {
            char ch = requestId.charAt(i);
            if (Character.isLetterOrDigit(ch) || ch == '.') {
                buffer.append(ch);
                continue;
            }
            buffer.append('-');
        }
        return new File(this.cacheDir, buffer.toString());
    }

    @Override
    public Resource generate(String requestId, InputStream instream, InputLimit limit) throws IOException {
        File file = this.generateUniqueCacheFile(requestId);
        try (FileOutputStream outstream = new FileOutputStream(file);){
            int l;
            byte[] buf = new byte[2048];
            long total = 0L;
            while ((l = instream.read(buf)) != -1) {
                outstream.write(buf, 0, l);
                if (limit == null || (total += (long)l) <= limit.getValue()) continue;
                limit.reached();
                break;
            }
        }
        return new FileResource(file);
    }

    @Override
    public Resource copy(String requestId, Resource resource) throws IOException {
        File file = this.generateUniqueCacheFile(requestId);
        if (resource instanceof FileResource) {
            File src = ((FileResource)resource).getFile();
            IOUtils.copyFile(src, file);
        } else {
            FileOutputStream out = new FileOutputStream(file);
            IOUtils.copyAndClose(resource.getInputStream(), out);
        }
        return new FileResource(file);
    }
}

