/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.apache.hc.client5.http.cache.HttpCacheEntry;
import org.apache.hc.client5.http.cache.HttpCacheEntrySerializationException;
import org.apache.hc.client5.http.cache.HttpCacheEntrySerializer;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class DefaultHttpCacheEntrySerializer
implements HttpCacheEntrySerializer {
    @Override
    public void writeTo(HttpCacheEntry cacheEntry, OutputStream os) throws IOException {
        try (ObjectOutputStream oos = new ObjectOutputStream(os);){
            oos.writeObject(cacheEntry);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public HttpCacheEntry readFrom(InputStream is) throws IOException {
        try (ObjectInputStream ois = new ObjectInputStream(is);){
            HttpCacheEntry httpCacheEntry = (HttpCacheEntry)ois.readObject();
            return httpCacheEntry;
        }
        catch (ClassNotFoundException ex) {
            throw new HttpCacheEntrySerializationException("Class not found: " + ex.getMessage(), ex);
        }
    }
}

