/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.util.Date;
import org.apache.hc.client5.http.cache.HttpCacheEntry;
import org.apache.hc.client5.http.impl.cache.CacheEntity;
import org.apache.hc.client5.http.impl.cache.CacheValidityPolicy;
import org.apache.hc.client5.http.utils.DateUtils;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.message.BasicClassicHttpResponse;
import org.apache.hc.core5.http.message.BasicHeader;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
class CachedHttpResponseGenerator {
    private final CacheValidityPolicy validityStrategy;

    CachedHttpResponseGenerator(CacheValidityPolicy validityStrategy) {
        this.validityStrategy = validityStrategy;
    }

    CachedHttpResponseGenerator() {
        this(new CacheValidityPolicy());
    }

    ClassicHttpResponse generateResponse(HttpRequest request, HttpCacheEntry entry) {
        long age;
        Date now = new Date();
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(entry.getStatus());
        response.setVersion((ProtocolVersion)HttpVersion.DEFAULT);
        response.setHeaders(entry.getAllHeaders());
        if (this.responseShouldContainEntity(request, entry)) {
            CacheEntity entity = new CacheEntity(entry);
            this.addMissingContentLengthHeader((HttpResponse)response, entity);
            response.setEntity((HttpEntity)entity);
        }
        if ((age = this.validityStrategy.getCurrentAgeSecs(entry, now)) > 0L) {
            if (age >= Integer.MAX_VALUE) {
                response.setHeader("Age", (Object)"2147483648");
            } else {
                response.setHeader("Age", (Object)("" + (int)age));
            }
        }
        return response;
    }

    ClassicHttpResponse generateNotModifiedResponse(HttpCacheEntry entry) {
        Header varyHeader;
        Header cacheControlHeader;
        Header expiresHeader;
        Header contentLocationHeader;
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(304, "Not Modified");
        Header dateHeader = entry.getFirstHeader("Date");
        if (dateHeader == null) {
            dateHeader = new BasicHeader("Date", (Object)DateUtils.formatDate((Date)new Date()));
        }
        response.addHeader(dateHeader);
        Header etagHeader = entry.getFirstHeader("ETag");
        if (etagHeader != null) {
            response.addHeader(etagHeader);
        }
        if ((contentLocationHeader = entry.getFirstHeader("Content-Location")) != null) {
            response.addHeader(contentLocationHeader);
        }
        if ((expiresHeader = entry.getFirstHeader("Expires")) != null) {
            response.addHeader(expiresHeader);
        }
        if ((cacheControlHeader = entry.getFirstHeader("Cache-Control")) != null) {
            response.addHeader(cacheControlHeader);
        }
        if ((varyHeader = entry.getFirstHeader("Vary")) != null) {
            response.addHeader(varyHeader);
        }
        return response;
    }

    private void addMissingContentLengthHeader(HttpResponse response, HttpEntity entity) {
        if (this.transferEncodingIsPresent(response)) {
            return;
        }
        Header contentLength = response.getFirstHeader("Content-Length");
        if (contentLength == null) {
            contentLength = new BasicHeader("Content-Length", (Object)Long.toString(entity.getContentLength()));
            response.setHeader(contentLength);
        }
    }

    private boolean transferEncodingIsPresent(HttpResponse response) {
        Header hdr = response.getFirstHeader("Transfer-Encoding");
        return hdr != null;
    }

    private boolean responseShouldContainEntity(HttpRequest request, HttpCacheEntry cacheEntry) {
        return request.getMethod().equals("GET") && cacheEntry.getResource() != null;
    }
}

