/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.apache.hc.client5.http.cache.HttpCacheEntry;
import org.apache.hc.client5.http.utils.URIUtils;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HeaderElement;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.MessageHeaders;
import org.apache.hc.core5.http.message.MessageSupport;
import org.apache.hc.core5.net.URIBuilder;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
class CacheKeyGenerator {
    private static final URI BASE_URI = URI.create("http://example.com/");

    CacheKeyGenerator() {
    }

    private URI normalize(URI uri) throws URISyntaxException {
        URIBuilder builder = new URIBuilder(URIUtils.resolve((URI)BASE_URI, (URI)uri));
        if (builder.getHost() != null) {
            if (builder.getScheme() == null) {
                builder.setScheme("http");
            }
            if (builder.getPort() == -1) {
                if ("http".equalsIgnoreCase(builder.getScheme())) {
                    builder.setPort(80);
                } else if ("https".equalsIgnoreCase(builder.getScheme())) {
                    builder.setPort(443);
                }
            }
        }
        if (builder.getPath() == null) {
            builder.setPath("/");
        }
        return builder.build();
    }

    public String generateKey(HttpHost host, HttpRequest req) {
        try {
            URI uri = req.getUri();
            if (!uri.isAbsolute()) {
                uri = URIUtils.rewriteURI((URI)uri, (HttpHost)host);
            }
            return this.normalize(uri).toASCIIString();
        }
        catch (URISyntaxException ex) {
            return req.getRequestUri();
        }
    }

    public String generateKey(URL url) {
        if (url == null) {
            return null;
        }
        try {
            return this.normalize(url.toURI()).toASCIIString();
        }
        catch (URISyntaxException ex) {
            return url.toString();
        }
    }

    protected String getFullHeaderValue(Header[] headers) {
        if (headers == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder("");
        for (int i = 0; i < headers.length; ++i) {
            Header hdr = headers[i];
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(hdr.getValue().trim());
        }
        return buf.toString();
    }

    public String generateVariantURI(HttpHost host, HttpRequest req, HttpCacheEntry entry) {
        if (!entry.hasVariants()) {
            return this.generateKey(host, req);
        }
        return this.generateVariantKey(req, entry) + this.generateKey(host, req);
    }

    public String generateVariantKey(HttpRequest req, HttpCacheEntry entry) {
        StringBuilder buf;
        ArrayList<String> variantHeaderNames = new ArrayList<String>();
        Iterator it = MessageSupport.iterate((MessageHeaders)entry, (String)"Vary");
        while (it.hasNext()) {
            HeaderElement elt = (HeaderElement)it.next();
            variantHeaderNames.add(elt.getName());
        }
        Collections.sort(variantHeaderNames);
        try {
            buf = new StringBuilder("{");
            boolean first = true;
            for (String headerName : variantHeaderNames) {
                if (!first) {
                    buf.append("&");
                }
                buf.append(URLEncoder.encode(headerName, StandardCharsets.UTF_8.name()));
                buf.append("=");
                buf.append(URLEncoder.encode(this.getFullHeaderValue(req.getHeaders(headerName)), StandardCharsets.UTF_8.name()));
                first = false;
            }
            buf.append("}");
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("couldn't encode to UTF-8", uee);
        }
        return buf.toString();
    }
}

