/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.testing.auth;

import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.ProtocolException;

public class BasicAuthTokenExtractor {
    public String extract(HttpRequest request) throws HttpException {
        String s;
        String auth = null;
        Header h = request.getFirstHeader("Authorization");
        if (h != null && (s = h.getValue()) != null) {
            auth = s.trim();
        }
        if (auth != null) {
            int i = auth.indexOf(32);
            if (i == -1) {
                throw new ProtocolException("Invalid Authorization header: " + auth);
            }
            String authscheme = auth.substring(0, i);
            if (authscheme.equalsIgnoreCase("basic")) {
                String s2 = auth.substring(i + 1).trim();
                try {
                    byte[] credsRaw = s2.getBytes(StandardCharsets.US_ASCII);
                    Base64 codec = new Base64();
                    auth = new String(codec.decode(credsRaw), StandardCharsets.US_ASCII);
                }
                catch (DecoderException ex) {
                    throw new ProtocolException("Malformed BASIC credentials");
                }
            }
        }
        return auth;
    }
}

