/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.testing.nio;

import java.io.IOException;
import java.net.SocketAddress;
import javax.net.ssl.SSLSession;
import org.apache.hc.core5.http.EndpointDetails;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.impl.nio.HttpConnectionEventHandler;
import org.apache.hc.core5.io.ShutdownType;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.logging.log4j.Logger;

public class LoggingIOEventHandler
implements HttpConnectionEventHandler {
    private final HttpConnectionEventHandler handler;
    private final String id;
    private final Logger log;

    public LoggingIOEventHandler(HttpConnectionEventHandler handler, String id, Logger log) {
        this.handler = handler;
        this.id = id;
        this.log = log;
    }

    public void connected(IOSession session) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(session + " connected");
        }
        this.handler.connected(session);
    }

    public void inputReady(IOSession session) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(session + " input ready");
        }
        this.handler.inputReady(session);
    }

    public void outputReady(IOSession session) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(session + " output ready");
        }
        this.handler.outputReady(session);
    }

    public void timeout(IOSession session) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(session + " timeout");
        }
        this.handler.timeout(session);
    }

    public void exception(IOSession session, Exception cause) {
        this.handler.exception(session, cause);
    }

    public void disconnected(IOSession session) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(session + " disconnected");
        }
        this.handler.disconnected(session);
    }

    public SSLSession getSSLSession() {
        return this.handler.getSSLSession();
    }

    public EndpointDetails getEndpointDetails() {
        return this.handler.getEndpointDetails();
    }

    public void setSocketTimeout(int timeout) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.id + " set timeout " + timeout);
        }
        this.handler.setSocketTimeout(timeout);
    }

    public int getSocketTimeout() {
        return this.handler.getSocketTimeout();
    }

    public ProtocolVersion getProtocolVersion() {
        return this.handler.getProtocolVersion();
    }

    public SocketAddress getRemoteAddress() {
        return this.handler.getRemoteAddress();
    }

    public SocketAddress getLocalAddress() {
        return this.handler.getLocalAddress();
    }

    public boolean isOpen() {
        return this.handler.isOpen();
    }

    public void close() throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.id + " close");
        }
        this.handler.close();
    }

    public void shutdown(ShutdownType shutdownType) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.id + " shutdown");
        }
        this.handler.shutdown(shutdownType);
    }
}

