/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.testing.nio;

import java.io.IOException;
import java.util.List;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpConnection;
import org.apache.hc.core5.http2.frame.FramePrinter;
import org.apache.hc.core5.http2.frame.RawFrame;
import org.apache.hc.core5.http2.impl.nio.Http2StreamListener;
import org.apache.hc.core5.testing.nio.LogAppendable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class InternalHttp2StreamListener
implements Http2StreamListener {
    private final String id;
    private final Logger headerLog;
    private final Logger frameLog;
    private final Logger framePayloadLog;
    private final Logger flowCtrlLog;
    private final FramePrinter framePrinter;

    public InternalHttp2StreamListener(String id) {
        this.id = id;
        this.framePrinter = new FramePrinter();
        this.headerLog = LogManager.getLogger((String)"org.apache.hc.core5.http.headers");
        this.frameLog = LogManager.getLogger((String)"org.apache.hc.core5.http2.frame");
        this.framePayloadLog = LogManager.getLogger((String)"org.apache.hc.core5.http2.frame.payload");
        this.flowCtrlLog = LogManager.getLogger((String)"org.apache.hc.core5.http2.flow");
    }

    private void logFrameInfo(String prefix, RawFrame frame) {
        try {
            LogAppendable logAppendable = new LogAppendable(this.frameLog, prefix);
            this.framePrinter.printFrameInfo(frame, (Appendable)logAppendable);
            logAppendable.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void logFramePayload(String prefix, RawFrame frame) {
        try {
            LogAppendable logAppendable = new LogAppendable(this.framePayloadLog, prefix);
            this.framePrinter.printPayload(frame, (Appendable)logAppendable);
            logAppendable.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void logFlowControl(String prefix, int streamId, int delta, int actualSize) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(prefix).append(" stream ").append(streamId).append(" flow control ").append(delta).append(" -> ").append(actualSize);
        this.flowCtrlLog.debug(buffer.toString());
    }

    public void onHeaderInput(HttpConnection connection, int streamId, List<? extends Header> headers) {
        if (this.headerLog.isDebugEnabled()) {
            for (int i = 0; i < headers.size(); ++i) {
                this.headerLog.debug(this.id + " << " + headers.get(i));
            }
        }
    }

    public void onHeaderOutput(HttpConnection connection, int streamId, List<? extends Header> headers) {
        if (this.headerLog.isDebugEnabled()) {
            for (int i = 0; i < headers.size(); ++i) {
                this.headerLog.debug(this.id + " >> " + headers.get(i));
            }
        }
    }

    public void onFrameInput(HttpConnection connection, int streamId, RawFrame frame) {
        if (this.frameLog.isDebugEnabled()) {
            this.logFrameInfo(this.id + " <<", frame);
        }
        if (this.framePayloadLog.isDebugEnabled()) {
            this.logFramePayload(this.id + " <<", frame);
        }
    }

    public void onFrameOutput(HttpConnection connection, int streamId, RawFrame frame) {
        if (this.frameLog.isDebugEnabled()) {
            this.logFrameInfo(this.id + " >>", frame);
        }
        if (this.framePayloadLog.isDebugEnabled()) {
            this.logFramePayload(this.id + " >>", frame);
        }
    }

    public void onInputFlowControl(HttpConnection connection, int streamId, int delta, int actualSize) {
        if (this.flowCtrlLog.isDebugEnabled()) {
            this.logFlowControl(this.id + " <<", streamId, delta, actualSize);
        }
    }

    public void onOutputFlowControl(HttpConnection connection, int streamId, int delta, int actualSize) {
        if (this.flowCtrlLog.isDebugEnabled()) {
            this.logFlowControl(this.id + " >>", streamId, delta, actualSize);
        }
    }
}

