/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.testing.nio;

import java.util.Iterator;
import org.apache.hc.core5.http.HttpConnection;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.impl.Http1StreamListener;
import org.apache.hc.core5.http.message.RequestLine;
import org.apache.hc.core5.http.message.StatusLine;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class InternalHttp1StreamListener
implements Http1StreamListener {
    private final String id;
    private final Type type;
    private final Logger sessionLog;
    private final Logger headerLog = LogManager.getLogger((String)"org.apache.hc.core5.http.headers");

    public InternalHttp1StreamListener(String id, Type type, Logger sessionLog) {
        this.id = id;
        this.type = type;
        this.sessionLog = sessionLog;
    }

    private String requestDirection() {
        return this.type == Type.CLIENT ? " >> " : " << ";
    }

    private String responseDirection() {
        return this.type == Type.CLIENT ? " << " : " >> ";
    }

    public void onRequestHead(HttpConnection connection, HttpRequest request) {
        if (this.headerLog.isDebugEnabled()) {
            this.headerLog.debug(this.id + this.requestDirection() + new RequestLine(request));
            Iterator it = request.headerIterator();
            while (it.hasNext()) {
                this.headerLog.debug(this.id + this.requestDirection() + it.next());
            }
        }
    }

    public void onResponseHead(HttpConnection connection, HttpResponse response) {
        if (this.headerLog.isDebugEnabled()) {
            this.headerLog.debug(this.id + this.responseDirection() + new StatusLine(response));
            Iterator it = response.headerIterator();
            while (it.hasNext()) {
                this.headerLog.debug(this.id + this.responseDirection() + it.next());
            }
        }
    }

    public void onExchangeComplete(HttpConnection connection, boolean keepAlive) {
        if (this.sessionLog.isDebugEnabled()) {
            if (keepAlive) {
                this.sessionLog.debug(this.id + " Connection is kept alive");
            } else {
                this.sessionLog.debug(this.id + " Connection is not kept alive");
            }
        }
    }

    static enum Type {
        CLIENT,
        SERVER;

    }
}

