/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.testing.nio;

import org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.hc.core5.http.HttpConnection;
import org.apache.hc.core5.http.impl.ConnectionListener;
import org.apache.logging.log4j.Logger;

class InternalConnectionListener
implements ConnectionListener {
    private final String id;
    private final Logger log;

    public InternalConnectionListener(String id, Logger log) {
        this.log = log;
        this.id = id;
    }

    public void onConnect(HttpConnection connection) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.id + " " + connection + " connected");
        }
    }

    public void onDisconnect(HttpConnection connection) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.id + " " + connection + " disconnected");
        }
    }

    public void onError(HttpConnection connection, Exception ex) {
        if (ex instanceof ConnectionClosedException) {
            return;
        }
        this.log.error(this.id + " " + ex.getMessage(), (Throwable)ex);
    }
}

