/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.testing.nio;

import javax.net.ssl.SSLContext;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.apache.hc.core5.http.ContentLengthStrategy;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.config.H1Config;
import org.apache.hc.core5.http.impl.ConnectionListener;
import org.apache.hc.core5.http.impl.DefaultConnectionReuseStrategy;
import org.apache.hc.core5.http.impl.DefaultContentLengthStrategy;
import org.apache.hc.core5.http.impl.Http1StreamListener;
import org.apache.hc.core5.http.impl.nio.ClientHttp1IOEventHandler;
import org.apache.hc.core5.http.impl.nio.ClientHttp1StreamDuplexer;
import org.apache.hc.core5.http.impl.nio.DefaultHttpRequestWriterFactory;
import org.apache.hc.core5.http.impl.nio.DefaultHttpResponseParserFactory;
import org.apache.hc.core5.http.impl.nio.HttpConnectionEventHandler;
import org.apache.hc.core5.http.nio.NHttpMessageParser;
import org.apache.hc.core5.http.nio.NHttpMessageParserFactory;
import org.apache.hc.core5.http.nio.NHttpMessageWriter;
import org.apache.hc.core5.http.nio.NHttpMessageWriterFactory;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.reactor.IOEventHandler;
import org.apache.hc.core5.reactor.IOEventHandlerFactory;
import org.apache.hc.core5.reactor.TlsCapableIOSession;
import org.apache.hc.core5.testing.nio.InternalConnectionListener;
import org.apache.hc.core5.testing.nio.InternalHttp1StreamListener;
import org.apache.hc.core5.testing.nio.LoggingIOEventHandler;
import org.apache.hc.core5.testing.nio.LoggingIOSession;
import org.apache.hc.core5.util.Args;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
class InternalClientHttp1EventHandlerFactory
implements IOEventHandlerFactory {
    private final HttpProcessor httpProcessor;
    private final H1Config h1Config;
    private final CharCodingConfig charCodingConfig;
    private final ConnectionReuseStrategy connectionReuseStrategy;
    private final SSLContext sslContext;
    private final NHttpMessageParserFactory<HttpResponse> responseParserFactory;
    private final NHttpMessageWriterFactory<HttpRequest> requestWriterFactory;

    InternalClientHttp1EventHandlerFactory(HttpProcessor httpProcessor, H1Config h1Config, CharCodingConfig charCodingConfig, ConnectionReuseStrategy connectionReuseStrategy, SSLContext sslContext) {
        this.httpProcessor = (HttpProcessor)Args.notNull((Object)httpProcessor, (String)"HTTP processor");
        this.h1Config = h1Config != null ? h1Config : H1Config.DEFAULT;
        this.charCodingConfig = charCodingConfig != null ? charCodingConfig : CharCodingConfig.DEFAULT;
        this.connectionReuseStrategy = connectionReuseStrategy != null ? connectionReuseStrategy : DefaultConnectionReuseStrategy.INSTANCE;
        this.sslContext = sslContext;
        this.responseParserFactory = new DefaultHttpResponseParserFactory(this.h1Config);
        this.requestWriterFactory = DefaultHttpRequestWriterFactory.INSTANCE;
    }

    protected ClientHttp1StreamDuplexer createClientHttp1StreamDuplexer(TlsCapableIOSession ioSession, HttpProcessor httpProcessor, H1Config h1Config, CharCodingConfig charCodingConfig, ConnectionReuseStrategy connectionReuseStrategy, NHttpMessageParser<HttpResponse> incomingMessageParser, NHttpMessageWriter<HttpRequest> outgoingMessageWriter, ContentLengthStrategy incomingContentStrategy, ContentLengthStrategy outgoingContentStrategy, ConnectionListener connectionListener, Http1StreamListener streamListener) {
        return new ClientHttp1StreamDuplexer(ioSession, httpProcessor, h1Config, charCodingConfig, connectionReuseStrategy, incomingMessageParser, outgoingMessageWriter, incomingContentStrategy, outgoingContentStrategy, connectionListener, streamListener);
    }

    public IOEventHandler createHandler(TlsCapableIOSession ioSession, Object attachment) {
        String id = ioSession.getId();
        if (this.sslContext != null) {
            ioSession.startTls(this.sslContext, null, null, null);
        }
        Logger sessionLog = LogManager.getLogger(ioSession.getClass());
        Logger wireLog = LogManager.getLogger((String)"org.apache.hc.core5.http.wire");
        ClientHttp1StreamDuplexer streamDuplexer = this.createClientHttp1StreamDuplexer(new LoggingIOSession(ioSession, sessionLog, wireLog), this.httpProcessor, this.h1Config, this.charCodingConfig, this.connectionReuseStrategy, (NHttpMessageParser<HttpResponse>)this.responseParserFactory.create(), (NHttpMessageWriter<HttpRequest>)this.requestWriterFactory.create(), (ContentLengthStrategy)DefaultContentLengthStrategy.INSTANCE, (ContentLengthStrategy)DefaultContentLengthStrategy.INSTANCE, new InternalConnectionListener(id, sessionLog), new InternalHttp1StreamListener(id, InternalHttp1StreamListener.Type.CLIENT, sessionLog));
        return new LoggingIOEventHandler((HttpConnectionEventHandler)new ClientHttp1IOEventHandler(streamDuplexer), id, sessionLog);
    }
}

