/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.testing.nio;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.core5.concurrent.DefaultThreadFactory;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.http.ExceptionListener;
import org.apache.hc.core5.http.nio.command.ShutdownCommand;
import org.apache.hc.core5.io.ShutdownType;
import org.apache.hc.core5.reactor.AbstractMultiworkerIOReactor;
import org.apache.hc.core5.reactor.Command;
import org.apache.hc.core5.reactor.ExceptionEvent;
import org.apache.hc.core5.reactor.IOEventHandlerFactory;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.reactor.IOReactorStatus;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.testing.nio.Http1TestClient;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Asserts;
import org.apache.hc.core5.util.TimeValue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

abstract class IOReactorExecutor<T extends AbstractMultiworkerIOReactor>
implements AutoCloseable {
    private final Logger log = LogManager.getLogger(Http1TestClient.class);
    private final IOReactorConfig ioReactorConfig;
    private final ExceptionListener exceptionListener;
    private final ExecutorService executorService;
    private final ThreadFactory workerThreadFactory;
    private final AtomicReference<T> ioReactorRef;
    private final AtomicReference<Status> status;

    IOReactorExecutor(IOReactorConfig ioReactorConfig, ThreadFactory threadFactory, ThreadFactory workerThreadFactory) {
        this.ioReactorConfig = ioReactorConfig != null ? ioReactorConfig : IOReactorConfig.DEFAULT;
        this.exceptionListener = new ExceptionListener(){

            public void onError(Exception ex) {
                IOReactorExecutor.this.log.error(ex.getMessage(), (Throwable)ex);
            }
        };
        this.executorService = Executors.newSingleThreadExecutor(threadFactory);
        this.workerThreadFactory = workerThreadFactory;
        this.ioReactorRef = new AtomicReference<Object>(null);
        this.status = new AtomicReference<Status>(Status.READY);
    }

    abstract T createIOReactor(IOEventHandlerFactory var1, IOReactorConfig var2, ThreadFactory var3, Callback<IOSession> var4) throws IOException;

    protected void execute(IOEventHandlerFactory ioEventHandlerFactory) throws IOException {
        Args.notNull((Object)ioEventHandlerFactory, (String)"Handler factory");
        if (this.ioReactorRef.compareAndSet(null, this.createIOReactor(ioEventHandlerFactory, this.ioReactorConfig, this.workerThreadFactory != null ? this.workerThreadFactory : new DefaultThreadFactory("i/o dispatch"), new Callback<IOSession>(){

            public void execute(IOSession session) {
                session.addFirst((Command)new ShutdownCommand(ShutdownType.GRACEFUL));
            }
        }))) {
            if (this.status.compareAndSet(Status.READY, Status.RUNNING)) {
                this.executorService.execute(new Runnable(){

                    @Override
                    public void run() {
                        block2: {
                            try {
                                ((AbstractMultiworkerIOReactor)IOReactorExecutor.this.ioReactorRef.get()).execute();
                            }
                            catch (Exception ex) {
                                if (IOReactorExecutor.this.exceptionListener == null) break block2;
                                IOReactorExecutor.this.exceptionListener.onError(ex);
                            }
                        }
                    }
                });
            }
        } else {
            throw new IllegalStateException("I/O reactor has already been started");
        }
    }

    private T ensureRunning() {
        AbstractMultiworkerIOReactor ioReactor = (AbstractMultiworkerIOReactor)this.ioReactorRef.get();
        Asserts.check((ioReactor != null ? 1 : 0) != 0, (String)"I/O reactor has not been started");
        return (T)ioReactor;
    }

    T reactor() {
        return this.ensureRunning();
    }

    public IOReactorStatus getStatus() {
        AbstractMultiworkerIOReactor ioReactor = (AbstractMultiworkerIOReactor)this.ioReactorRef.get();
        return ioReactor != null ? ioReactor.getStatus() : IOReactorStatus.INACTIVE;
    }

    public List<ExceptionEvent> getAuditLog() {
        T ioReactor = this.ensureRunning();
        return ioReactor.getAuditLog();
    }

    public void awaitShutdown(TimeValue waitTime) throws InterruptedException {
        Args.notNull((Object)waitTime, (String)"Wait time");
        AbstractMultiworkerIOReactor ioReactor = (AbstractMultiworkerIOReactor)this.ioReactorRef.get();
        if (ioReactor != null) {
            ioReactor.awaitShutdown(waitTime);
        }
    }

    public void initiateShutdown() {
        AbstractMultiworkerIOReactor ioReactor = (AbstractMultiworkerIOReactor)this.ioReactorRef.get();
        if (ioReactor != null && this.status.compareAndSet(Status.RUNNING, Status.TERMINATED)) {
            ioReactor.initiateShutdown();
        }
    }

    public void shutdown(TimeValue graceTime) {
        Args.notNull((Object)graceTime, (String)"Grace time");
        AbstractMultiworkerIOReactor ioReactor = (AbstractMultiworkerIOReactor)this.ioReactorRef.get();
        if (ioReactor != null) {
            if (this.status.compareAndSet(Status.RUNNING, Status.TERMINATED)) {
                ioReactor.initiateShutdown();
            }
            try {
                ioReactor.awaitShutdown(graceTime);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            ioReactor.shutdown(ShutdownType.IMMEDIATE);
        }
    }

    @Override
    public void close() throws Exception {
        this.shutdown(TimeValue.ofSeconds((long)5L));
    }

    static enum Status {
        READY,
        RUNNING,
        TERMINATED;

    }
}

