/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.testing.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import javax.net.ssl.SSLContext;
import org.apache.hc.core5.function.Supplier;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.config.H1Config;
import org.apache.hc.core5.http.impl.HttpProcessors;
import org.apache.hc.core5.http.impl.bootstrap.AsyncServerExchangeHandlerRegistry;
import org.apache.hc.core5.http.nio.AsyncServerExchangeHandler;
import org.apache.hc.core5.http.nio.HandlerFactory;
import org.apache.hc.core5.http.nio.support.BasicServerExchangeHandler;
import org.apache.hc.core5.http.nio.support.RequestConsumerSupplier;
import org.apache.hc.core5.http.nio.support.ResponseHandler;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.http2.HttpVersionPolicy;
import org.apache.hc.core5.http2.config.H2Config;
import org.apache.hc.core5.http2.impl.Http2Processors;
import org.apache.hc.core5.reactor.IOEventHandlerFactory;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.reactor.ListenerEndpoint;
import org.apache.hc.core5.testing.nio.AsyncServer;
import org.apache.hc.core5.testing.nio.InternalServerHttp2EventHandlerFactory;

public class Http2TestServer
extends AsyncServer {
    private final SSLContext sslContext;
    private final AsyncServerExchangeHandlerRegistry handlerRegistry;

    public Http2TestServer(IOReactorConfig ioReactorConfig, SSLContext sslContext) throws IOException {
        super(ioReactorConfig);
        this.sslContext = sslContext;
        this.handlerRegistry = new AsyncServerExchangeHandlerRegistry("localhost");
    }

    public Http2TestServer() throws IOException {
        this(IOReactorConfig.DEFAULT, null);
    }

    public void register(String uriPattern, Supplier<AsyncServerExchangeHandler> supplier) {
        this.handlerRegistry.register(null, uriPattern, supplier);
    }

    public <T> void register(String uriPattern, final RequestConsumerSupplier<T> consumerSupplier, final ResponseHandler<T> responseHandler) {
        this.register(uriPattern, new Supplier<AsyncServerExchangeHandler>(){

            public AsyncServerExchangeHandler get() {
                return new BasicServerExchangeHandler(consumerSupplier, responseHandler);
            }
        });
    }

    public void start(IOEventHandlerFactory handlerFactory) throws IOException {
        this.execute(handlerFactory);
    }

    public InetSocketAddress start(HttpProcessor httpProcessor, H2Config h2Config) throws Exception {
        this.start(new InternalServerHttp2EventHandlerFactory(httpProcessor, (HandlerFactory<AsyncServerExchangeHandler>)this.handlerRegistry, HttpVersionPolicy.FORCE_HTTP_2, h2Config, H1Config.DEFAULT, CharCodingConfig.DEFAULT, this.sslContext));
        ListenerEndpoint listener = this.listen(new InetSocketAddress(0));
        listener.waitFor();
        return (InetSocketAddress)listener.getAddress();
    }

    public InetSocketAddress start(HttpProcessor httpProcessor, H1Config h1Config) throws Exception {
        this.start(new InternalServerHttp2EventHandlerFactory(httpProcessor, (HandlerFactory<AsyncServerExchangeHandler>)this.handlerRegistry, HttpVersionPolicy.FORCE_HTTP_1, H2Config.DEFAULT, h1Config, CharCodingConfig.DEFAULT, this.sslContext));
        ListenerEndpoint listener = this.listen(new InetSocketAddress(0));
        listener.waitFor();
        return (InetSocketAddress)listener.getAddress();
    }

    public InetSocketAddress start(H2Config h2Config) throws Exception {
        return this.start(Http2Processors.server(), h2Config);
    }

    public InetSocketAddress start(H1Config h1Config) throws Exception {
        return this.start(HttpProcessors.server(), h1Config);
    }

    public InetSocketAddress start() throws Exception {
        return this.start(H2Config.DEFAULT);
    }
}

